/*
 * Decompiled with CFR 0.152.
 */
package com.hystrix.configurator.config;

public class CommandThreadPoolConfig {
    private boolean semaphoreIsolation = false;
    private String pool;
    private int concurrency = 8;
    private int maxRequestQueueSize = 128;
    private int dynamicRequestQueueSize = 16;
    private int timeout = 1000;

    public CommandThreadPoolConfig(boolean semaphoreIsolation, String pool, int concurrency, int maxRequestQueueSize, int dynamicRequestQueueSize, int timeout) {
        this.semaphoreIsolation = semaphoreIsolation;
        this.pool = pool;
        this.concurrency = concurrency;
        this.maxRequestQueueSize = maxRequestQueueSize;
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
        this.timeout = timeout;
    }

    public static CommandThreadPoolConfigBuilder builder() {
        return new CommandThreadPoolConfigBuilder();
    }

    public boolean isSemaphoreIsolation() {
        return this.semaphoreIsolation;
    }

    public String getPool() {
        return this.pool;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public int getDynamicRequestQueueSize() {
        return this.dynamicRequestQueueSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setSemaphoreIsolation(boolean semaphoreIsolation) {
        this.semaphoreIsolation = semaphoreIsolation;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setMaxRequestQueueSize(int maxRequestQueueSize) {
        this.maxRequestQueueSize = maxRequestQueueSize;
    }

    public void setDynamicRequestQueueSize(int dynamicRequestQueueSize) {
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandThreadPoolConfig)) {
            return false;
        }
        CommandThreadPoolConfig other = (CommandThreadPoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSemaphoreIsolation() != other.isSemaphoreIsolation()) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getMaxRequestQueueSize() != other.getMaxRequestQueueSize()) {
            return false;
        }
        if (this.getDynamicRequestQueueSize() != other.getDynamicRequestQueueSize()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$pool = this.getPool();
        String other$pool = other.getPool();
        return !(this$pool == null ? other$pool != null : !this$pool.equals(other$pool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandThreadPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSemaphoreIsolation() ? 79 : 97);
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getMaxRequestQueueSize();
        result = result * 59 + this.getDynamicRequestQueueSize();
        result = result * 59 + this.getTimeout();
        String $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : $pool.hashCode());
        return result;
    }

    public String toString() {
        return "CommandThreadPoolConfig(semaphoreIsolation=" + this.isSemaphoreIsolation() + ", pool=" + this.getPool() + ", concurrency=" + this.getConcurrency() + ", maxRequestQueueSize=" + this.getMaxRequestQueueSize() + ", dynamicRequestQueueSize=" + this.getDynamicRequestQueueSize() + ", timeout=" + this.getTimeout() + ")";
    }

    public CommandThreadPoolConfig() {
    }

    public static class CommandThreadPoolConfigBuilder {
        private String pool;
        private boolean semaphoreIsolation = false;
        private int concurrency = Runtime.getRuntime().availableProcessors();
        private int maxRequestQueueSize = Runtime.getRuntime().availableProcessors() * 4;
        private int dynamicRequestQueueSize = Runtime.getRuntime().availableProcessors() * 2;
        private int timeout = 1000;

        CommandThreadPoolConfigBuilder() {
        }

        public CommandThreadPoolConfigBuilder semaphoreIsolation(boolean semaphoreIsolation) {
            this.semaphoreIsolation = semaphoreIsolation;
            return this;
        }

        public CommandThreadPoolConfigBuilder pool(String pool) {
            this.pool = pool;
            return this;
        }

        public CommandThreadPoolConfigBuilder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public CommandThreadPoolConfigBuilder maxRequestQueueSize(int maxRequestQueueSize) {
            this.maxRequestQueueSize = maxRequestQueueSize;
            return this;
        }

        public CommandThreadPoolConfigBuilder dynamicRequestQueueSize(int dynamicRequestQueueSize) {
            this.dynamicRequestQueueSize = dynamicRequestQueueSize;
            return this;
        }

        public CommandThreadPoolConfigBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public CommandThreadPoolConfig build() {
            return new CommandThreadPoolConfig(this.semaphoreIsolation, this.pool, this.concurrency, this.maxRequestQueueSize, this.dynamicRequestQueueSize, this.timeout);
        }

        public String toString() {
            return "CommandThreadPoolConfig.CommandThreadPoolConfigBuilder(semaphoreIsolation=" + this.semaphoreIsolation + ", pool=" + this.pool + ", concurrency=" + this.concurrency + ", maxRequestQueueSize=" + this.maxRequestQueueSize + ", dynamicRequestQueueSize=" + this.dynamicRequestQueueSize + ", timeout=" + this.timeout + ")";
        }
    }
}

