(ns hypercrud.transit
  (:require [cognitect.transit :as t]
            [hypercrud.types.DbVal :refer [->DbVal #?(:cljs DbVal)]]
            [hypercrud.types.EntityRequest :refer [->EntityRequest #?(:cljs EntityRequest)]]
            [hypercrud.types.Err :refer [->Err #?(:cljs Err)]]
            [hypercrud.types.QueryRequest :refer [->QueryRequest #?(:cljs QueryRequest)]])
  #?(:clj
     (:import (hypercrud.types.DbVal DbVal)
              (hypercrud.types.EntityRequest EntityRequest)
              (hypercrud.types.Err Err)
              (hypercrud.types.QueryRequest QueryRequest))))


(def read-handlers
  {"DbVal" (t/read-handler #(apply ->DbVal %))
   "EReq" (t/read-handler #(apply ->EntityRequest %))
   "err" (t/read-handler ->Err)
   "QReq" (t/read-handler #(apply ->QueryRequest %))})

(def write-handlers
  {DbVal
   (t/write-handler (constantly "DbVal") (fn [v] [(:uri v) (:branch v)]))

   EntityRequest
   (t/write-handler (constantly "EReq") (fn [v] [(:e v) (:a v) (:db v) (:pull-exp v)]))

   Err
   (t/write-handler (constantly "err") #(:msg %))

   QueryRequest
   (t/write-handler (constantly "QReq") (fn [v] [(:query v) (:params v) (:pull-exps v)]))})
