(ns hypercrud.util.branch
  (:require [clojure.string :as str]))


(defn decode-parent-branch [branch]
  (let [parent (second (re-find #"(.*)`.*" branch))]
    (if (str/blank? parent)
      nil
      parent)))

(defn encode-branch-child [parent-branch child-id-str]
  (if (str/blank? child-id-str)
    parent-branch
    (str parent-branch "`" child-id-str)))
