(ns geoffreygaillard.logger
  (:require #?(:clj [clojure.tools.logging :as log])
            [clojure.string :as str])
  #?(:cljs (:require-macros [geoffreygaillard.logger])))

#?(:clj
   (defn clj-log [level ns-sym location & args]
     (let [logger__321__auto__ (clojure.tools.logging.impl/get-logger
                                 log/*logger-factory*
                                 (find-ns ns-sym))]
       (if (clojure.tools.logging.impl/enabled? logger__321__auto__ level)
         (let [x__322__auto__ (first args)]
           (if (instance? java.lang.Throwable x__322__auto__)
             (log/log*
               logger__321__auto__
               level
               x__322__auto__
               (apply print-str location (rest args)))
             (log/log*
               logger__321__auto__
               level
               nil
               (apply print-str location x__322__auto__ (rest args)))))))))

#?(:cljs (defn cljs-log [level location & args]
           (apply (case level (:fatal, :error) js/console.error, :warn js/console.warn, :info js/console.info, :debug js/console.debug, :trace js/console.trace js/console.log)
             (str/upper-case (name level))
             location
             (let [[ex? & args] args]
               (if (instance? js/Error ex?)
                 (concat args (list ex?))
                 (cons ex? args))))))

(defn location [form]
  (let [{:keys [line column]} (meta form)]
    (str line ":" column)))

(defn log-fn [level ns-sym location & args]
  #?(:clj (apply clj-log level ns-sym location args)
     :cljs (apply cljs-log level (str ns-sym ":" location) args)))

(defmacro log* [level & args] `(log-fn ~level '~(ns-name *ns*) ~(location &form) ~@args))


(defmacro fatal [& args] `(log* :fatal ~@args))
(defmacro error [& args] `(log* :error ~@args))
(defmacro warn  [& args] `(log* :warn ~@args))
(defmacro info  [& args] `(log* :info ~@args))
(defmacro log   [& args] `(log* :log ~@args))
(defmacro debug [& args] `(log* :debug ~@args))
(defmacro trace [& args] `(log* :trace ~@args))