(ns geoffreygaillard.predicates
  "Collection of generic predicates not found in clojure.core"
  (:require [clojure.string :as str]))

(defn namespace? "Returns true if x is a namespace."
  [object]
  #?(:clj  (instance? clojure.lang.Namespace object)
     :cljs (instance? cljs.core/Namespace object)))

(defn atom? "State if object is an Atom."
  [object]
  (instance? #?(:clj clojure.lang.Atom :cljs cljs.core.Atom) object))

(defn atom-like? "State if object supports swap! and reset!. More generic than `atom?`."
  [object]
  #?(:clj (instance? clojure.lang.IAtom object)
     :cljs (satisfies? cljs.core.IAtom object)))

(defn dotted-symbol? "e.g. .foo" [sym]
  (and (symbol? sym) (str/starts-with? (name sym) ".")))

(defn java-method-symbol? "e.g. Files/.listFiles" [sym]
  (and (qualified-symbol? sym) (dotted-symbol? sym)))
