(ns geoffreygaillard.debug-tools
  #?(:clj (:require [clojure.tools.logging :as log]))
  #?(:cljs (:require-macros [geoffreygaillard.debug-tools :refer [debug-exceptions]])))

(defn debug! [ns label err]
  #?(:clj (log/debug err ns label)
     :cljs (.debug js/console ns label err)))

(defmacro debug-exceptions
  {:style/indent 1}
  [label & body]
  `(try
     ~@body
     (catch ~(if (:js-globals &env) :default 'Throwable) err#
       (debug! '~(or (some-> &env :ns :name) (ns-name *ns*)) ~label err#)
       (throw err#))))