(ns hyperfiddle.electric.impl.debouncer

  "Run a task as soon as there is room to run it.
  Used at the network layer to prevent propagations in-between messages batch.
  Client or Server want to relieve received and sent messages, especially when the socket buffer is full."
  (:require [missionary.core :as m])
  #?(:clj (:import [java.util.concurrent PriorityBlockingQueue ThreadPoolExecutor TimeUnit])))

(defn relieve-incomming-messages [subject]
  #?(:clj
     (let [messages (java.util.ArrayList.)]
       (fn [!]
         (subject (fn [message]
                    (! (seq (.toArray messages)))
                    (.add messages message)))))
     :cljs
     (let [messages (array)]
       (fn [!]
         (subject (fn [message]
                    (when (== 0 (.-length messages))
                      (.requestAnimationFrame js/window #(! (array-seq (.splice messages 0)))))
                    (.push messages message)))))))

