(ns contrib.hash-map
  (:refer-clojure :exclude [get])
  (:import [java.util HashMap]))

(set! *warn-on-reflection* true)

(defn create [] (HashMap.))
(defn put [^HashMap hm k v] (doto hm (.put k v)))
;; computeIfAbsent won't put in a null value (??), so we use the slower approach
(defn ?put [^HashMap hm k thunk] (if (.containsKey hm k) hm (doto hm (.put k (thunk)))))
(defn get [^HashMap hm k] (.get hm k))
(defn ->persistent [^HashMap hm] (into {} hm))
