(ns contrib.elog)

(set! *warn-on-reflection* true)

(defonce !loggers (atom {}))

(defn in-memory-logger []
  (let [!logs (atom [])]
    (fn
      ([] @!logs)
      ([e] (swap! !logs conj e)))))

(defmacro log
  ([typ code] `(log ~typ {} ~code))
  ([typ info code]
   `(let [typ# ~typ, info# ~info
          t0# (System/nanoTime)
          [ok?# v#] (try (do [true ~code]) (catch Throwable e# [false e#]))
          took# (- (System/nanoTime) t0#)
          e# (assoc info# ::type typ#, ::body '~code, ::t took#, (if ok?# ::v ::err) v#)]
      (run! #(% e#) (vals @!loggers))
      (if ok?# v# (throw v#)))))
