(ns hyperfiddle.electric.shadow-cljs.clojure-tools-logging-aot-fix
  ;; This ns exists as a fix for some AOTed nss depending on
  ;; clojure.tools.logging, which doesn't play well with AOT.
  ;; clojure.tools.logging/log is a macro expanding the LoggerFactory in-place.
  ;; AOTing a namespace calling tools.logging/log pins the LoggerFactory
  ;; version. We must not ship a library with a pinner logger version. But if we
  ;; don't ship it, dependencies will log an undesirable error message (e.g.
  ;; starter app on boot). This ns serves as an indirection. Do not AOT this
  ;; namespace, include it as-is in the library artifact.
  ;; Pro: doesn't pin a LoggerFactory's version
  ;; Con: API is rudimentary, but it doesn't matter to our use case.
  (:require [clojure.tools.logging :as log]))

(defn trace* [ns & args]
  (let [s (apply print-str args)]
    (log/log ns :trace nil s)))

(defn debug* [ns & args]
  (let [s (apply print-str args)]
    (log/log ns :debug nil s)))

(defmacro trace [& args] `(trace* ~*ns* ~@args))
(defmacro debug [& args] `(debug* ~*ns* ~@args))
