// Compiled by ClojureScript 1.10.773 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('react_dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.input');
goog.require('reagent.impl.batching');
goog.require('reagent.impl.protocols');
goog.require('reagent.ratom');
reagent.dom.global$module$react_dom = goog.global["ReactDOM"];
if((typeof reagent !== 'undefined') && (typeof reagent.dom !== 'undefined') && (typeof reagent.dom.roots !== 'undefined')){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return reagent.dom.global$module$react_dom.unmountComponentAtNode(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR__orig_val__18562 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__18563 = true;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__18563);

try{return reagent.dom.global$module$react_dom.render(comp.call(null),container,(function (){
var _STAR_always_update_STAR__orig_val__18564 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__18565 = false;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__18565);

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,comp);

reagent.impl.batching.flush_after_render.call(null);

if((!((callback == null)))){
return callback.call(null);
} else {
return null;
}
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__18564);
}}));
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__18562);
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element.
 *   The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var G__18567 = arguments.length;
switch (G__18567) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,reagent.impl.template.default_compiler);
}));

(reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback_or_compiler){
reagent.ratom.flush_BANG_.call(null);

var vec__18568 = ((cljs.core.fn_QMARK_.call(null,callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.impl.template.default_compiler,callback_or_compiler], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [callback_or_compiler,new cljs.core.Keyword(null,"callback","callback",-705136228).cljs$core$IFn$_invoke$arity$1(callback_or_compiler)], null));
var compiler = cljs.core.nth.call(null,vec__18568,(0),null);
var callback = cljs.core.nth.call(null,vec__18568,(1),null);
var f = (function (){
return reagent.impl.protocols.as_element.call(null,compiler,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
}));

(reagent.dom.render.cljs$lang$maxFixedArity = 3);

/**
 * Remove a component from the given DOM node.
 */
reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return reagent.dom.global$module$react_dom.findDOMNode(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__18572_18588 = cljs.core.seq.call(null,cljs.core.deref.call(null,reagent.dom.roots));
var chunk__18573_18589 = null;
var count__18574_18590 = (0);
var i__18575_18591 = (0);
while(true){
if((i__18575_18591 < count__18574_18590)){
var vec__18582_18592 = cljs.core._nth.call(null,chunk__18573_18589,i__18575_18591);
var container_18593 = cljs.core.nth.call(null,vec__18582_18592,(0),null);
var comp_18594 = cljs.core.nth.call(null,vec__18582_18592,(1),null);
reagent.dom.re_render_component.call(null,comp_18594,container_18593);


var G__18595 = seq__18572_18588;
var G__18596 = chunk__18573_18589;
var G__18597 = count__18574_18590;
var G__18598 = (i__18575_18591 + (1));
seq__18572_18588 = G__18595;
chunk__18573_18589 = G__18596;
count__18574_18590 = G__18597;
i__18575_18591 = G__18598;
continue;
} else {
var temp__5804__auto___18599 = cljs.core.seq.call(null,seq__18572_18588);
if(temp__5804__auto___18599){
var seq__18572_18600__$1 = temp__5804__auto___18599;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18572_18600__$1)){
var c__4556__auto___18601 = cljs.core.chunk_first.call(null,seq__18572_18600__$1);
var G__18602 = cljs.core.chunk_rest.call(null,seq__18572_18600__$1);
var G__18603 = c__4556__auto___18601;
var G__18604 = cljs.core.count.call(null,c__4556__auto___18601);
var G__18605 = (0);
seq__18572_18588 = G__18602;
chunk__18573_18589 = G__18603;
count__18574_18590 = G__18604;
i__18575_18591 = G__18605;
continue;
} else {
var vec__18585_18606 = cljs.core.first.call(null,seq__18572_18600__$1);
var container_18607 = cljs.core.nth.call(null,vec__18585_18606,(0),null);
var comp_18608 = cljs.core.nth.call(null,vec__18585_18606,(1),null);
reagent.dom.re_render_component.call(null,comp_18608,container_18607);


var G__18609 = cljs.core.next.call(null,seq__18572_18600__$1);
var G__18610 = null;
var G__18611 = (0);
var G__18612 = (0);
seq__18572_18588 = G__18609;
chunk__18573_18589 = G__18610;
count__18574_18590 = G__18611;
i__18575_18591 = G__18612;
continue;
}
} else {
}
}
break;
}

return reagent.impl.batching.flush_after_render.call(null);
});

//# sourceMappingURL=dom.js.map
