(ns sail.parse
  "Parse CSS into Clojure data structures to compare our output with official Tailwind CSS"
  (:require [clojure.string]))

(defn class-names
  "Returns classnames present in the given CSS string."
  [css]
  (->> (clojure.string/split css #"\{[^\{\}]*\}")
       (map clojure.string/trim)))

(defn parse
  "Transforms a string of CSS into a map."
  [css]
  (clojure.string/split css #"\{.*\}")
  )


(def example-css ".paragraph {margin: 0; padding: 0; color: #080}")
(def example-two-class-css ".paragraph {margin: 0; padding: 0; color: #080} .another-paragraph {margin: 2;}")
;; example with comment
(def tailwindcss (slurp "test.css"))
(def sailcss (slurp "target/public/styles.gen.css"))

(comment
  (class-names example-css)
  (class-names example-two-class-css)
  ;; apparently sail has 2k more classes than the full implementation of
  ;; tailwindcss. doubtful.. my regex ignores nested classes (probably).
  (count (class-names sailcss))
  (count (class-names tailwindcss))
  (def x (parse-all ruleset tailwindcss))
  (def y (parse-all ruleset sailcss))
  )
