/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.webdav.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.www.webdav.xml.DAVActiveLock;
import org.w3c.www.webdav.xml.DAVLockInfo;
import org.w3c.www.webdav.xml.DAVMultiStatus;
import org.w3c.www.webdav.xml.DAVNode;
import org.w3c.www.webdav.xml.DAVPropFind;
import org.w3c.www.webdav.xml.DAVPropertyBehavior;
import org.w3c.www.webdav.xml.DAVPropertyUpdate;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DAVBody
implements ErrorHandler {
    protected static DOMParser parser = null;
    protected static DOMImplementation domimpl = null;
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setDeferredDOM = true;
    protected Document document = null;

    public static synchronized Document getDocument(InputStream inputStream, ErrorHandler errorHandler) throws IOException, SAXException {
        parser.setErrorHandler(errorHandler);
        InputSource inputSource = new InputSource(inputStream);
        parser.parse(inputSource);
        return parser.getDocument();
    }

    public DAVMultiStatus getMultiStatus() {
        Node node = DAVNode.getDAVNode(this.document, "multistatus");
        if (node != null) {
            return new DAVMultiStatus((Element)node);
        }
        return null;
    }

    public DAVPropertyBehavior getPropertyBehavior() {
        Node node = DAVNode.getDAVNode(this.document, "propertybehavior");
        if (node != null) {
            return new DAVPropertyBehavior((Element)node);
        }
        return null;
    }

    public DAVPropertyUpdate getPropertyUpdate() {
        Node node = DAVNode.getDAVNode(this.document, "propertyupdate");
        if (node != null) {
            return new DAVPropertyUpdate((Element)node);
        }
        return null;
    }

    public DAVPropFind getPropFind() {
        Node node = DAVNode.getDAVNode(this.document, "propfind");
        if (node != null) {
            return new DAVPropFind((Element)node);
        }
        return null;
    }

    public DAVActiveLock getActiveLock() {
        Node node = DAVNode.getDAVNode(this.document, "activelock");
        if (node != null) {
            return new DAVActiveLock((Element)node);
        }
        return null;
    }

    public DAVLockInfo getLockInfo() {
        Node node = DAVNode.getDAVNode(this.document, "lockinfo");
        if (node != null) {
            return new DAVLockInfo((Element)node);
        }
        return null;
    }

    public static Document createDocument(String string) {
        Document document = domimpl.createDocument("DAV:", "D:" + string, null);
        Element element = document.getDocumentElement();
        try {
            element.setAttribute("xmlns:D", "DAV:");
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
        return document;
    }

    public static Document createDocumentNS(String string, String string2, String string3) {
        Document document = DAVBody.createDocument(string);
        Element element = document.getDocumentElement();
        try {
            element.setAttribute("xmlns:" + string3, string2);
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
        return document;
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public DAVBody(InputStream inputStream) throws IOException, SAXException {
        this.document = DAVBody.getDocument(inputStream, this);
    }

    static {
        parser = new DOMParser();
        domimpl = new DocumentImpl().getImplementation();
        try {
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", setDeferredDOM);
            parser.setFeature("http://xml.org/sax/features/validation", setValidation);
            parser.setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
            parser.setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

