/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.widgets;

import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.StringTokenizer;
import org.w3c.tools.widgets.TextEditable;

public class IPTextField
extends Panel
implements TextEditable {
    protected TextField[] fields = null;
    transient ActionListener actionListener;
    String command = "";

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void fireActionEvent() {
        if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.command);
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    private String getFieldValue(TextField textField) {
        String string = textField.getText();
        if (string == null) {
            return "0";
        }
        if (string.length() == 0) {
            return "0";
        }
        return string;
    }

    public String getText() {
        return this.getFieldValue(this.fields[0]) + "." + this.getFieldValue(this.fields[1]) + "." + this.getFieldValue(this.fields[2]) + "." + this.getFieldValue(this.fields[3]);
    }

    public void setText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (n < 4 && stringTokenizer.hasMoreTokens()) {
            this.fields[n++].setText(stringTokenizer.nextToken());
        }
    }

    public boolean updated() {
        return !this.getText().equals("0.0.0.0");
    }

    public void setDefault() {
        this.fields[0].setText("");
        this.fields[1].setText("");
        this.fields[2].setText("");
        this.fields[3].setText("");
    }

    public Dimension getMinimumSize() {
        return new Dimension(4 * this.fields[0].getMinimumSize().width, this.fields[0].getMinimumSize().height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public IPTextField() {
        IntegerListener integerListener = new IntegerListener(this);
        IPListener iPListener = new IPListener(this);
        this.fields = new TextField[4];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new TextField(3);
            this.fields[i].addTextListener(iPListener);
            this.fields[i].addKeyListener(integerListener);
        }
        this.setLayout(new GridLayout(1, 4));
        this.add(this.fields[0]);
        this.add(this.fields[1]);
        this.add(this.fields[2]);
        this.add(this.fields[3]);
    }

    class IPListener
    implements TextListener {
        IPTextField comp = null;

        public void textValueChanged(TextEvent textEvent) {
            TextField textField = (TextField)textEvent.getSource();
            String string = textField.getText();
            if (string.length() < 3) {
                return;
            }
            if (string.length() == 4) {
                textField.setText(string.substring(3));
                return;
            }
            try {
                short s = Short.parseShort(string);
                if (s > 255) {
                    textField.setText("");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                textField.setText("");
                return;
            }
            if (textField == this.comp.fields[0]) {
                this.comp.fields[1].requestFocus();
            } else if (textField == this.comp.fields[1]) {
                this.comp.fields[2].requestFocus();
            } else if (textField == this.comp.fields[2]) {
                this.comp.fields[3].requestFocus();
            }
        }

        IPListener(IPTextField iPTextField2) {
            this.comp = iPTextField2;
        }
    }

    class IntegerListener
    extends KeyAdapter {
        IPTextField comp = null;

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
                return;
            }
            TextField textField = (TextField)keyEvent.getComponent();
            if (keyEvent.getKeyChar() == '*') {
                keyEvent.consume();
                textField.setText("*");
                this.requestFocusOnNextField(textField);
            } else if (keyEvent.getKeyCode() == 32) {
                keyEvent.consume();
                this.requestFocusOnNextField(textField);
            } else if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                this.requestFocusOnNextField(textField);
            } else if (keyEvent.getKeyChar() < '0' || keyEvent.getKeyChar() > '9') {
                keyEvent.consume();
            }
        }

        void requestFocusOnNextField(TextField textField) {
            if (textField == this.comp.fields[0]) {
                this.comp.fields[1].requestFocus();
            } else if (textField == this.comp.fields[1]) {
                this.comp.fields[2].requestFocus();
            } else if (textField == this.comp.fields[2]) {
                this.comp.fields[3].requestFocus();
            } else if (textField == this.comp.fields[3]) {
                this.comp.fireActionEvent();
                this.comp.fields[0].requestFocus();
                this.comp.fields[0].setText("");
                this.comp.fields[1].setText("");
                this.comp.fields[2].setText("");
                this.comp.fields[3].setText("");
            }
        }

        IntegerListener(IPTextField iPTextField2) {
            this.comp = iPTextField2;
        }
    }
}

