/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Messages;

public class IndexGenerator {
    public static VelocityContext vc = new VelocityContext();
    private static String template_name = "validator.vm";
    private static String html_files_path = "../../../../";
    private static boolean done = false;

    public static void main(String[] args) {
        IndexGenerator.generatesIndex(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void generatesIndex(boolean servlet) {
        String name;
        if (done) {
            return;
        }
        String default_lang = "en";
        ApplContext ac_default = new ApplContext(default_lang);
        HashMap[] languages = new HashMap[Messages.languages_name.size()];
        for (int i = 0; i < Messages.languages_name.size(); ++i) {
            name = String.valueOf(Messages.languages_name.get(i));
            HashMap<String, String> l = new HashMap<String, String>();
            l.put("name", name);
            l.put("real", Messages.languages.get(name).getProperty("language_name"));
            languages[i] = l;
        }
        vc.put("languages", languages);
        try {
            String path = IndexGenerator.class.getResource("").getPath();
            path = servlet ? path.replace("file://localhost", "") : new URI(path).getPath();
            Velocity.setProperty("resource.loader.file.path", path);
            Velocity.addProperty("resource.loader.file.path", path + "../../../../");
            Velocity.init();
            if (!new File(path + template_name).exists()) {
                html_files_path = "";
            }
            Template tpl = Velocity.getTemplate(template_name, "UTF-8");
            int count = 0;
            for (int i = 0; i < Messages.languages_name.size(); ++i) {
                String k;
                Iterator<Object> it;
                name = String.valueOf(Messages.languages_name.get(i));
                File tmpFile = new File(path + html_files_path + "validator.html." + name);
                if (tmpFile.lastModified() >= tpl.getLastModified() && tmpFile.exists()) continue;
                ApplContext ac = new ApplContext(name);
                vc.put("lang", name);
                if (ac.getLang().equals(default_lang)) {
                    it = ac_default.getMsg().properties.keySet().iterator();
                    while (it.hasNext()) {
                        k = String.valueOf(it.next());
                        vc.put(k, ac.getMsg().getString(k));
                    }
                } else {
                    it = ac_default.getMsg().properties.keySet().iterator();
                    while (it.hasNext()) {
                        k = String.valueOf(it.next());
                        if (ac.getMsg().getString(k) == null) {
                            vc.put(k, ac_default.getMsg().getString(k));
                            continue;
                        }
                        vc.put(k, ac.getMsg().getString(k));
                    }
                }
                OutputStreamWriter aFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8");
                tpl.merge(vc, aFileWriter);
                aFileWriter.close();
                ++count;
            }
            Velocity.getLog().info("IndexGenerator : " + count + " index file(s) created or modified");
            done = true;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            done = true;
        }
    }
}

