(ns ant-man.helpers.message
  (:require [goog.object :as gobj]))

(def ^:private levels
  #{nil :success :error :info :warning :warn :loading})

(defn- apply-fn [fn-name & args]
  (apply js-invoke (gobj/get js/antd fn-name) (clj->js args)))

(defn- message [& args]
  (apply apply-fn "message" args))

(defn configure [options]
  (message "config" options))

(defn show
  [{:keys [level content duration on-close after-close]}]
  {:pre [(contains? levels level)]}
  (let [level (if level
                (name level)
                "info")
        duration (when (or (pos? duration) (zero? duration))
                   duration)
        callback (cond
                   (and (fn? on-close)
                        (nil? after-close)) :one
                   (every? fn? [on-close after-close]) :both
                   :else :none)
        props (case callback
                :one [level content duration on-close]
                :both [level content duration on-close after-close]
                :none [level content duration])]
    (let [promise (->> props
                       (remove nil?)
                       (apply message))]
      (if-not (= :both callback)
        promise
        (.then promise after-close)))))

(defn destroy []
  (message "destroy"))
