(ns ant-man.core
  (:refer-clojure :exclude [comment empty list])
  (:require
   [cljsjs.antd]
   [reagent.core :as r]
   [ant-man.helpers.message :as message])
  (:require-macros [ant-man.macros :refer [export-components]]))

(def message
  "Message

  Documentation: https://ant.design/components/message

  Show message

  Usage:
  ```
    (message-show {:level       :loading
                   :content     \"Action in progress...\"
                   :duration    3
                   :on-close    #(js/console.log :callback/on-close)
                   :after-close #(js/console.log :callback/after-close)})
  ```

  Returns:
  ```
    Promise
  ```"
  message/show)

(def message-configure
  "Message

  Documentation: https://ant.design/components/message

  Set global configuration for all messages

  Usage:
  ```
    (message-configure {:top      24
                        :duration 2
                        :maxCount 3})
  ```

  Returns:
  ```
    nil
  ```"
  message/configure)

(def message-destroy
  "Message

  Documentation: https://ant.design/components/message

  Destroy message

  Usage:
  ```
    (message-destroy)
  ```

  Returns:
  ```
    nil
  ```"
  message/destroy)

(export-components)
