# Ant-Man
[![Clojars Project](https://img.shields.io/clojars/v/com.hypaer/ant-man.svg)](https://clojars.org/com.hypaer/ant-man)
[![Dependencies Status](https://versions.deps.co/hypaer/ant-man/status.svg)](https://versions.deps.co/hypaer/ant-man)
[![Build Status](https://travis-ci.org/hypaer/ant-man.svg?branch=master)](https://travis-ci.org/hypaer/ant-man)
![Clojars](https://img.shields.io/clojars/dt/com.hypaer/ant-man.svg?style=flat)
![GitHub last commit](https://img.shields.io/github/last-commit/hypaer/ant-man.svg?style=flat)

> <img src="resources/images/ant-man.png" width="66" />
>
> One question, is it too late to change the name?
>
> -Scott Lang

## Overview

Thin ClojureScript wrapper for [Ant Design](https://ant.design) React components with [Reagent](https://github.com/reagent-project/reagent)

Quick link to Ant Design introduction: https://ant.design/docs/react/introduce

## Documentation

* [API Documents](https://hypaer.github.io/ant-man/)

## Usage

Include Ant-Man and Reagent in your `project.clj`

```clojure
[ant-man "1.7.1"]
[reagent "0.8.1"] ;; Ant-Man requires Reagent 0.8.0+
```

Include Ant Design CSS and JavaScript CDNs

```
https://cdnjs.cloudflare.com/ajax/libs/antd/3.13.3/antd.min.css
```

```
https://cdnjs.cloudflare.com/ajax/libs/antd/3.13.3/antd.min.js
```

Require and use in your project

```clojure
(require '[ant-man.core :as ant-man])

;; Input field
[ant-man/input {:value @your-reagent-atom
                :id "your-id"
                :placeholder "your-placeholder"}]


;; Select input field
(def t (reagent.core/atom nil)
(def col [{:id 1 :label "uno"}
          {:id 2 :label "dos"}]

[ant-man/select {:on-change (fn [val] (reset! t val))
                 :value @t}
  (for [{:keys [label id]} col]
    [ant-man/select-option {:value id} label])]
```

## Helper functions

#### Keyify-ing lists

Given a function and collection will add unique `:key` value to metadata information

A customizable `:key-fn` functionality for specifying list item `:key` value

Use example:

```clojure
(require '[ant-man.core :as ant-man]
         '[ant-man.helpers :as ant-man-helpers]
         '[reagent.core :as r])

(def selection (r/atom nil))
(def example-collection [{:label "foo" :id 1} {:label "bar" :id 2}])

;; Default
[ant-man/select {:on-change (fn [val] (reset! selection val))
                 :value @selection}
  (ant-man-helpers/keyify
    (fn [{:keys [label id]}]
      [ant-man/select-option {:value id} label])
    example-collection)]

;; Custom `:key-fn`
[ant-man/select {:on-change (fn [val] (reset! selection val))
                 :value @selection}
  (ant-man-helpers/keyify
    (fn [{:keys [label id]}]
      [ant-man/select-option {:value id} label] :key-fn (fn [x] [(inc x)]))
    example-collection)]
```

## Development

To use in your project and develop this library simultaneously use [Leiningen Checkouts](https://github.com/technomancy/leiningen/blob/master/doc/TUTORIAL.md#checkout-dependencies) along with specifying a `src` path inside your `:cljsbuild` configuration. If you are using Figwheel and it is configured correctly changes made in Ant-Man will auto re-load.

#### Example:

```clojure
;; Specify path in your `project.clj`

:cljsbuild {:builds
            [{:id "dev"
              :source-paths ["src/cljs" "src/cljc" "checkouts/ant-man/src/cljs"]}]}
```

## License

Copyright © 2019 [HYPÆR](https://hypaer.com)

The use and distribution terms for this software are covered by the Eclipse Public License 2.0. By using this software in any fashion, you are agreeing to be bound by the terms of this license. You must not remove this notice, or any other, from this software.
