(ns ant-man.core
  (:refer-clojure :exclude [list])
  (:require
   [cljsjs.antd]
   [reagent.core :as r])
  (:require-macros [ant-man.macros :refer [export-components]]))

(defn children
  "Given a function and collection will add incremental meta `:key` information

  Example:

  (:require [ant-man.core :as ant-man]
            [reagent.core :as r])

  (def selection (r/atom nil))
  (def example-collection [{:label \"foo\" :id 1} {:label \"bar\" :id 2}])

  [ant-man/select {:on-change (fn [val] (reset! selection val))
                   :value @selection}
    (ant-man/children
      (fn [{:keys [label id]}]
        [ant-man/select-option {:value id} label])
      example-collection)]
  "
  [f xs]
  (map-indexed (fn [i x]
                 (with-meta
                   (f x)
                   {:key i}))
               xs))

(export-components)
