// Compiled by ClojureScript 1.10.516 {}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__27780){
var map__27781 = p__27780;
var map__27781__$1 = (((((!((map__27781 == null))))?(((((map__27781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27781):map__27781);
var m = map__27781__$1;
var n = cljs.core.get.call(null,map__27781__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__27781__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5720__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__27783_27815 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__27784_27816 = null;
var count__27785_27817 = (0);
var i__27786_27818 = (0);
while(true){
if((i__27786_27818 < count__27785_27817)){
var f_27819 = cljs.core._nth.call(null,chunk__27784_27816,i__27786_27818);
cljs.core.println.call(null,"  ",f_27819);


var G__27820 = seq__27783_27815;
var G__27821 = chunk__27784_27816;
var G__27822 = count__27785_27817;
var G__27823 = (i__27786_27818 + (1));
seq__27783_27815 = G__27820;
chunk__27784_27816 = G__27821;
count__27785_27817 = G__27822;
i__27786_27818 = G__27823;
continue;
} else {
var temp__5720__auto___27824 = cljs.core.seq.call(null,seq__27783_27815);
if(temp__5720__auto___27824){
var seq__27783_27825__$1 = temp__5720__auto___27824;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27783_27825__$1)){
var c__4550__auto___27826 = cljs.core.chunk_first.call(null,seq__27783_27825__$1);
var G__27827 = cljs.core.chunk_rest.call(null,seq__27783_27825__$1);
var G__27828 = c__4550__auto___27826;
var G__27829 = cljs.core.count.call(null,c__4550__auto___27826);
var G__27830 = (0);
seq__27783_27815 = G__27827;
chunk__27784_27816 = G__27828;
count__27785_27817 = G__27829;
i__27786_27818 = G__27830;
continue;
} else {
var f_27831 = cljs.core.first.call(null,seq__27783_27825__$1);
cljs.core.println.call(null,"  ",f_27831);


var G__27832 = cljs.core.next.call(null,seq__27783_27825__$1);
var G__27833 = null;
var G__27834 = (0);
var G__27835 = (0);
seq__27783_27815 = G__27832;
chunk__27784_27816 = G__27833;
count__27785_27817 = G__27834;
i__27786_27818 = G__27835;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_27836 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_27836);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_27836)))?cljs.core.second.call(null,arglists_27836):arglists_27836));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__27787_27837 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__27788_27838 = null;
var count__27789_27839 = (0);
var i__27790_27840 = (0);
while(true){
if((i__27790_27840 < count__27789_27839)){
var vec__27801_27841 = cljs.core._nth.call(null,chunk__27788_27838,i__27790_27840);
var name_27842 = cljs.core.nth.call(null,vec__27801_27841,(0),null);
var map__27804_27843 = cljs.core.nth.call(null,vec__27801_27841,(1),null);
var map__27804_27844__$1 = (((((!((map__27804_27843 == null))))?(((((map__27804_27843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27804_27843.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27804_27843):map__27804_27843);
var doc_27845 = cljs.core.get.call(null,map__27804_27844__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_27846 = cljs.core.get.call(null,map__27804_27844__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_27842);

cljs.core.println.call(null," ",arglists_27846);

if(cljs.core.truth_(doc_27845)){
cljs.core.println.call(null," ",doc_27845);
} else {
}


var G__27847 = seq__27787_27837;
var G__27848 = chunk__27788_27838;
var G__27849 = count__27789_27839;
var G__27850 = (i__27790_27840 + (1));
seq__27787_27837 = G__27847;
chunk__27788_27838 = G__27848;
count__27789_27839 = G__27849;
i__27790_27840 = G__27850;
continue;
} else {
var temp__5720__auto___27851 = cljs.core.seq.call(null,seq__27787_27837);
if(temp__5720__auto___27851){
var seq__27787_27852__$1 = temp__5720__auto___27851;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27787_27852__$1)){
var c__4550__auto___27853 = cljs.core.chunk_first.call(null,seq__27787_27852__$1);
var G__27854 = cljs.core.chunk_rest.call(null,seq__27787_27852__$1);
var G__27855 = c__4550__auto___27853;
var G__27856 = cljs.core.count.call(null,c__4550__auto___27853);
var G__27857 = (0);
seq__27787_27837 = G__27854;
chunk__27788_27838 = G__27855;
count__27789_27839 = G__27856;
i__27790_27840 = G__27857;
continue;
} else {
var vec__27806_27858 = cljs.core.first.call(null,seq__27787_27852__$1);
var name_27859 = cljs.core.nth.call(null,vec__27806_27858,(0),null);
var map__27809_27860 = cljs.core.nth.call(null,vec__27806_27858,(1),null);
var map__27809_27861__$1 = (((((!((map__27809_27860 == null))))?(((((map__27809_27860.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27809_27860.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27809_27860):map__27809_27860);
var doc_27862 = cljs.core.get.call(null,map__27809_27861__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_27863 = cljs.core.get.call(null,map__27809_27861__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_27859);

cljs.core.println.call(null," ",arglists_27863);

if(cljs.core.truth_(doc_27862)){
cljs.core.println.call(null," ",doc_27862);
} else {
}


var G__27864 = cljs.core.next.call(null,seq__27787_27852__$1);
var G__27865 = null;
var G__27866 = (0);
var G__27867 = (0);
seq__27787_27837 = G__27864;
chunk__27788_27838 = G__27865;
count__27789_27839 = G__27866;
i__27790_27840 = G__27867;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5720__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5720__auto__)){
var fnspec = temp__5720__auto__;
cljs.core.print.call(null,"Spec");

var seq__27811 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__27812 = null;
var count__27813 = (0);
var i__27814 = (0);
while(true){
if((i__27814 < count__27813)){
var role = cljs.core._nth.call(null,chunk__27812,i__27814);
var temp__5720__auto___27868__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___27868__$1)){
var spec_27869 = temp__5720__auto___27868__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_27869));
} else {
}


var G__27870 = seq__27811;
var G__27871 = chunk__27812;
var G__27872 = count__27813;
var G__27873 = (i__27814 + (1));
seq__27811 = G__27870;
chunk__27812 = G__27871;
count__27813 = G__27872;
i__27814 = G__27873;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__27811);
if(temp__5720__auto____$1){
var seq__27811__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27811__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__27811__$1);
var G__27874 = cljs.core.chunk_rest.call(null,seq__27811__$1);
var G__27875 = c__4550__auto__;
var G__27876 = cljs.core.count.call(null,c__4550__auto__);
var G__27877 = (0);
seq__27811 = G__27874;
chunk__27812 = G__27875;
count__27813 = G__27876;
i__27814 = G__27877;
continue;
} else {
var role = cljs.core.first.call(null,seq__27811__$1);
var temp__5720__auto___27878__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___27878__$2)){
var spec_27879 = temp__5720__auto___27878__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_27879));
} else {
}


var G__27880 = cljs.core.next.call(null,seq__27811__$1);
var G__27881 = null;
var G__27882 = (0);
var G__27883 = (0);
seq__27811 = G__27880;
chunk__27812 = G__27881;
count__27813 = G__27882;
i__27814 = G__27883;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var ed = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__27884 = cljs.core.conj.call(null,via,t);
var G__27885 = cljs.core.ex_cause.call(null,t);
via = G__27884;
t = G__27885;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var root_msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var data = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5720__auto__)){
var phase = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__27888 = datafied_throwable;
var map__27888__$1 = (((((!((map__27888 == null))))?(((((map__27888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27888.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27888):map__27888);
var via = cljs.core.get.call(null,map__27888__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__27888__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__27888__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__27889 = cljs.core.last.call(null,via);
var map__27889__$1 = (((((!((map__27889 == null))))?(((((map__27889.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27889.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27889):map__27889);
var type = cljs.core.get.call(null,map__27889__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__27889__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__27889__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__27890 = data;
var map__27890__$1 = (((((!((map__27890 == null))))?(((((map__27890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27890):map__27890);
var problems = cljs.core.get.call(null,map__27890__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__27890__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__27890__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__27891 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__27891__$1 = (((((!((map__27891 == null))))?(((((map__27891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27891.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27891):map__27891);
var top_data = map__27891__$1;
var source = cljs.core.get.call(null,map__27891__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__27896 = phase;
var G__27896__$1 = (((G__27896 instanceof cljs.core.Keyword))?G__27896.fqn:null);
switch (G__27896__$1) {
case "read-source":
var map__27897 = data;
var map__27897__$1 = (((((!((map__27897 == null))))?(((((map__27897.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27897.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27897):map__27897);
var line = cljs.core.get.call(null,map__27897__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__27897__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__27899 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__27899__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__27899,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__27899);
var G__27899__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__27899__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__27899__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__27899__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__27899__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__27900 = top_data;
var G__27900__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__27900,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__27900);
var G__27900__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__27900__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__27900__$1);
var G__27900__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__27900__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__27900__$2);
var G__27900__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__27900__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__27900__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__27900__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__27900__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__27901 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__27901,(0),null);
var method = cljs.core.nth.call(null,vec__27901,(1),null);
var file = cljs.core.nth.call(null,vec__27901,(2),null);
var line = cljs.core.nth.call(null,vec__27901,(3),null);
var G__27904 = top_data;
var G__27904__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__27904,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__27904);
var G__27904__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__27904__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__27904__$1);
var G__27904__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__27904__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__27904__$2);
var G__27904__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__27904__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__27904__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__27904__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__27904__$4;
}

break;
case "execution":
var vec__27905 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__27905,(0),null);
var method = cljs.core.nth.call(null,vec__27905,(1),null);
var file = cljs.core.nth.call(null,vec__27905,(2),null);
var line = cljs.core.nth.call(null,vec__27905,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,((function (vec__27905,source__$1,method,file,line,G__27896,G__27896__$1,map__27888,map__27888__$1,via,trace,phase,map__27889,map__27889__$1,type,message,data,map__27890,map__27890__$1,problems,fn,caller,map__27891,map__27891__$1,top_data,source){
return (function (p1__27887_SHARP_){
var or__4131__auto__ = (p1__27887_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__27887_SHARP_);
}
});})(vec__27905,source__$1,method,file,line,G__27896,G__27896__$1,map__27888,map__27888__$1,via,trace,phase,map__27889,map__27889__$1,type,message,data,map__27890,map__27890__$1,problems,fn,caller,map__27891,map__27891__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__27908 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__27908__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__27908,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__27908);
var G__27908__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__27908__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__27908__$1);
var G__27908__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.call(null,G__27908__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__27908__$2);
var G__27908__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__27908__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__27908__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__27908__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__27908__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27896__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__27912){
var map__27913 = p__27912;
var map__27913__$1 = (((((!((map__27913 == null))))?(((((map__27913.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27913.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27913):map__27913);
var triage_data = map__27913__$1;
var phase = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__27913__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__27915 = phase;
var G__27915__$1 = (((G__27915 instanceof cljs.core.Keyword))?G__27915.fqn:null);
switch (G__27915__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__27916_27925 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__27917_27926 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__27918_27927 = true;
var _STAR_print_fn_STAR__temp_val__27919_27928 = ((function (_STAR_print_newline_STAR__orig_val__27916_27925,_STAR_print_fn_STAR__orig_val__27917_27926,_STAR_print_newline_STAR__temp_val__27918_27927,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__27916_27925,_STAR_print_fn_STAR__orig_val__27917_27926,_STAR_print_newline_STAR__temp_val__27918_27927,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__27918_27927;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__27919_27928;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__27916_27925,_STAR_print_fn_STAR__orig_val__27917_27926,_STAR_print_newline_STAR__temp_val__27918_27927,_STAR_print_fn_STAR__temp_val__27919_27928,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__27916_27925,_STAR_print_fn_STAR__orig_val__27917_27926,_STAR_print_newline_STAR__temp_val__27918_27927,_STAR_print_fn_STAR__temp_val__27919_27928,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__27910_SHARP_){
return cljs.core.dissoc.call(null,p1__27910_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__27916_27925,_STAR_print_fn_STAR__orig_val__27917_27926,_STAR_print_newline_STAR__temp_val__27918_27927,_STAR_print_fn_STAR__temp_val__27919_27928,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__27916_27925,_STAR_print_fn_STAR__orig_val__27917_27926,_STAR_print_newline_STAR__temp_val__27918_27927,_STAR_print_fn_STAR__temp_val__27919_27928,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__27917_27926;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__27916_27925;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__27920_27929 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__27921_27930 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__27922_27931 = true;
var _STAR_print_fn_STAR__temp_val__27923_27932 = ((function (_STAR_print_newline_STAR__orig_val__27920_27929,_STAR_print_fn_STAR__orig_val__27921_27930,_STAR_print_newline_STAR__temp_val__27922_27931,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__27920_27929,_STAR_print_fn_STAR__orig_val__27921_27930,_STAR_print_newline_STAR__temp_val__27922_27931,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__27922_27931;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__27923_27932;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__27920_27929,_STAR_print_fn_STAR__orig_val__27921_27930,_STAR_print_newline_STAR__temp_val__27922_27931,_STAR_print_fn_STAR__temp_val__27923_27932,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__27920_27929,_STAR_print_fn_STAR__orig_val__27921_27930,_STAR_print_newline_STAR__temp_val__27922_27931,_STAR_print_fn_STAR__temp_val__27923_27932,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__27911_SHARP_){
return cljs.core.dissoc.call(null,p1__27911_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__27920_27929,_STAR_print_fn_STAR__orig_val__27921_27930,_STAR_print_newline_STAR__temp_val__27922_27931,_STAR_print_fn_STAR__temp_val__27923_27932,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__27920_27929,_STAR_print_fn_STAR__orig_val__27921_27930,_STAR_print_newline_STAR__temp_val__27922_27931,_STAR_print_fn_STAR__temp_val__27923_27932,sb__4661__auto__,G__27915,G__27915__$1,loc,class_name,simple_class,cause_type,format,map__27913,map__27913__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__27921_27930;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__27920_27929;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27915__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map?rel=1549344825925
