// Compiled by ClojureScript 1.10.516 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__4131__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__4131__auto__){
return or__4131__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__4131__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__26250_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__26250_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__26251 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__26252 = null;
var count__26253 = (0);
var i__26254 = (0);
while(true){
if((i__26254 < count__26253)){
var n = cljs.core._nth.call(null,chunk__26252,i__26254);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__26255 = seq__26251;
var G__26256 = chunk__26252;
var G__26257 = count__26253;
var G__26258 = (i__26254 + (1));
seq__26251 = G__26255;
chunk__26252 = G__26256;
count__26253 = G__26257;
i__26254 = G__26258;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__26251);
if(temp__5720__auto__){
var seq__26251__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26251__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__26251__$1);
var G__26259 = cljs.core.chunk_rest.call(null,seq__26251__$1);
var G__26260 = c__4550__auto__;
var G__26261 = cljs.core.count.call(null,c__4550__auto__);
var G__26262 = (0);
seq__26251 = G__26259;
chunk__26252 = G__26260;
count__26253 = G__26261;
i__26254 = G__26262;
continue;
} else {
var n = cljs.core.first.call(null,seq__26251__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__26263 = cljs.core.next.call(null,seq__26251__$1);
var G__26264 = null;
var G__26265 = (0);
var G__26266 = (0);
seq__26251 = G__26263;
chunk__26252 = G__26264;
count__26253 = G__26265;
i__26254 = G__26266;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__26267){
var vec__26268 = p__26267;
var _ = cljs.core.nth.call(null,vec__26268,(0),null);
var v = cljs.core.nth.call(null,vec__26268,(1),null);
var and__4120__auto__ = v;
if(cljs.core.truth_(and__4120__auto__)){
return v.call(null,dep);
} else {
return and__4120__auto__;
}
}),cljs.core.filter.call(null,(function (p__26271){
var vec__26272 = p__26271;
var k = cljs.core.nth.call(null,vec__26272,(0),null);
var v = cljs.core.nth.call(null,vec__26272,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__26284_26292 = cljs.core.seq.call(null,deps);
var chunk__26285_26293 = null;
var count__26286_26294 = (0);
var i__26287_26295 = (0);
while(true){
if((i__26287_26295 < count__26286_26294)){
var dep_26296 = cljs.core._nth.call(null,chunk__26285_26293,i__26287_26295);
if(cljs.core.truth_((function (){var and__4120__auto__ = dep_26296;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_26296));
} else {
return and__4120__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_26296,(depth + (1)),state);
} else {
}


var G__26297 = seq__26284_26292;
var G__26298 = chunk__26285_26293;
var G__26299 = count__26286_26294;
var G__26300 = (i__26287_26295 + (1));
seq__26284_26292 = G__26297;
chunk__26285_26293 = G__26298;
count__26286_26294 = G__26299;
i__26287_26295 = G__26300;
continue;
} else {
var temp__5720__auto___26301 = cljs.core.seq.call(null,seq__26284_26292);
if(temp__5720__auto___26301){
var seq__26284_26302__$1 = temp__5720__auto___26301;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26284_26302__$1)){
var c__4550__auto___26303 = cljs.core.chunk_first.call(null,seq__26284_26302__$1);
var G__26304 = cljs.core.chunk_rest.call(null,seq__26284_26302__$1);
var G__26305 = c__4550__auto___26303;
var G__26306 = cljs.core.count.call(null,c__4550__auto___26303);
var G__26307 = (0);
seq__26284_26292 = G__26304;
chunk__26285_26293 = G__26305;
count__26286_26294 = G__26306;
i__26287_26295 = G__26307;
continue;
} else {
var dep_26308 = cljs.core.first.call(null,seq__26284_26302__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = dep_26308;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_26308));
} else {
return and__4120__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_26308,(depth + (1)),state);
} else {
}


var G__26309 = cljs.core.next.call(null,seq__26284_26302__$1);
var G__26310 = null;
var G__26311 = (0);
var G__26312 = (0);
seq__26284_26292 = G__26309;
chunk__26285_26293 = G__26310;
count__26286_26294 = G__26311;
i__26287_26295 = G__26312;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__26288){
var vec__26289 = p__26288;
var seq__26290 = cljs.core.seq.call(null,vec__26289);
var first__26291 = cljs.core.first.call(null,seq__26290);
var seq__26290__$1 = cljs.core.next.call(null,seq__26290);
var x = first__26291;
var xs = seq__26290__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__26289,seq__26290,first__26291,seq__26290__$1,x,xs,get_deps__$1){
return (function (p1__26275_SHARP_){
return clojure.set.difference.call(null,p1__26275_SHARP_,x);
});})(vec__26289,seq__26290,first__26291,seq__26290__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__26313 = cljs.core.seq.call(null,provides);
var chunk__26314 = null;
var count__26315 = (0);
var i__26316 = (0);
while(true){
if((i__26316 < count__26315)){
var prov = cljs.core._nth.call(null,chunk__26314,i__26316);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26325_26333 = cljs.core.seq.call(null,requires);
var chunk__26326_26334 = null;
var count__26327_26335 = (0);
var i__26328_26336 = (0);
while(true){
if((i__26328_26336 < count__26327_26335)){
var req_26337 = cljs.core._nth.call(null,chunk__26326_26334,i__26328_26336);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26337,prov);


var G__26338 = seq__26325_26333;
var G__26339 = chunk__26326_26334;
var G__26340 = count__26327_26335;
var G__26341 = (i__26328_26336 + (1));
seq__26325_26333 = G__26338;
chunk__26326_26334 = G__26339;
count__26327_26335 = G__26340;
i__26328_26336 = G__26341;
continue;
} else {
var temp__5720__auto___26342 = cljs.core.seq.call(null,seq__26325_26333);
if(temp__5720__auto___26342){
var seq__26325_26343__$1 = temp__5720__auto___26342;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26325_26343__$1)){
var c__4550__auto___26344 = cljs.core.chunk_first.call(null,seq__26325_26343__$1);
var G__26345 = cljs.core.chunk_rest.call(null,seq__26325_26343__$1);
var G__26346 = c__4550__auto___26344;
var G__26347 = cljs.core.count.call(null,c__4550__auto___26344);
var G__26348 = (0);
seq__26325_26333 = G__26345;
chunk__26326_26334 = G__26346;
count__26327_26335 = G__26347;
i__26328_26336 = G__26348;
continue;
} else {
var req_26349 = cljs.core.first.call(null,seq__26325_26343__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26349,prov);


var G__26350 = cljs.core.next.call(null,seq__26325_26343__$1);
var G__26351 = null;
var G__26352 = (0);
var G__26353 = (0);
seq__26325_26333 = G__26350;
chunk__26326_26334 = G__26351;
count__26327_26335 = G__26352;
i__26328_26336 = G__26353;
continue;
}
} else {
}
}
break;
}


var G__26354 = seq__26313;
var G__26355 = chunk__26314;
var G__26356 = count__26315;
var G__26357 = (i__26316 + (1));
seq__26313 = G__26354;
chunk__26314 = G__26355;
count__26315 = G__26356;
i__26316 = G__26357;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__26313);
if(temp__5720__auto__){
var seq__26313__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26313__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__26313__$1);
var G__26358 = cljs.core.chunk_rest.call(null,seq__26313__$1);
var G__26359 = c__4550__auto__;
var G__26360 = cljs.core.count.call(null,c__4550__auto__);
var G__26361 = (0);
seq__26313 = G__26358;
chunk__26314 = G__26359;
count__26315 = G__26360;
i__26316 = G__26361;
continue;
} else {
var prov = cljs.core.first.call(null,seq__26313__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26329_26362 = cljs.core.seq.call(null,requires);
var chunk__26330_26363 = null;
var count__26331_26364 = (0);
var i__26332_26365 = (0);
while(true){
if((i__26332_26365 < count__26331_26364)){
var req_26366 = cljs.core._nth.call(null,chunk__26330_26363,i__26332_26365);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26366,prov);


var G__26367 = seq__26329_26362;
var G__26368 = chunk__26330_26363;
var G__26369 = count__26331_26364;
var G__26370 = (i__26332_26365 + (1));
seq__26329_26362 = G__26367;
chunk__26330_26363 = G__26368;
count__26331_26364 = G__26369;
i__26332_26365 = G__26370;
continue;
} else {
var temp__5720__auto___26371__$1 = cljs.core.seq.call(null,seq__26329_26362);
if(temp__5720__auto___26371__$1){
var seq__26329_26372__$1 = temp__5720__auto___26371__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26329_26372__$1)){
var c__4550__auto___26373 = cljs.core.chunk_first.call(null,seq__26329_26372__$1);
var G__26374 = cljs.core.chunk_rest.call(null,seq__26329_26372__$1);
var G__26375 = c__4550__auto___26373;
var G__26376 = cljs.core.count.call(null,c__4550__auto___26373);
var G__26377 = (0);
seq__26329_26362 = G__26374;
chunk__26330_26363 = G__26375;
count__26331_26364 = G__26376;
i__26332_26365 = G__26377;
continue;
} else {
var req_26378 = cljs.core.first.call(null,seq__26329_26372__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26378,prov);


var G__26379 = cljs.core.next.call(null,seq__26329_26372__$1);
var G__26380 = null;
var G__26381 = (0);
var G__26382 = (0);
seq__26329_26362 = G__26379;
chunk__26330_26363 = G__26380;
count__26331_26364 = G__26381;
i__26332_26365 = G__26382;
continue;
}
} else {
}
}
break;
}


var G__26383 = cljs.core.next.call(null,seq__26313__$1);
var G__26384 = null;
var G__26385 = (0);
var G__26386 = (0);
seq__26313 = G__26383;
chunk__26314 = G__26384;
count__26315 = G__26385;
i__26316 = G__26386;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__26387_26391 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__26388_26392 = null;
var count__26389_26393 = (0);
var i__26390_26394 = (0);
while(true){
if((i__26390_26394 < count__26389_26393)){
var ns_26395 = cljs.core._nth.call(null,chunk__26388_26392,i__26390_26394);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26395);


var G__26396 = seq__26387_26391;
var G__26397 = chunk__26388_26392;
var G__26398 = count__26389_26393;
var G__26399 = (i__26390_26394 + (1));
seq__26387_26391 = G__26396;
chunk__26388_26392 = G__26397;
count__26389_26393 = G__26398;
i__26390_26394 = G__26399;
continue;
} else {
var temp__5720__auto___26400 = cljs.core.seq.call(null,seq__26387_26391);
if(temp__5720__auto___26400){
var seq__26387_26401__$1 = temp__5720__auto___26400;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26387_26401__$1)){
var c__4550__auto___26402 = cljs.core.chunk_first.call(null,seq__26387_26401__$1);
var G__26403 = cljs.core.chunk_rest.call(null,seq__26387_26401__$1);
var G__26404 = c__4550__auto___26402;
var G__26405 = cljs.core.count.call(null,c__4550__auto___26402);
var G__26406 = (0);
seq__26387_26391 = G__26403;
chunk__26388_26392 = G__26404;
count__26389_26393 = G__26405;
i__26390_26394 = G__26406;
continue;
} else {
var ns_26407 = cljs.core.first.call(null,seq__26387_26401__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26407);


var G__26408 = cljs.core.next.call(null,seq__26387_26401__$1);
var G__26409 = null;
var G__26410 = (0);
var G__26411 = (0);
seq__26387_26391 = G__26408;
chunk__26388_26392 = G__26409;
count__26389_26393 = G__26410;
i__26390_26394 = G__26411;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__4131__auto__ = goog.require__;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__26412__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__26412 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26413__i = 0, G__26413__a = new Array(arguments.length -  0);
while (G__26413__i < G__26413__a.length) {G__26413__a[G__26413__i] = arguments[G__26413__i + 0]; ++G__26413__i;}
  args = new cljs.core.IndexedSeq(G__26413__a,0,null);
} 
return G__26412__delegate.call(this,args);};
G__26412.cljs$lang$maxFixedArity = 0;
G__26412.cljs$lang$applyTo = (function (arglist__26414){
var args = cljs.core.seq(arglist__26414);
return G__26412__delegate(args);
});
G__26412.cljs$core$IFn$_invoke$arity$variadic = G__26412__delegate;
return G__26412;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__26415_SHARP_,p2__26416_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__26415_SHARP_)),p2__26416_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__26417_SHARP_,p2__26418_SHARP_){
return goog.net.jsloader.load(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__26417_SHARP_),p2__26418_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__26419 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__26419.addCallback(((function (G__26419){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__26419))
);

G__26419.addErrback(((function (G__26419){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__26419))
);

return G__26419;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e26420){if((e26420 instanceof Error)){
var e = e26420;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e26420;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e26421){if((e26421 instanceof Error)){
var e = e26421;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e26421;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__26422 = cljs.core._EQ_;
var expr__26423 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__26422.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__26423))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__26422.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__26423))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__26422.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__26423))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__26422,expr__26423){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__26422,expr__26423))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__26425,callback){
var map__26426 = p__26425;
var map__26426__$1 = (((((!((map__26426 == null))))?(((((map__26426.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26426.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26426):map__26426);
var file_msg = map__26426__$1;
var request_url = cljs.core.get.call(null,map__26426__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__4131__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__26426,map__26426__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__26426,map__26426__$1,file_msg,request_url))
);
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__22867__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto__){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto__){
return (function (state_26464){
var state_val_26465 = (state_26464[(1)]);
if((state_val_26465 === (7))){
var inst_26460 = (state_26464[(2)]);
var state_26464__$1 = state_26464;
var statearr_26466_26492 = state_26464__$1;
(statearr_26466_26492[(2)] = inst_26460);

(statearr_26466_26492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (1))){
var state_26464__$1 = state_26464;
var statearr_26467_26493 = state_26464__$1;
(statearr_26467_26493[(2)] = null);

(statearr_26467_26493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (4))){
var inst_26430 = (state_26464[(7)]);
var inst_26430__$1 = (state_26464[(2)]);
var state_26464__$1 = (function (){var statearr_26468 = state_26464;
(statearr_26468[(7)] = inst_26430__$1);

return statearr_26468;
})();
if(cljs.core.truth_(inst_26430__$1)){
var statearr_26469_26494 = state_26464__$1;
(statearr_26469_26494[(1)] = (5));

} else {
var statearr_26470_26495 = state_26464__$1;
(statearr_26470_26495[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (15))){
var inst_26445 = (state_26464[(8)]);
var inst_26443 = (state_26464[(9)]);
var inst_26447 = inst_26445.call(null,inst_26443);
var state_26464__$1 = state_26464;
var statearr_26471_26496 = state_26464__$1;
(statearr_26471_26496[(2)] = inst_26447);

(statearr_26471_26496[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (13))){
var inst_26454 = (state_26464[(2)]);
var state_26464__$1 = state_26464;
var statearr_26472_26497 = state_26464__$1;
(statearr_26472_26497[(2)] = inst_26454);

(statearr_26472_26497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (6))){
var state_26464__$1 = state_26464;
var statearr_26473_26498 = state_26464__$1;
(statearr_26473_26498[(2)] = null);

(statearr_26473_26498[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (17))){
var inst_26451 = (state_26464[(2)]);
var state_26464__$1 = state_26464;
var statearr_26474_26499 = state_26464__$1;
(statearr_26474_26499[(2)] = inst_26451);

(statearr_26474_26499[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (3))){
var inst_26462 = (state_26464[(2)]);
var state_26464__$1 = state_26464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26464__$1,inst_26462);
} else {
if((state_val_26465 === (12))){
var state_26464__$1 = state_26464;
var statearr_26475_26500 = state_26464__$1;
(statearr_26475_26500[(2)] = null);

(statearr_26475_26500[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (2))){
var state_26464__$1 = state_26464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26464__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_26465 === (11))){
var inst_26435 = (state_26464[(10)]);
var inst_26441 = figwheel.client.file_reloading.blocking_load.call(null,inst_26435);
var state_26464__$1 = state_26464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26464__$1,(14),inst_26441);
} else {
if((state_val_26465 === (9))){
var inst_26435 = (state_26464[(10)]);
var state_26464__$1 = state_26464;
if(cljs.core.truth_(inst_26435)){
var statearr_26476_26501 = state_26464__$1;
(statearr_26476_26501[(1)] = (11));

} else {
var statearr_26477_26502 = state_26464__$1;
(statearr_26477_26502[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (5))){
var inst_26430 = (state_26464[(7)]);
var inst_26436 = (state_26464[(11)]);
var inst_26435 = cljs.core.nth.call(null,inst_26430,(0),null);
var inst_26436__$1 = cljs.core.nth.call(null,inst_26430,(1),null);
var state_26464__$1 = (function (){var statearr_26478 = state_26464;
(statearr_26478[(11)] = inst_26436__$1);

(statearr_26478[(10)] = inst_26435);

return statearr_26478;
})();
if(cljs.core.truth_(inst_26436__$1)){
var statearr_26479_26503 = state_26464__$1;
(statearr_26479_26503[(1)] = (8));

} else {
var statearr_26480_26504 = state_26464__$1;
(statearr_26480_26504[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (14))){
var inst_26445 = (state_26464[(8)]);
var inst_26435 = (state_26464[(10)]);
var inst_26443 = (state_26464[(2)]);
var inst_26444 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_26445__$1 = cljs.core.get.call(null,inst_26444,inst_26435);
var state_26464__$1 = (function (){var statearr_26481 = state_26464;
(statearr_26481[(8)] = inst_26445__$1);

(statearr_26481[(9)] = inst_26443);

return statearr_26481;
})();
if(cljs.core.truth_(inst_26445__$1)){
var statearr_26482_26505 = state_26464__$1;
(statearr_26482_26505[(1)] = (15));

} else {
var statearr_26483_26506 = state_26464__$1;
(statearr_26483_26506[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (16))){
var inst_26443 = (state_26464[(9)]);
var inst_26449 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_26443);
var state_26464__$1 = state_26464;
var statearr_26484_26507 = state_26464__$1;
(statearr_26484_26507[(2)] = inst_26449);

(statearr_26484_26507[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (10))){
var inst_26456 = (state_26464[(2)]);
var state_26464__$1 = (function (){var statearr_26485 = state_26464;
(statearr_26485[(12)] = inst_26456);

return statearr_26485;
})();
var statearr_26486_26508 = state_26464__$1;
(statearr_26486_26508[(2)] = null);

(statearr_26486_26508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26465 === (8))){
var inst_26436 = (state_26464[(11)]);
var inst_26438 = eval(inst_26436);
var state_26464__$1 = state_26464;
var statearr_26487_26509 = state_26464__$1;
(statearr_26487_26509[(2)] = inst_26438);

(statearr_26487_26509[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto__))
;
return ((function (switch__22772__auto__,c__22867__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__22773__auto__ = null;
var figwheel$client$file_reloading$state_machine__22773__auto____0 = (function (){
var statearr_26488 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26488[(0)] = figwheel$client$file_reloading$state_machine__22773__auto__);

(statearr_26488[(1)] = (1));

return statearr_26488;
});
var figwheel$client$file_reloading$state_machine__22773__auto____1 = (function (state_26464){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_26464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e26489){if((e26489 instanceof Object)){
var ex__22776__auto__ = e26489;
var statearr_26490_26510 = state_26464;
(statearr_26490_26510[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26489;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26511 = state_26464;
state_26464 = G__26511;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__22773__auto__ = function(state_26464){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__22773__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__22773__auto____1.call(this,state_26464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__22773__auto____0;
figwheel$client$file_reloading$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__22773__auto____1;
return figwheel$client$file_reloading$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto__))
})();
var state__22869__auto__ = (function (){var statearr_26491 = f__22868__auto__.call(null);
(statearr_26491[(6)] = c__22867__auto__);

return statearr_26491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto__))
);

return c__22867__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__26513 = arguments.length;
switch (G__26513) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__26515,callback){
var map__26516 = p__26515;
var map__26516__$1 = (((((!((map__26516 == null))))?(((((map__26516.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26516.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26516):map__26516);
var file_msg = map__26516__$1;
var namespace = cljs.core.get.call(null,map__26516__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__26516,map__26516__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__26516,map__26516__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__26518){
var map__26519 = p__26518;
var map__26519__$1 = (((((!((map__26519 == null))))?(((((map__26519.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26519.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26519):map__26519);
var file_msg = map__26519__$1;
var namespace = cljs.core.get.call(null,map__26519__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return (!((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null)));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__26521){
var map__26522 = p__26521;
var map__26522__$1 = (((((!((map__26522 == null))))?(((((map__26522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26522):map__26522);
var file_msg = map__26522__$1;
var namespace = cljs.core.get.call(null,map__26522__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__4120__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__4120__auto__){
var or__4131__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__4120__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__26524,callback){
var map__26525 = p__26524;
var map__26525__$1 = (((((!((map__26525 == null))))?(((((map__26525.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26525.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26525):map__26525);
var file_msg = map__26525__$1;
var request_url = cljs.core.get.call(null,map__26525__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__26525__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__22867__auto___26575 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___26575,out){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___26575,out){
return (function (state_26560){
var state_val_26561 = (state_26560[(1)]);
if((state_val_26561 === (1))){
var inst_26534 = cljs.core.seq.call(null,files);
var inst_26535 = cljs.core.first.call(null,inst_26534);
var inst_26536 = cljs.core.next.call(null,inst_26534);
var inst_26537 = files;
var state_26560__$1 = (function (){var statearr_26562 = state_26560;
(statearr_26562[(7)] = inst_26536);

(statearr_26562[(8)] = inst_26537);

(statearr_26562[(9)] = inst_26535);

return statearr_26562;
})();
var statearr_26563_26576 = state_26560__$1;
(statearr_26563_26576[(2)] = null);

(statearr_26563_26576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26561 === (2))){
var inst_26543 = (state_26560[(10)]);
var inst_26537 = (state_26560[(8)]);
var inst_26542 = cljs.core.seq.call(null,inst_26537);
var inst_26543__$1 = cljs.core.first.call(null,inst_26542);
var inst_26544 = cljs.core.next.call(null,inst_26542);
var inst_26545 = (inst_26543__$1 == null);
var inst_26546 = cljs.core.not.call(null,inst_26545);
var state_26560__$1 = (function (){var statearr_26564 = state_26560;
(statearr_26564[(10)] = inst_26543__$1);

(statearr_26564[(11)] = inst_26544);

return statearr_26564;
})();
if(inst_26546){
var statearr_26565_26577 = state_26560__$1;
(statearr_26565_26577[(1)] = (4));

} else {
var statearr_26566_26578 = state_26560__$1;
(statearr_26566_26578[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26561 === (3))){
var inst_26558 = (state_26560[(2)]);
var state_26560__$1 = state_26560;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26560__$1,inst_26558);
} else {
if((state_val_26561 === (4))){
var inst_26543 = (state_26560[(10)]);
var inst_26548 = figwheel.client.file_reloading.reload_js_file.call(null,inst_26543);
var state_26560__$1 = state_26560;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26560__$1,(7),inst_26548);
} else {
if((state_val_26561 === (5))){
var inst_26554 = cljs.core.async.close_BANG_.call(null,out);
var state_26560__$1 = state_26560;
var statearr_26567_26579 = state_26560__$1;
(statearr_26567_26579[(2)] = inst_26554);

(statearr_26567_26579[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26561 === (6))){
var inst_26556 = (state_26560[(2)]);
var state_26560__$1 = state_26560;
var statearr_26568_26580 = state_26560__$1;
(statearr_26568_26580[(2)] = inst_26556);

(statearr_26568_26580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26561 === (7))){
var inst_26544 = (state_26560[(11)]);
var inst_26550 = (state_26560[(2)]);
var inst_26551 = cljs.core.async.put_BANG_.call(null,out,inst_26550);
var inst_26537 = inst_26544;
var state_26560__$1 = (function (){var statearr_26569 = state_26560;
(statearr_26569[(12)] = inst_26551);

(statearr_26569[(8)] = inst_26537);

return statearr_26569;
})();
var statearr_26570_26581 = state_26560__$1;
(statearr_26570_26581[(2)] = null);

(statearr_26570_26581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__22867__auto___26575,out))
;
return ((function (switch__22772__auto__,c__22867__auto___26575,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto____0 = (function (){
var statearr_26571 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26571[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto__);

(statearr_26571[(1)] = (1));

return statearr_26571;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto____1 = (function (state_26560){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_26560);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e26572){if((e26572 instanceof Object)){
var ex__22776__auto__ = e26572;
var statearr_26573_26582 = state_26560;
(statearr_26573_26582[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26560);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26572;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26583 = state_26560;
state_26560 = G__26583;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto__ = function(state_26560){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto____1.call(this,state_26560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___26575,out))
})();
var state__22869__auto__ = (function (){var statearr_26574 = f__22868__auto__.call(null);
(statearr_26574[(6)] = c__22867__auto___26575);

return statearr_26574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___26575,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__26584,opts){
var map__26585 = p__26584;
var map__26585__$1 = (((((!((map__26585 == null))))?(((((map__26585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26585):map__26585);
var eval_body = cljs.core.get.call(null,map__26585__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__26585__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__4120__auto__ = eval_body;
if(cljs.core.truth_(and__4120__auto__)){
return typeof eval_body === 'string';
} else {
return and__4120__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e26587){var e = e26587;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5718__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__26588_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26588_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5718__auto__)){
var file_msg = temp__5718__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__26589){
var vec__26590 = p__26589;
var k = cljs.core.nth.call(null,vec__26590,(0),null);
var v = cljs.core.nth.call(null,vec__26590,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__26593){
var vec__26594 = p__26593;
var k = cljs.core.nth.call(null,vec__26594,(0),null);
var v = cljs.core.nth.call(null,vec__26594,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__26600,p__26601){
var map__26602 = p__26600;
var map__26602__$1 = (((((!((map__26602 == null))))?(((((map__26602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26602):map__26602);
var opts = map__26602__$1;
var before_jsload = cljs.core.get.call(null,map__26602__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__26602__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__26602__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__26603 = p__26601;
var map__26603__$1 = (((((!((map__26603 == null))))?(((((map__26603.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26603.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26603):map__26603);
var msg = map__26603__$1;
var files = cljs.core.get.call(null,map__26603__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__26603__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__26603__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__22867__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_26757){
var state_val_26758 = (state_26757[(1)]);
if((state_val_26758 === (7))){
var inst_26619 = (state_26757[(7)]);
var inst_26620 = (state_26757[(8)]);
var inst_26618 = (state_26757[(9)]);
var inst_26617 = (state_26757[(10)]);
var inst_26625 = cljs.core._nth.call(null,inst_26618,inst_26620);
var inst_26626 = figwheel.client.file_reloading.eval_body.call(null,inst_26625,opts);
var inst_26627 = (inst_26620 + (1));
var tmp26759 = inst_26619;
var tmp26760 = inst_26618;
var tmp26761 = inst_26617;
var inst_26617__$1 = tmp26761;
var inst_26618__$1 = tmp26760;
var inst_26619__$1 = tmp26759;
var inst_26620__$1 = inst_26627;
var state_26757__$1 = (function (){var statearr_26762 = state_26757;
(statearr_26762[(7)] = inst_26619__$1);

(statearr_26762[(11)] = inst_26626);

(statearr_26762[(8)] = inst_26620__$1);

(statearr_26762[(9)] = inst_26618__$1);

(statearr_26762[(10)] = inst_26617__$1);

return statearr_26762;
})();
var statearr_26763_26846 = state_26757__$1;
(statearr_26763_26846[(2)] = null);

(statearr_26763_26846[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (20))){
var inst_26660 = (state_26757[(12)]);
var inst_26668 = figwheel.client.file_reloading.sort_files.call(null,inst_26660);
var state_26757__$1 = state_26757;
var statearr_26764_26847 = state_26757__$1;
(statearr_26764_26847[(2)] = inst_26668);

(statearr_26764_26847[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (27))){
var state_26757__$1 = state_26757;
var statearr_26765_26848 = state_26757__$1;
(statearr_26765_26848[(2)] = null);

(statearr_26765_26848[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (1))){
var inst_26609 = (state_26757[(13)]);
var inst_26606 = before_jsload.call(null,files);
var inst_26607 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_26608 = (function (){return ((function (inst_26609,inst_26606,inst_26607,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26597_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26597_SHARP_);
});
;})(inst_26609,inst_26606,inst_26607,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26609__$1 = cljs.core.filter.call(null,inst_26608,files);
var inst_26610 = cljs.core.not_empty.call(null,inst_26609__$1);
var state_26757__$1 = (function (){var statearr_26766 = state_26757;
(statearr_26766[(14)] = inst_26606);

(statearr_26766[(15)] = inst_26607);

(statearr_26766[(13)] = inst_26609__$1);

return statearr_26766;
})();
if(cljs.core.truth_(inst_26610)){
var statearr_26767_26849 = state_26757__$1;
(statearr_26767_26849[(1)] = (2));

} else {
var statearr_26768_26850 = state_26757__$1;
(statearr_26768_26850[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (24))){
var state_26757__$1 = state_26757;
var statearr_26769_26851 = state_26757__$1;
(statearr_26769_26851[(2)] = null);

(statearr_26769_26851[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (39))){
var inst_26710 = (state_26757[(16)]);
var state_26757__$1 = state_26757;
var statearr_26770_26852 = state_26757__$1;
(statearr_26770_26852[(2)] = inst_26710);

(statearr_26770_26852[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (46))){
var inst_26752 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
var statearr_26771_26853 = state_26757__$1;
(statearr_26771_26853[(2)] = inst_26752);

(statearr_26771_26853[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (4))){
var inst_26654 = (state_26757[(2)]);
var inst_26655 = cljs.core.List.EMPTY;
var inst_26656 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_26655);
var inst_26657 = (function (){return ((function (inst_26654,inst_26655,inst_26656,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26598_SHARP_){
var and__4120__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26598_SHARP_);
if(cljs.core.truth_(and__4120__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26598_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__26598_SHARP_))));
} else {
return and__4120__auto__;
}
});
;})(inst_26654,inst_26655,inst_26656,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26658 = cljs.core.filter.call(null,inst_26657,files);
var inst_26659 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_26660 = cljs.core.concat.call(null,inst_26658,inst_26659);
var state_26757__$1 = (function (){var statearr_26772 = state_26757;
(statearr_26772[(17)] = inst_26654);

(statearr_26772[(12)] = inst_26660);

(statearr_26772[(18)] = inst_26656);

return statearr_26772;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_26773_26854 = state_26757__$1;
(statearr_26773_26854[(1)] = (16));

} else {
var statearr_26774_26855 = state_26757__$1;
(statearr_26774_26855[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (15))){
var inst_26644 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
var statearr_26775_26856 = state_26757__$1;
(statearr_26775_26856[(2)] = inst_26644);

(statearr_26775_26856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (21))){
var inst_26670 = (state_26757[(19)]);
var inst_26670__$1 = (state_26757[(2)]);
var inst_26671 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_26670__$1);
var state_26757__$1 = (function (){var statearr_26776 = state_26757;
(statearr_26776[(19)] = inst_26670__$1);

return statearr_26776;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26757__$1,(22),inst_26671);
} else {
if((state_val_26758 === (31))){
var inst_26755 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26757__$1,inst_26755);
} else {
if((state_val_26758 === (32))){
var inst_26710 = (state_26757[(16)]);
var inst_26715 = inst_26710.cljs$lang$protocol_mask$partition0$;
var inst_26716 = (inst_26715 & (64));
var inst_26717 = inst_26710.cljs$core$ISeq$;
var inst_26718 = (cljs.core.PROTOCOL_SENTINEL === inst_26717);
var inst_26719 = ((inst_26716) || (inst_26718));
var state_26757__$1 = state_26757;
if(cljs.core.truth_(inst_26719)){
var statearr_26777_26857 = state_26757__$1;
(statearr_26777_26857[(1)] = (35));

} else {
var statearr_26778_26858 = state_26757__$1;
(statearr_26778_26858[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (40))){
var inst_26732 = (state_26757[(20)]);
var inst_26731 = (state_26757[(2)]);
var inst_26732__$1 = cljs.core.get.call(null,inst_26731,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_26733 = cljs.core.get.call(null,inst_26731,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_26734 = cljs.core.not_empty.call(null,inst_26732__$1);
var state_26757__$1 = (function (){var statearr_26779 = state_26757;
(statearr_26779[(21)] = inst_26733);

(statearr_26779[(20)] = inst_26732__$1);

return statearr_26779;
})();
if(cljs.core.truth_(inst_26734)){
var statearr_26780_26859 = state_26757__$1;
(statearr_26780_26859[(1)] = (41));

} else {
var statearr_26781_26860 = state_26757__$1;
(statearr_26781_26860[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (33))){
var state_26757__$1 = state_26757;
var statearr_26782_26861 = state_26757__$1;
(statearr_26782_26861[(2)] = false);

(statearr_26782_26861[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (13))){
var inst_26630 = (state_26757[(22)]);
var inst_26634 = cljs.core.chunk_first.call(null,inst_26630);
var inst_26635 = cljs.core.chunk_rest.call(null,inst_26630);
var inst_26636 = cljs.core.count.call(null,inst_26634);
var inst_26617 = inst_26635;
var inst_26618 = inst_26634;
var inst_26619 = inst_26636;
var inst_26620 = (0);
var state_26757__$1 = (function (){var statearr_26783 = state_26757;
(statearr_26783[(7)] = inst_26619);

(statearr_26783[(8)] = inst_26620);

(statearr_26783[(9)] = inst_26618);

(statearr_26783[(10)] = inst_26617);

return statearr_26783;
})();
var statearr_26784_26862 = state_26757__$1;
(statearr_26784_26862[(2)] = null);

(statearr_26784_26862[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (22))){
var inst_26673 = (state_26757[(23)]);
var inst_26678 = (state_26757[(24)]);
var inst_26670 = (state_26757[(19)]);
var inst_26674 = (state_26757[(25)]);
var inst_26673__$1 = (state_26757[(2)]);
var inst_26674__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26673__$1);
var inst_26675 = (function (){var all_files = inst_26670;
var res_SINGLEQUOTE_ = inst_26673__$1;
var res = inst_26674__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_26673,inst_26678,inst_26670,inst_26674,inst_26673__$1,inst_26674__$1,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26599_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__26599_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_26673,inst_26678,inst_26670,inst_26674,inst_26673__$1,inst_26674__$1,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26676 = cljs.core.filter.call(null,inst_26675,inst_26673__$1);
var inst_26677 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_26678__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26677);
var inst_26679 = cljs.core.not_empty.call(null,inst_26678__$1);
var state_26757__$1 = (function (){var statearr_26785 = state_26757;
(statearr_26785[(23)] = inst_26673__$1);

(statearr_26785[(24)] = inst_26678__$1);

(statearr_26785[(25)] = inst_26674__$1);

(statearr_26785[(26)] = inst_26676);

return statearr_26785;
})();
if(cljs.core.truth_(inst_26679)){
var statearr_26786_26863 = state_26757__$1;
(statearr_26786_26863[(1)] = (23));

} else {
var statearr_26787_26864 = state_26757__$1;
(statearr_26787_26864[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (36))){
var state_26757__$1 = state_26757;
var statearr_26788_26865 = state_26757__$1;
(statearr_26788_26865[(2)] = false);

(statearr_26788_26865[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (41))){
var inst_26732 = (state_26757[(20)]);
var inst_26736 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_26737 = cljs.core.map.call(null,inst_26736,inst_26732);
var inst_26738 = cljs.core.pr_str.call(null,inst_26737);
var inst_26739 = ["figwheel-no-load meta-data: ",inst_26738].join('');
var inst_26740 = figwheel.client.utils.log.call(null,inst_26739);
var state_26757__$1 = state_26757;
var statearr_26789_26866 = state_26757__$1;
(statearr_26789_26866[(2)] = inst_26740);

(statearr_26789_26866[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (43))){
var inst_26733 = (state_26757[(21)]);
var inst_26743 = (state_26757[(2)]);
var inst_26744 = cljs.core.not_empty.call(null,inst_26733);
var state_26757__$1 = (function (){var statearr_26790 = state_26757;
(statearr_26790[(27)] = inst_26743);

return statearr_26790;
})();
if(cljs.core.truth_(inst_26744)){
var statearr_26791_26867 = state_26757__$1;
(statearr_26791_26867[(1)] = (44));

} else {
var statearr_26792_26868 = state_26757__$1;
(statearr_26792_26868[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (29))){
var inst_26673 = (state_26757[(23)]);
var inst_26678 = (state_26757[(24)]);
var inst_26710 = (state_26757[(16)]);
var inst_26670 = (state_26757[(19)]);
var inst_26674 = (state_26757[(25)]);
var inst_26676 = (state_26757[(26)]);
var inst_26706 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_26709 = (function (){var all_files = inst_26670;
var res_SINGLEQUOTE_ = inst_26673;
var res = inst_26674;
var files_not_loaded = inst_26676;
var dependencies_that_loaded = inst_26678;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26710,inst_26670,inst_26674,inst_26676,inst_26706,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26708){
var map__26793 = p__26708;
var map__26793__$1 = (((((!((map__26793 == null))))?(((((map__26793.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26793.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26793):map__26793);
var namespace = cljs.core.get.call(null,map__26793__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26710,inst_26670,inst_26674,inst_26676,inst_26706,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26710__$1 = cljs.core.group_by.call(null,inst_26709,inst_26676);
var inst_26712 = (inst_26710__$1 == null);
var inst_26713 = cljs.core.not.call(null,inst_26712);
var state_26757__$1 = (function (){var statearr_26795 = state_26757;
(statearr_26795[(16)] = inst_26710__$1);

(statearr_26795[(28)] = inst_26706);

return statearr_26795;
})();
if(inst_26713){
var statearr_26796_26869 = state_26757__$1;
(statearr_26796_26869[(1)] = (32));

} else {
var statearr_26797_26870 = state_26757__$1;
(statearr_26797_26870[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (44))){
var inst_26733 = (state_26757[(21)]);
var inst_26746 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26733);
var inst_26747 = cljs.core.pr_str.call(null,inst_26746);
var inst_26748 = ["not required: ",inst_26747].join('');
var inst_26749 = figwheel.client.utils.log.call(null,inst_26748);
var state_26757__$1 = state_26757;
var statearr_26798_26871 = state_26757__$1;
(statearr_26798_26871[(2)] = inst_26749);

(statearr_26798_26871[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (6))){
var inst_26651 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
var statearr_26799_26872 = state_26757__$1;
(statearr_26799_26872[(2)] = inst_26651);

(statearr_26799_26872[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (28))){
var inst_26676 = (state_26757[(26)]);
var inst_26703 = (state_26757[(2)]);
var inst_26704 = cljs.core.not_empty.call(null,inst_26676);
var state_26757__$1 = (function (){var statearr_26800 = state_26757;
(statearr_26800[(29)] = inst_26703);

return statearr_26800;
})();
if(cljs.core.truth_(inst_26704)){
var statearr_26801_26873 = state_26757__$1;
(statearr_26801_26873[(1)] = (29));

} else {
var statearr_26802_26874 = state_26757__$1;
(statearr_26802_26874[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (25))){
var inst_26674 = (state_26757[(25)]);
var inst_26690 = (state_26757[(2)]);
var inst_26691 = cljs.core.not_empty.call(null,inst_26674);
var state_26757__$1 = (function (){var statearr_26803 = state_26757;
(statearr_26803[(30)] = inst_26690);

return statearr_26803;
})();
if(cljs.core.truth_(inst_26691)){
var statearr_26804_26875 = state_26757__$1;
(statearr_26804_26875[(1)] = (26));

} else {
var statearr_26805_26876 = state_26757__$1;
(statearr_26805_26876[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (34))){
var inst_26726 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
if(cljs.core.truth_(inst_26726)){
var statearr_26806_26877 = state_26757__$1;
(statearr_26806_26877[(1)] = (38));

} else {
var statearr_26807_26878 = state_26757__$1;
(statearr_26807_26878[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (17))){
var state_26757__$1 = state_26757;
var statearr_26808_26879 = state_26757__$1;
(statearr_26808_26879[(2)] = recompile_dependents);

(statearr_26808_26879[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (3))){
var state_26757__$1 = state_26757;
var statearr_26809_26880 = state_26757__$1;
(statearr_26809_26880[(2)] = null);

(statearr_26809_26880[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (12))){
var inst_26647 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
var statearr_26810_26881 = state_26757__$1;
(statearr_26810_26881[(2)] = inst_26647);

(statearr_26810_26881[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (2))){
var inst_26609 = (state_26757[(13)]);
var inst_26616 = cljs.core.seq.call(null,inst_26609);
var inst_26617 = inst_26616;
var inst_26618 = null;
var inst_26619 = (0);
var inst_26620 = (0);
var state_26757__$1 = (function (){var statearr_26811 = state_26757;
(statearr_26811[(7)] = inst_26619);

(statearr_26811[(8)] = inst_26620);

(statearr_26811[(9)] = inst_26618);

(statearr_26811[(10)] = inst_26617);

return statearr_26811;
})();
var statearr_26812_26882 = state_26757__$1;
(statearr_26812_26882[(2)] = null);

(statearr_26812_26882[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (23))){
var inst_26673 = (state_26757[(23)]);
var inst_26678 = (state_26757[(24)]);
var inst_26670 = (state_26757[(19)]);
var inst_26674 = (state_26757[(25)]);
var inst_26676 = (state_26757[(26)]);
var inst_26681 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_26683 = (function (){var all_files = inst_26670;
var res_SINGLEQUOTE_ = inst_26673;
var res = inst_26674;
var files_not_loaded = inst_26676;
var dependencies_that_loaded = inst_26678;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26670,inst_26674,inst_26676,inst_26681,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26682){
var map__26813 = p__26682;
var map__26813__$1 = (((((!((map__26813 == null))))?(((((map__26813.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26813.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26813):map__26813);
var request_url = cljs.core.get.call(null,map__26813__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26670,inst_26674,inst_26676,inst_26681,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26684 = cljs.core.reverse.call(null,inst_26678);
var inst_26685 = cljs.core.map.call(null,inst_26683,inst_26684);
var inst_26686 = cljs.core.pr_str.call(null,inst_26685);
var inst_26687 = figwheel.client.utils.log.call(null,inst_26686);
var state_26757__$1 = (function (){var statearr_26815 = state_26757;
(statearr_26815[(31)] = inst_26681);

return statearr_26815;
})();
var statearr_26816_26883 = state_26757__$1;
(statearr_26816_26883[(2)] = inst_26687);

(statearr_26816_26883[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (35))){
var state_26757__$1 = state_26757;
var statearr_26817_26884 = state_26757__$1;
(statearr_26817_26884[(2)] = true);

(statearr_26817_26884[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (19))){
var inst_26660 = (state_26757[(12)]);
var inst_26666 = figwheel.client.file_reloading.expand_files.call(null,inst_26660);
var state_26757__$1 = state_26757;
var statearr_26818_26885 = state_26757__$1;
(statearr_26818_26885[(2)] = inst_26666);

(statearr_26818_26885[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (11))){
var state_26757__$1 = state_26757;
var statearr_26819_26886 = state_26757__$1;
(statearr_26819_26886[(2)] = null);

(statearr_26819_26886[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (9))){
var inst_26649 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
var statearr_26820_26887 = state_26757__$1;
(statearr_26820_26887[(2)] = inst_26649);

(statearr_26820_26887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (5))){
var inst_26619 = (state_26757[(7)]);
var inst_26620 = (state_26757[(8)]);
var inst_26622 = (inst_26620 < inst_26619);
var inst_26623 = inst_26622;
var state_26757__$1 = state_26757;
if(cljs.core.truth_(inst_26623)){
var statearr_26821_26888 = state_26757__$1;
(statearr_26821_26888[(1)] = (7));

} else {
var statearr_26822_26889 = state_26757__$1;
(statearr_26822_26889[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (14))){
var inst_26630 = (state_26757[(22)]);
var inst_26639 = cljs.core.first.call(null,inst_26630);
var inst_26640 = figwheel.client.file_reloading.eval_body.call(null,inst_26639,opts);
var inst_26641 = cljs.core.next.call(null,inst_26630);
var inst_26617 = inst_26641;
var inst_26618 = null;
var inst_26619 = (0);
var inst_26620 = (0);
var state_26757__$1 = (function (){var statearr_26823 = state_26757;
(statearr_26823[(7)] = inst_26619);

(statearr_26823[(8)] = inst_26620);

(statearr_26823[(9)] = inst_26618);

(statearr_26823[(32)] = inst_26640);

(statearr_26823[(10)] = inst_26617);

return statearr_26823;
})();
var statearr_26824_26890 = state_26757__$1;
(statearr_26824_26890[(2)] = null);

(statearr_26824_26890[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (45))){
var state_26757__$1 = state_26757;
var statearr_26825_26891 = state_26757__$1;
(statearr_26825_26891[(2)] = null);

(statearr_26825_26891[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (26))){
var inst_26673 = (state_26757[(23)]);
var inst_26678 = (state_26757[(24)]);
var inst_26670 = (state_26757[(19)]);
var inst_26674 = (state_26757[(25)]);
var inst_26676 = (state_26757[(26)]);
var inst_26693 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_26695 = (function (){var all_files = inst_26670;
var res_SINGLEQUOTE_ = inst_26673;
var res = inst_26674;
var files_not_loaded = inst_26676;
var dependencies_that_loaded = inst_26678;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26670,inst_26674,inst_26676,inst_26693,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26694){
var map__26826 = p__26694;
var map__26826__$1 = (((((!((map__26826 == null))))?(((((map__26826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26826.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26826):map__26826);
var namespace = cljs.core.get.call(null,map__26826__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__26826__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26670,inst_26674,inst_26676,inst_26693,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26696 = cljs.core.map.call(null,inst_26695,inst_26674);
var inst_26697 = cljs.core.pr_str.call(null,inst_26696);
var inst_26698 = figwheel.client.utils.log.call(null,inst_26697);
var inst_26699 = (function (){var all_files = inst_26670;
var res_SINGLEQUOTE_ = inst_26673;
var res = inst_26674;
var files_not_loaded = inst_26676;
var dependencies_that_loaded = inst_26678;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26670,inst_26674,inst_26676,inst_26693,inst_26695,inst_26696,inst_26697,inst_26698,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26673,inst_26678,inst_26670,inst_26674,inst_26676,inst_26693,inst_26695,inst_26696,inst_26697,inst_26698,state_val_26758,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26700 = setTimeout(inst_26699,(10));
var state_26757__$1 = (function (){var statearr_26828 = state_26757;
(statearr_26828[(33)] = inst_26693);

(statearr_26828[(34)] = inst_26698);

return statearr_26828;
})();
var statearr_26829_26892 = state_26757__$1;
(statearr_26829_26892[(2)] = inst_26700);

(statearr_26829_26892[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (16))){
var state_26757__$1 = state_26757;
var statearr_26830_26893 = state_26757__$1;
(statearr_26830_26893[(2)] = reload_dependents);

(statearr_26830_26893[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (38))){
var inst_26710 = (state_26757[(16)]);
var inst_26728 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26710);
var state_26757__$1 = state_26757;
var statearr_26831_26894 = state_26757__$1;
(statearr_26831_26894[(2)] = inst_26728);

(statearr_26831_26894[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (30))){
var state_26757__$1 = state_26757;
var statearr_26832_26895 = state_26757__$1;
(statearr_26832_26895[(2)] = null);

(statearr_26832_26895[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (10))){
var inst_26630 = (state_26757[(22)]);
var inst_26632 = cljs.core.chunked_seq_QMARK_.call(null,inst_26630);
var state_26757__$1 = state_26757;
if(inst_26632){
var statearr_26833_26896 = state_26757__$1;
(statearr_26833_26896[(1)] = (13));

} else {
var statearr_26834_26897 = state_26757__$1;
(statearr_26834_26897[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (18))){
var inst_26664 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
if(cljs.core.truth_(inst_26664)){
var statearr_26835_26898 = state_26757__$1;
(statearr_26835_26898[(1)] = (19));

} else {
var statearr_26836_26899 = state_26757__$1;
(statearr_26836_26899[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (42))){
var state_26757__$1 = state_26757;
var statearr_26837_26900 = state_26757__$1;
(statearr_26837_26900[(2)] = null);

(statearr_26837_26900[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (37))){
var inst_26723 = (state_26757[(2)]);
var state_26757__$1 = state_26757;
var statearr_26838_26901 = state_26757__$1;
(statearr_26838_26901[(2)] = inst_26723);

(statearr_26838_26901[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26758 === (8))){
var inst_26630 = (state_26757[(22)]);
var inst_26617 = (state_26757[(10)]);
var inst_26630__$1 = cljs.core.seq.call(null,inst_26617);
var state_26757__$1 = (function (){var statearr_26839 = state_26757;
(statearr_26839[(22)] = inst_26630__$1);

return statearr_26839;
})();
if(inst_26630__$1){
var statearr_26840_26902 = state_26757__$1;
(statearr_26840_26902[(1)] = (10));

} else {
var statearr_26841_26903 = state_26757__$1;
(statearr_26841_26903[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__22772__auto__,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto____0 = (function (){
var statearr_26842 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26842[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto__);

(statearr_26842[(1)] = (1));

return statearr_26842;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto____1 = (function (state_26757){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_26757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e26843){if((e26843 instanceof Object)){
var ex__22776__auto__ = e26843;
var statearr_26844_26904 = state_26757;
(statearr_26844_26904[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26757);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26843;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26905 = state_26757;
state_26757 = G__26905;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto__ = function(state_26757){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto____1.call(this,state_26757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__22869__auto__ = (function (){var statearr_26845 = f__22868__auto__.call(null);
(statearr_26845[(6)] = c__22867__auto__);

return statearr_26845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto__,map__26602,map__26602__$1,opts,before_jsload,on_jsload,reload_dependents,map__26603,map__26603__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__22867__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__26908,link){
var map__26909 = p__26908;
var map__26909__$1 = (((((!((map__26909 == null))))?(((((map__26909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26909.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26909):map__26909);
var file = cljs.core.get.call(null,map__26909__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5720__auto__ = link.href;
if(cljs.core.truth_(temp__5720__auto__)){
var link_href = temp__5720__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5720__auto__,map__26909,map__26909__$1,file){
return (function (p1__26906_SHARP_,p2__26907_SHARP_){
if(cljs.core._EQ_.call(null,p1__26906_SHARP_,p2__26907_SHARP_)){
return p1__26906_SHARP_;
} else {
return false;
}
});})(link_href,temp__5720__auto__,map__26909,map__26909__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5720__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__26912){
var map__26913 = p__26912;
var map__26913__$1 = (((((!((map__26913 == null))))?(((((map__26913.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26913.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26913):map__26913);
var match_length = cljs.core.get.call(null,map__26913__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__26913__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__26911_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__26911_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5720__auto__)){
var res = temp__5720__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__26915_SHARP_,p2__26916_SHARP_){
return cljs.core.assoc.call(null,p1__26915_SHARP_,cljs.core.get.call(null,p2__26916_SHARP_,key),p2__26916_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5718__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5718__auto__)){
var link = temp__5718__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5718__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5718__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_26917 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_26917);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_26917);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__26918,p__26919){
var map__26920 = p__26918;
var map__26920__$1 = (((((!((map__26920 == null))))?(((((map__26920.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26920.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26920):map__26920);
var on_cssload = cljs.core.get.call(null,map__26920__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__26921 = p__26919;
var map__26921__$1 = (((((!((map__26921 == null))))?(((((map__26921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26921):map__26921);
var files_msg = map__26921__$1;
var files = cljs.core.get.call(null,map__26921__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(figwheel.client.utils.html_env_QMARK_.call(null)){
var temp__5720__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5720__auto__)){
var f_datas = temp__5720__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1549344824672
