// Compiled by ClojureScript 1.10.516 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__22927 = arguments.length;
switch (G__22927) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22928 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22928 = (function (f,blockable,meta22929){
this.f = f;
this.blockable = blockable;
this.meta22929 = meta22929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async22928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22930,meta22929__$1){
var self__ = this;
var _22930__$1 = this;
return (new cljs.core.async.t_cljs$core$async22928(self__.f,self__.blockable,meta22929__$1));
});

cljs.core.async.t_cljs$core$async22928.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22930){
var self__ = this;
var _22930__$1 = this;
return self__.meta22929;
});

cljs.core.async.t_cljs$core$async22928.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22928.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async22928.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async22928.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async22928.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta22929","meta22929",-1036885527,null)], null);
});

cljs.core.async.t_cljs$core$async22928.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22928.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22928";

cljs.core.async.t_cljs$core$async22928.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async22928");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22928.
 */
cljs.core.async.__GT_t_cljs$core$async22928 = (function cljs$core$async$__GT_t_cljs$core$async22928(f__$1,blockable__$1,meta22929){
return (new cljs.core.async.t_cljs$core$async22928(f__$1,blockable__$1,meta22929));
});

}

return (new cljs.core.async.t_cljs$core$async22928(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__22934 = arguments.length;
switch (G__22934) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__22937 = arguments.length;
switch (G__22937) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__22940 = arguments.length;
switch (G__22940) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_22942 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_22942);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_22942,ret){
return (function (){
return fn1.call(null,val_22942);
});})(val_22942,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__22944 = arguments.length;
switch (G__22944) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5718__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5718__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___22946 = n;
var x_22947 = (0);
while(true){
if((x_22947 < n__4607__auto___22946)){
(a[x_22947] = (0));

var G__22948 = (x_22947 + (1));
x_22947 = G__22948;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__22949 = (i + (1));
i = G__22949;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22950 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22950 = (function (flag,meta22951){
this.flag = flag;
this.meta22951 = meta22951;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async22950.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_22952,meta22951__$1){
var self__ = this;
var _22952__$1 = this;
return (new cljs.core.async.t_cljs$core$async22950(self__.flag,meta22951__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async22950.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_22952){
var self__ = this;
var _22952__$1 = this;
return self__.meta22951;
});})(flag))
;

cljs.core.async.t_cljs$core$async22950.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22950.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async22950.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async22950.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async22950.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta22951","meta22951",-1607246112,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async22950.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22950.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22950";

cljs.core.async.t_cljs$core$async22950.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async22950");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22950.
 */
cljs.core.async.__GT_t_cljs$core$async22950 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async22950(flag__$1,meta22951){
return (new cljs.core.async.t_cljs$core$async22950(flag__$1,meta22951));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async22950(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22953 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22953 = (function (flag,cb,meta22954){
this.flag = flag;
this.cb = cb;
this.meta22954 = meta22954;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async22953.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22955,meta22954__$1){
var self__ = this;
var _22955__$1 = this;
return (new cljs.core.async.t_cljs$core$async22953(self__.flag,self__.cb,meta22954__$1));
});

cljs.core.async.t_cljs$core$async22953.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22955){
var self__ = this;
var _22955__$1 = this;
return self__.meta22954;
});

cljs.core.async.t_cljs$core$async22953.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22953.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async22953.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async22953.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async22953.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta22954","meta22954",-1985280144,null)], null);
});

cljs.core.async.t_cljs$core$async22953.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22953.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22953";

cljs.core.async.t_cljs$core$async22953.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async22953");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22953.
 */
cljs.core.async.__GT_t_cljs$core$async22953 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async22953(flag__$1,cb__$1,meta22954){
return (new cljs.core.async.t_cljs$core$async22953(flag__$1,cb__$1,meta22954));
});

}

return (new cljs.core.async.t_cljs$core$async22953(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22956_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22956_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22957_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22957_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__22958 = (i + (1));
i = G__22958;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___22964 = arguments.length;
var i__4731__auto___22965 = (0);
while(true){
if((i__4731__auto___22965 < len__4730__auto___22964)){
args__4736__auto__.push((arguments[i__4731__auto___22965]));

var G__22966 = (i__4731__auto___22965 + (1));
i__4731__auto___22965 = G__22966;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__22961){
var map__22962 = p__22961;
var map__22962__$1 = (((((!((map__22962 == null))))?(((((map__22962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22962):map__22962);
var opts = map__22962__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq22959){
var G__22960 = cljs.core.first.call(null,seq22959);
var seq22959__$1 = cljs.core.next.call(null,seq22959);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22960,seq22959__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__22968 = arguments.length;
switch (G__22968) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__22867__auto___23014 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___23014){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___23014){
return (function (state_22992){
var state_val_22993 = (state_22992[(1)]);
if((state_val_22993 === (7))){
var inst_22988 = (state_22992[(2)]);
var state_22992__$1 = state_22992;
var statearr_22994_23015 = state_22992__$1;
(statearr_22994_23015[(2)] = inst_22988);

(statearr_22994_23015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (1))){
var state_22992__$1 = state_22992;
var statearr_22995_23016 = state_22992__$1;
(statearr_22995_23016[(2)] = null);

(statearr_22995_23016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (4))){
var inst_22971 = (state_22992[(7)]);
var inst_22971__$1 = (state_22992[(2)]);
var inst_22972 = (inst_22971__$1 == null);
var state_22992__$1 = (function (){var statearr_22996 = state_22992;
(statearr_22996[(7)] = inst_22971__$1);

return statearr_22996;
})();
if(cljs.core.truth_(inst_22972)){
var statearr_22997_23017 = state_22992__$1;
(statearr_22997_23017[(1)] = (5));

} else {
var statearr_22998_23018 = state_22992__$1;
(statearr_22998_23018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (13))){
var state_22992__$1 = state_22992;
var statearr_22999_23019 = state_22992__$1;
(statearr_22999_23019[(2)] = null);

(statearr_22999_23019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (6))){
var inst_22971 = (state_22992[(7)]);
var state_22992__$1 = state_22992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22992__$1,(11),to,inst_22971);
} else {
if((state_val_22993 === (3))){
var inst_22990 = (state_22992[(2)]);
var state_22992__$1 = state_22992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22992__$1,inst_22990);
} else {
if((state_val_22993 === (12))){
var state_22992__$1 = state_22992;
var statearr_23000_23020 = state_22992__$1;
(statearr_23000_23020[(2)] = null);

(statearr_23000_23020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (2))){
var state_22992__$1 = state_22992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22992__$1,(4),from);
} else {
if((state_val_22993 === (11))){
var inst_22981 = (state_22992[(2)]);
var state_22992__$1 = state_22992;
if(cljs.core.truth_(inst_22981)){
var statearr_23001_23021 = state_22992__$1;
(statearr_23001_23021[(1)] = (12));

} else {
var statearr_23002_23022 = state_22992__$1;
(statearr_23002_23022[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (9))){
var state_22992__$1 = state_22992;
var statearr_23003_23023 = state_22992__$1;
(statearr_23003_23023[(2)] = null);

(statearr_23003_23023[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (5))){
var state_22992__$1 = state_22992;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23004_23024 = state_22992__$1;
(statearr_23004_23024[(1)] = (8));

} else {
var statearr_23005_23025 = state_22992__$1;
(statearr_23005_23025[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (14))){
var inst_22986 = (state_22992[(2)]);
var state_22992__$1 = state_22992;
var statearr_23006_23026 = state_22992__$1;
(statearr_23006_23026[(2)] = inst_22986);

(statearr_23006_23026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (10))){
var inst_22978 = (state_22992[(2)]);
var state_22992__$1 = state_22992;
var statearr_23007_23027 = state_22992__$1;
(statearr_23007_23027[(2)] = inst_22978);

(statearr_23007_23027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22993 === (8))){
var inst_22975 = cljs.core.async.close_BANG_.call(null,to);
var state_22992__$1 = state_22992;
var statearr_23008_23028 = state_22992__$1;
(statearr_23008_23028[(2)] = inst_22975);

(statearr_23008_23028[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___23014))
;
return ((function (switch__22772__auto__,c__22867__auto___23014){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_23009 = [null,null,null,null,null,null,null,null];
(statearr_23009[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_23009[(1)] = (1));

return statearr_23009;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_22992){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_22992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23010){if((e23010 instanceof Object)){
var ex__22776__auto__ = e23010;
var statearr_23011_23029 = state_22992;
(statearr_23011_23029[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23010;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23030 = state_22992;
state_22992 = G__23030;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_22992){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_22992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___23014))
})();
var state__22869__auto__ = (function (){var statearr_23012 = f__22868__auto__.call(null);
(statearr_23012[(6)] = c__22867__auto___23014);

return statearr_23012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___23014))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__23031){
var vec__23032 = p__23031;
var v = cljs.core.nth.call(null,vec__23032,(0),null);
var p = cljs.core.nth.call(null,vec__23032,(1),null);
var job = vec__23032;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__22867__auto___23203 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___23203,res,vec__23032,v,p,job,jobs,results){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___23203,res,vec__23032,v,p,job,jobs,results){
return (function (state_23039){
var state_val_23040 = (state_23039[(1)]);
if((state_val_23040 === (1))){
var state_23039__$1 = state_23039;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23039__$1,(2),res,v);
} else {
if((state_val_23040 === (2))){
var inst_23036 = (state_23039[(2)]);
var inst_23037 = cljs.core.async.close_BANG_.call(null,res);
var state_23039__$1 = (function (){var statearr_23041 = state_23039;
(statearr_23041[(7)] = inst_23036);

return statearr_23041;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23039__$1,inst_23037);
} else {
return null;
}
}
});})(c__22867__auto___23203,res,vec__23032,v,p,job,jobs,results))
;
return ((function (switch__22772__auto__,c__22867__auto___23203,res,vec__23032,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0 = (function (){
var statearr_23042 = [null,null,null,null,null,null,null,null];
(statearr_23042[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__);

(statearr_23042[(1)] = (1));

return statearr_23042;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1 = (function (state_23039){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23039);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23043){if((e23043 instanceof Object)){
var ex__22776__auto__ = e23043;
var statearr_23044_23204 = state_23039;
(statearr_23044_23204[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23039);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23043;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23205 = state_23039;
state_23039 = G__23205;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = function(state_23039){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1.call(this,state_23039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___23203,res,vec__23032,v,p,job,jobs,results))
})();
var state__22869__auto__ = (function (){var statearr_23045 = f__22868__auto__.call(null);
(statearr_23045[(6)] = c__22867__auto___23203);

return statearr_23045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___23203,res,vec__23032,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__23046){
var vec__23047 = p__23046;
var v = cljs.core.nth.call(null,vec__23047,(0),null);
var p = cljs.core.nth.call(null,vec__23047,(1),null);
var job = vec__23047;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___23206 = n;
var __23207 = (0);
while(true){
if((__23207 < n__4607__auto___23206)){
var G__23050_23208 = type;
var G__23050_23209__$1 = (((G__23050_23208 instanceof cljs.core.Keyword))?G__23050_23208.fqn:null);
switch (G__23050_23209__$1) {
case "compute":
var c__22867__auto___23211 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23207,c__22867__auto___23211,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (__23207,c__22867__auto___23211,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async){
return (function (state_23063){
var state_val_23064 = (state_23063[(1)]);
if((state_val_23064 === (1))){
var state_23063__$1 = state_23063;
var statearr_23065_23212 = state_23063__$1;
(statearr_23065_23212[(2)] = null);

(statearr_23065_23212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23064 === (2))){
var state_23063__$1 = state_23063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23063__$1,(4),jobs);
} else {
if((state_val_23064 === (3))){
var inst_23061 = (state_23063[(2)]);
var state_23063__$1 = state_23063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23063__$1,inst_23061);
} else {
if((state_val_23064 === (4))){
var inst_23053 = (state_23063[(2)]);
var inst_23054 = process.call(null,inst_23053);
var state_23063__$1 = state_23063;
if(cljs.core.truth_(inst_23054)){
var statearr_23066_23213 = state_23063__$1;
(statearr_23066_23213[(1)] = (5));

} else {
var statearr_23067_23214 = state_23063__$1;
(statearr_23067_23214[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23064 === (5))){
var state_23063__$1 = state_23063;
var statearr_23068_23215 = state_23063__$1;
(statearr_23068_23215[(2)] = null);

(statearr_23068_23215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23064 === (6))){
var state_23063__$1 = state_23063;
var statearr_23069_23216 = state_23063__$1;
(statearr_23069_23216[(2)] = null);

(statearr_23069_23216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23064 === (7))){
var inst_23059 = (state_23063[(2)]);
var state_23063__$1 = state_23063;
var statearr_23070_23217 = state_23063__$1;
(statearr_23070_23217[(2)] = inst_23059);

(statearr_23070_23217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23207,c__22867__auto___23211,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async))
;
return ((function (__23207,switch__22772__auto__,c__22867__auto___23211,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0 = (function (){
var statearr_23071 = [null,null,null,null,null,null,null];
(statearr_23071[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__);

(statearr_23071[(1)] = (1));

return statearr_23071;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1 = (function (state_23063){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23072){if((e23072 instanceof Object)){
var ex__22776__auto__ = e23072;
var statearr_23073_23218 = state_23063;
(statearr_23073_23218[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23063);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23072;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23219 = state_23063;
state_23063 = G__23219;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = function(state_23063){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1.call(this,state_23063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__;
})()
;})(__23207,switch__22772__auto__,c__22867__auto___23211,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async))
})();
var state__22869__auto__ = (function (){var statearr_23074 = f__22868__auto__.call(null);
(statearr_23074[(6)] = c__22867__auto___23211);

return statearr_23074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(__23207,c__22867__auto___23211,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async))
);


break;
case "async":
var c__22867__auto___23220 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23207,c__22867__auto___23220,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (__23207,c__22867__auto___23220,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async){
return (function (state_23087){
var state_val_23088 = (state_23087[(1)]);
if((state_val_23088 === (1))){
var state_23087__$1 = state_23087;
var statearr_23089_23221 = state_23087__$1;
(statearr_23089_23221[(2)] = null);

(statearr_23089_23221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23088 === (2))){
var state_23087__$1 = state_23087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23087__$1,(4),jobs);
} else {
if((state_val_23088 === (3))){
var inst_23085 = (state_23087[(2)]);
var state_23087__$1 = state_23087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23087__$1,inst_23085);
} else {
if((state_val_23088 === (4))){
var inst_23077 = (state_23087[(2)]);
var inst_23078 = async.call(null,inst_23077);
var state_23087__$1 = state_23087;
if(cljs.core.truth_(inst_23078)){
var statearr_23090_23222 = state_23087__$1;
(statearr_23090_23222[(1)] = (5));

} else {
var statearr_23091_23223 = state_23087__$1;
(statearr_23091_23223[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23088 === (5))){
var state_23087__$1 = state_23087;
var statearr_23092_23224 = state_23087__$1;
(statearr_23092_23224[(2)] = null);

(statearr_23092_23224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23088 === (6))){
var state_23087__$1 = state_23087;
var statearr_23093_23225 = state_23087__$1;
(statearr_23093_23225[(2)] = null);

(statearr_23093_23225[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23088 === (7))){
var inst_23083 = (state_23087[(2)]);
var state_23087__$1 = state_23087;
var statearr_23094_23226 = state_23087__$1;
(statearr_23094_23226[(2)] = inst_23083);

(statearr_23094_23226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23207,c__22867__auto___23220,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async))
;
return ((function (__23207,switch__22772__auto__,c__22867__auto___23220,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0 = (function (){
var statearr_23095 = [null,null,null,null,null,null,null];
(statearr_23095[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__);

(statearr_23095[(1)] = (1));

return statearr_23095;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1 = (function (state_23087){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23096){if((e23096 instanceof Object)){
var ex__22776__auto__ = e23096;
var statearr_23097_23227 = state_23087;
(statearr_23097_23227[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23096;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23228 = state_23087;
state_23087 = G__23228;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = function(state_23087){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1.call(this,state_23087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__;
})()
;})(__23207,switch__22772__auto__,c__22867__auto___23220,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async))
})();
var state__22869__auto__ = (function (){var statearr_23098 = f__22868__auto__.call(null);
(statearr_23098[(6)] = c__22867__auto___23220);

return statearr_23098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(__23207,c__22867__auto___23220,G__23050_23208,G__23050_23209__$1,n__4607__auto___23206,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23050_23209__$1)].join('')));

}

var G__23229 = (__23207 + (1));
__23207 = G__23229;
continue;
} else {
}
break;
}

var c__22867__auto___23230 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___23230,jobs,results,process,async){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___23230,jobs,results,process,async){
return (function (state_23120){
var state_val_23121 = (state_23120[(1)]);
if((state_val_23121 === (7))){
var inst_23116 = (state_23120[(2)]);
var state_23120__$1 = state_23120;
var statearr_23122_23231 = state_23120__$1;
(statearr_23122_23231[(2)] = inst_23116);

(statearr_23122_23231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23121 === (1))){
var state_23120__$1 = state_23120;
var statearr_23123_23232 = state_23120__$1;
(statearr_23123_23232[(2)] = null);

(statearr_23123_23232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23121 === (4))){
var inst_23101 = (state_23120[(7)]);
var inst_23101__$1 = (state_23120[(2)]);
var inst_23102 = (inst_23101__$1 == null);
var state_23120__$1 = (function (){var statearr_23124 = state_23120;
(statearr_23124[(7)] = inst_23101__$1);

return statearr_23124;
})();
if(cljs.core.truth_(inst_23102)){
var statearr_23125_23233 = state_23120__$1;
(statearr_23125_23233[(1)] = (5));

} else {
var statearr_23126_23234 = state_23120__$1;
(statearr_23126_23234[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23121 === (6))){
var inst_23106 = (state_23120[(8)]);
var inst_23101 = (state_23120[(7)]);
var inst_23106__$1 = cljs.core.async.chan.call(null,(1));
var inst_23107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23108 = [inst_23101,inst_23106__$1];
var inst_23109 = (new cljs.core.PersistentVector(null,2,(5),inst_23107,inst_23108,null));
var state_23120__$1 = (function (){var statearr_23127 = state_23120;
(statearr_23127[(8)] = inst_23106__$1);

return statearr_23127;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23120__$1,(8),jobs,inst_23109);
} else {
if((state_val_23121 === (3))){
var inst_23118 = (state_23120[(2)]);
var state_23120__$1 = state_23120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23120__$1,inst_23118);
} else {
if((state_val_23121 === (2))){
var state_23120__$1 = state_23120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23120__$1,(4),from);
} else {
if((state_val_23121 === (9))){
var inst_23113 = (state_23120[(2)]);
var state_23120__$1 = (function (){var statearr_23128 = state_23120;
(statearr_23128[(9)] = inst_23113);

return statearr_23128;
})();
var statearr_23129_23235 = state_23120__$1;
(statearr_23129_23235[(2)] = null);

(statearr_23129_23235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23121 === (5))){
var inst_23104 = cljs.core.async.close_BANG_.call(null,jobs);
var state_23120__$1 = state_23120;
var statearr_23130_23236 = state_23120__$1;
(statearr_23130_23236[(2)] = inst_23104);

(statearr_23130_23236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23121 === (8))){
var inst_23106 = (state_23120[(8)]);
var inst_23111 = (state_23120[(2)]);
var state_23120__$1 = (function (){var statearr_23131 = state_23120;
(statearr_23131[(10)] = inst_23111);

return statearr_23131;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23120__$1,(9),results,inst_23106);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___23230,jobs,results,process,async))
;
return ((function (switch__22772__auto__,c__22867__auto___23230,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0 = (function (){
var statearr_23132 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23132[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__);

(statearr_23132[(1)] = (1));

return statearr_23132;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1 = (function (state_23120){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23133){if((e23133 instanceof Object)){
var ex__22776__auto__ = e23133;
var statearr_23134_23237 = state_23120;
(statearr_23134_23237[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23133;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23238 = state_23120;
state_23120 = G__23238;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = function(state_23120){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1.call(this,state_23120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___23230,jobs,results,process,async))
})();
var state__22869__auto__ = (function (){var statearr_23135 = f__22868__auto__.call(null);
(statearr_23135[(6)] = c__22867__auto___23230);

return statearr_23135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___23230,jobs,results,process,async))
);


var c__22867__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto__,jobs,results,process,async){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto__,jobs,results,process,async){
return (function (state_23173){
var state_val_23174 = (state_23173[(1)]);
if((state_val_23174 === (7))){
var inst_23169 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23175_23239 = state_23173__$1;
(statearr_23175_23239[(2)] = inst_23169);

(statearr_23175_23239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (20))){
var state_23173__$1 = state_23173;
var statearr_23176_23240 = state_23173__$1;
(statearr_23176_23240[(2)] = null);

(statearr_23176_23240[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (1))){
var state_23173__$1 = state_23173;
var statearr_23177_23241 = state_23173__$1;
(statearr_23177_23241[(2)] = null);

(statearr_23177_23241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (4))){
var inst_23138 = (state_23173[(7)]);
var inst_23138__$1 = (state_23173[(2)]);
var inst_23139 = (inst_23138__$1 == null);
var state_23173__$1 = (function (){var statearr_23178 = state_23173;
(statearr_23178[(7)] = inst_23138__$1);

return statearr_23178;
})();
if(cljs.core.truth_(inst_23139)){
var statearr_23179_23242 = state_23173__$1;
(statearr_23179_23242[(1)] = (5));

} else {
var statearr_23180_23243 = state_23173__$1;
(statearr_23180_23243[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (15))){
var inst_23151 = (state_23173[(8)]);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23173__$1,(18),to,inst_23151);
} else {
if((state_val_23174 === (21))){
var inst_23164 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23181_23244 = state_23173__$1;
(statearr_23181_23244[(2)] = inst_23164);

(statearr_23181_23244[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (13))){
var inst_23166 = (state_23173[(2)]);
var state_23173__$1 = (function (){var statearr_23182 = state_23173;
(statearr_23182[(9)] = inst_23166);

return statearr_23182;
})();
var statearr_23183_23245 = state_23173__$1;
(statearr_23183_23245[(2)] = null);

(statearr_23183_23245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (6))){
var inst_23138 = (state_23173[(7)]);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23173__$1,(11),inst_23138);
} else {
if((state_val_23174 === (17))){
var inst_23159 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23159)){
var statearr_23184_23246 = state_23173__$1;
(statearr_23184_23246[(1)] = (19));

} else {
var statearr_23185_23247 = state_23173__$1;
(statearr_23185_23247[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (3))){
var inst_23171 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23173__$1,inst_23171);
} else {
if((state_val_23174 === (12))){
var inst_23148 = (state_23173[(10)]);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23173__$1,(14),inst_23148);
} else {
if((state_val_23174 === (2))){
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23173__$1,(4),results);
} else {
if((state_val_23174 === (19))){
var state_23173__$1 = state_23173;
var statearr_23186_23248 = state_23173__$1;
(statearr_23186_23248[(2)] = null);

(statearr_23186_23248[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (11))){
var inst_23148 = (state_23173[(2)]);
var state_23173__$1 = (function (){var statearr_23187 = state_23173;
(statearr_23187[(10)] = inst_23148);

return statearr_23187;
})();
var statearr_23188_23249 = state_23173__$1;
(statearr_23188_23249[(2)] = null);

(statearr_23188_23249[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (9))){
var state_23173__$1 = state_23173;
var statearr_23189_23250 = state_23173__$1;
(statearr_23189_23250[(2)] = null);

(statearr_23189_23250[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (5))){
var state_23173__$1 = state_23173;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23190_23251 = state_23173__$1;
(statearr_23190_23251[(1)] = (8));

} else {
var statearr_23191_23252 = state_23173__$1;
(statearr_23191_23252[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (14))){
var inst_23153 = (state_23173[(11)]);
var inst_23151 = (state_23173[(8)]);
var inst_23151__$1 = (state_23173[(2)]);
var inst_23152 = (inst_23151__$1 == null);
var inst_23153__$1 = cljs.core.not.call(null,inst_23152);
var state_23173__$1 = (function (){var statearr_23192 = state_23173;
(statearr_23192[(11)] = inst_23153__$1);

(statearr_23192[(8)] = inst_23151__$1);

return statearr_23192;
})();
if(inst_23153__$1){
var statearr_23193_23253 = state_23173__$1;
(statearr_23193_23253[(1)] = (15));

} else {
var statearr_23194_23254 = state_23173__$1;
(statearr_23194_23254[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (16))){
var inst_23153 = (state_23173[(11)]);
var state_23173__$1 = state_23173;
var statearr_23195_23255 = state_23173__$1;
(statearr_23195_23255[(2)] = inst_23153);

(statearr_23195_23255[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (10))){
var inst_23145 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23196_23256 = state_23173__$1;
(statearr_23196_23256[(2)] = inst_23145);

(statearr_23196_23256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (18))){
var inst_23156 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23197_23257 = state_23173__$1;
(statearr_23197_23257[(2)] = inst_23156);

(statearr_23197_23257[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (8))){
var inst_23142 = cljs.core.async.close_BANG_.call(null,to);
var state_23173__$1 = state_23173;
var statearr_23198_23258 = state_23173__$1;
(statearr_23198_23258[(2)] = inst_23142);

(statearr_23198_23258[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto__,jobs,results,process,async))
;
return ((function (switch__22772__auto__,c__22867__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0 = (function (){
var statearr_23199 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23199[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__);

(statearr_23199[(1)] = (1));

return statearr_23199;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1 = (function (state_23173){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23200){if((e23200 instanceof Object)){
var ex__22776__auto__ = e23200;
var statearr_23201_23259 = state_23173;
(statearr_23201_23259[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23173);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23200;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23260 = state_23173;
state_23173 = G__23260;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__ = function(state_23173){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1.call(this,state_23173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22773__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto__,jobs,results,process,async))
})();
var state__22869__auto__ = (function (){var statearr_23202 = f__22868__auto__.call(null);
(statearr_23202[(6)] = c__22867__auto__);

return statearr_23202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto__,jobs,results,process,async))
);

return c__22867__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__23262 = arguments.length;
switch (G__23262) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__23265 = arguments.length;
switch (G__23265) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__23268 = arguments.length;
switch (G__23268) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__22867__auto___23317 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___23317,tc,fc){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___23317,tc,fc){
return (function (state_23294){
var state_val_23295 = (state_23294[(1)]);
if((state_val_23295 === (7))){
var inst_23290 = (state_23294[(2)]);
var state_23294__$1 = state_23294;
var statearr_23296_23318 = state_23294__$1;
(statearr_23296_23318[(2)] = inst_23290);

(statearr_23296_23318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (1))){
var state_23294__$1 = state_23294;
var statearr_23297_23319 = state_23294__$1;
(statearr_23297_23319[(2)] = null);

(statearr_23297_23319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (4))){
var inst_23271 = (state_23294[(7)]);
var inst_23271__$1 = (state_23294[(2)]);
var inst_23272 = (inst_23271__$1 == null);
var state_23294__$1 = (function (){var statearr_23298 = state_23294;
(statearr_23298[(7)] = inst_23271__$1);

return statearr_23298;
})();
if(cljs.core.truth_(inst_23272)){
var statearr_23299_23320 = state_23294__$1;
(statearr_23299_23320[(1)] = (5));

} else {
var statearr_23300_23321 = state_23294__$1;
(statearr_23300_23321[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (13))){
var state_23294__$1 = state_23294;
var statearr_23301_23322 = state_23294__$1;
(statearr_23301_23322[(2)] = null);

(statearr_23301_23322[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (6))){
var inst_23271 = (state_23294[(7)]);
var inst_23277 = p.call(null,inst_23271);
var state_23294__$1 = state_23294;
if(cljs.core.truth_(inst_23277)){
var statearr_23302_23323 = state_23294__$1;
(statearr_23302_23323[(1)] = (9));

} else {
var statearr_23303_23324 = state_23294__$1;
(statearr_23303_23324[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (3))){
var inst_23292 = (state_23294[(2)]);
var state_23294__$1 = state_23294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23294__$1,inst_23292);
} else {
if((state_val_23295 === (12))){
var state_23294__$1 = state_23294;
var statearr_23304_23325 = state_23294__$1;
(statearr_23304_23325[(2)] = null);

(statearr_23304_23325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (2))){
var state_23294__$1 = state_23294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23294__$1,(4),ch);
} else {
if((state_val_23295 === (11))){
var inst_23271 = (state_23294[(7)]);
var inst_23281 = (state_23294[(2)]);
var state_23294__$1 = state_23294;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23294__$1,(8),inst_23281,inst_23271);
} else {
if((state_val_23295 === (9))){
var state_23294__$1 = state_23294;
var statearr_23305_23326 = state_23294__$1;
(statearr_23305_23326[(2)] = tc);

(statearr_23305_23326[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (5))){
var inst_23274 = cljs.core.async.close_BANG_.call(null,tc);
var inst_23275 = cljs.core.async.close_BANG_.call(null,fc);
var state_23294__$1 = (function (){var statearr_23306 = state_23294;
(statearr_23306[(8)] = inst_23274);

return statearr_23306;
})();
var statearr_23307_23327 = state_23294__$1;
(statearr_23307_23327[(2)] = inst_23275);

(statearr_23307_23327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (14))){
var inst_23288 = (state_23294[(2)]);
var state_23294__$1 = state_23294;
var statearr_23308_23328 = state_23294__$1;
(statearr_23308_23328[(2)] = inst_23288);

(statearr_23308_23328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (10))){
var state_23294__$1 = state_23294;
var statearr_23309_23329 = state_23294__$1;
(statearr_23309_23329[(2)] = fc);

(statearr_23309_23329[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23295 === (8))){
var inst_23283 = (state_23294[(2)]);
var state_23294__$1 = state_23294;
if(cljs.core.truth_(inst_23283)){
var statearr_23310_23330 = state_23294__$1;
(statearr_23310_23330[(1)] = (12));

} else {
var statearr_23311_23331 = state_23294__$1;
(statearr_23311_23331[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___23317,tc,fc))
;
return ((function (switch__22772__auto__,c__22867__auto___23317,tc,fc){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_23312 = [null,null,null,null,null,null,null,null,null];
(statearr_23312[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_23312[(1)] = (1));

return statearr_23312;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_23294){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23313){if((e23313 instanceof Object)){
var ex__22776__auto__ = e23313;
var statearr_23314_23332 = state_23294;
(statearr_23314_23332[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23294);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23313;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23333 = state_23294;
state_23294 = G__23333;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_23294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_23294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___23317,tc,fc))
})();
var state__22869__auto__ = (function (){var statearr_23315 = f__22868__auto__.call(null);
(statearr_23315[(6)] = c__22867__auto___23317);

return statearr_23315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___23317,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__22867__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto__){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto__){
return (function (state_23354){
var state_val_23355 = (state_23354[(1)]);
if((state_val_23355 === (7))){
var inst_23350 = (state_23354[(2)]);
var state_23354__$1 = state_23354;
var statearr_23356_23374 = state_23354__$1;
(statearr_23356_23374[(2)] = inst_23350);

(statearr_23356_23374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23355 === (1))){
var inst_23334 = init;
var state_23354__$1 = (function (){var statearr_23357 = state_23354;
(statearr_23357[(7)] = inst_23334);

return statearr_23357;
})();
var statearr_23358_23375 = state_23354__$1;
(statearr_23358_23375[(2)] = null);

(statearr_23358_23375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23355 === (4))){
var inst_23337 = (state_23354[(8)]);
var inst_23337__$1 = (state_23354[(2)]);
var inst_23338 = (inst_23337__$1 == null);
var state_23354__$1 = (function (){var statearr_23359 = state_23354;
(statearr_23359[(8)] = inst_23337__$1);

return statearr_23359;
})();
if(cljs.core.truth_(inst_23338)){
var statearr_23360_23376 = state_23354__$1;
(statearr_23360_23376[(1)] = (5));

} else {
var statearr_23361_23377 = state_23354__$1;
(statearr_23361_23377[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23355 === (6))){
var inst_23334 = (state_23354[(7)]);
var inst_23337 = (state_23354[(8)]);
var inst_23341 = (state_23354[(9)]);
var inst_23341__$1 = f.call(null,inst_23334,inst_23337);
var inst_23342 = cljs.core.reduced_QMARK_.call(null,inst_23341__$1);
var state_23354__$1 = (function (){var statearr_23362 = state_23354;
(statearr_23362[(9)] = inst_23341__$1);

return statearr_23362;
})();
if(inst_23342){
var statearr_23363_23378 = state_23354__$1;
(statearr_23363_23378[(1)] = (8));

} else {
var statearr_23364_23379 = state_23354__$1;
(statearr_23364_23379[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23355 === (3))){
var inst_23352 = (state_23354[(2)]);
var state_23354__$1 = state_23354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23354__$1,inst_23352);
} else {
if((state_val_23355 === (2))){
var state_23354__$1 = state_23354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23354__$1,(4),ch);
} else {
if((state_val_23355 === (9))){
var inst_23341 = (state_23354[(9)]);
var inst_23334 = inst_23341;
var state_23354__$1 = (function (){var statearr_23365 = state_23354;
(statearr_23365[(7)] = inst_23334);

return statearr_23365;
})();
var statearr_23366_23380 = state_23354__$1;
(statearr_23366_23380[(2)] = null);

(statearr_23366_23380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23355 === (5))){
var inst_23334 = (state_23354[(7)]);
var state_23354__$1 = state_23354;
var statearr_23367_23381 = state_23354__$1;
(statearr_23367_23381[(2)] = inst_23334);

(statearr_23367_23381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23355 === (10))){
var inst_23348 = (state_23354[(2)]);
var state_23354__$1 = state_23354;
var statearr_23368_23382 = state_23354__$1;
(statearr_23368_23382[(2)] = inst_23348);

(statearr_23368_23382[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23355 === (8))){
var inst_23341 = (state_23354[(9)]);
var inst_23344 = cljs.core.deref.call(null,inst_23341);
var state_23354__$1 = state_23354;
var statearr_23369_23383 = state_23354__$1;
(statearr_23369_23383[(2)] = inst_23344);

(statearr_23369_23383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto__))
;
return ((function (switch__22772__auto__,c__22867__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__22773__auto__ = null;
var cljs$core$async$reduce_$_state_machine__22773__auto____0 = (function (){
var statearr_23370 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23370[(0)] = cljs$core$async$reduce_$_state_machine__22773__auto__);

(statearr_23370[(1)] = (1));

return statearr_23370;
});
var cljs$core$async$reduce_$_state_machine__22773__auto____1 = (function (state_23354){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23371){if((e23371 instanceof Object)){
var ex__22776__auto__ = e23371;
var statearr_23372_23384 = state_23354;
(statearr_23372_23384[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23354);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23371;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23385 = state_23354;
state_23354 = G__23385;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__22773__auto__ = function(state_23354){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__22773__auto____1.call(this,state_23354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__22773__auto____0;
cljs$core$async$reduce_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__22773__auto____1;
return cljs$core$async$reduce_$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto__))
})();
var state__22869__auto__ = (function (){var statearr_23373 = f__22868__auto__.call(null);
(statearr_23373[(6)] = c__22867__auto__);

return statearr_23373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto__))
);

return c__22867__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__22867__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto__,f__$1){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto__,f__$1){
return (function (state_23391){
var state_val_23392 = (state_23391[(1)]);
if((state_val_23392 === (1))){
var inst_23386 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23391__$1,(2),inst_23386);
} else {
if((state_val_23392 === (2))){
var inst_23388 = (state_23391[(2)]);
var inst_23389 = f__$1.call(null,inst_23388);
var state_23391__$1 = state_23391;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23391__$1,inst_23389);
} else {
return null;
}
}
});})(c__22867__auto__,f__$1))
;
return ((function (switch__22772__auto__,c__22867__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__22773__auto__ = null;
var cljs$core$async$transduce_$_state_machine__22773__auto____0 = (function (){
var statearr_23393 = [null,null,null,null,null,null,null];
(statearr_23393[(0)] = cljs$core$async$transduce_$_state_machine__22773__auto__);

(statearr_23393[(1)] = (1));

return statearr_23393;
});
var cljs$core$async$transduce_$_state_machine__22773__auto____1 = (function (state_23391){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23391);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23394){if((e23394 instanceof Object)){
var ex__22776__auto__ = e23394;
var statearr_23395_23397 = state_23391;
(statearr_23395_23397[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23391);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23398 = state_23391;
state_23391 = G__23398;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__22773__auto__ = function(state_23391){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__22773__auto____1.call(this,state_23391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__22773__auto____0;
cljs$core$async$transduce_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__22773__auto____1;
return cljs$core$async$transduce_$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto__,f__$1))
})();
var state__22869__auto__ = (function (){var statearr_23396 = f__22868__auto__.call(null);
(statearr_23396[(6)] = c__22867__auto__);

return statearr_23396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto__,f__$1))
);

return c__22867__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__23400 = arguments.length;
switch (G__23400) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__22867__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto__){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto__){
return (function (state_23425){
var state_val_23426 = (state_23425[(1)]);
if((state_val_23426 === (7))){
var inst_23407 = (state_23425[(2)]);
var state_23425__$1 = state_23425;
var statearr_23427_23448 = state_23425__$1;
(statearr_23427_23448[(2)] = inst_23407);

(statearr_23427_23448[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (1))){
var inst_23401 = cljs.core.seq.call(null,coll);
var inst_23402 = inst_23401;
var state_23425__$1 = (function (){var statearr_23428 = state_23425;
(statearr_23428[(7)] = inst_23402);

return statearr_23428;
})();
var statearr_23429_23449 = state_23425__$1;
(statearr_23429_23449[(2)] = null);

(statearr_23429_23449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (4))){
var inst_23402 = (state_23425[(7)]);
var inst_23405 = cljs.core.first.call(null,inst_23402);
var state_23425__$1 = state_23425;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23425__$1,(7),ch,inst_23405);
} else {
if((state_val_23426 === (13))){
var inst_23419 = (state_23425[(2)]);
var state_23425__$1 = state_23425;
var statearr_23430_23450 = state_23425__$1;
(statearr_23430_23450[(2)] = inst_23419);

(statearr_23430_23450[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (6))){
var inst_23410 = (state_23425[(2)]);
var state_23425__$1 = state_23425;
if(cljs.core.truth_(inst_23410)){
var statearr_23431_23451 = state_23425__$1;
(statearr_23431_23451[(1)] = (8));

} else {
var statearr_23432_23452 = state_23425__$1;
(statearr_23432_23452[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (3))){
var inst_23423 = (state_23425[(2)]);
var state_23425__$1 = state_23425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23425__$1,inst_23423);
} else {
if((state_val_23426 === (12))){
var state_23425__$1 = state_23425;
var statearr_23433_23453 = state_23425__$1;
(statearr_23433_23453[(2)] = null);

(statearr_23433_23453[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (2))){
var inst_23402 = (state_23425[(7)]);
var state_23425__$1 = state_23425;
if(cljs.core.truth_(inst_23402)){
var statearr_23434_23454 = state_23425__$1;
(statearr_23434_23454[(1)] = (4));

} else {
var statearr_23435_23455 = state_23425__$1;
(statearr_23435_23455[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (11))){
var inst_23416 = cljs.core.async.close_BANG_.call(null,ch);
var state_23425__$1 = state_23425;
var statearr_23436_23456 = state_23425__$1;
(statearr_23436_23456[(2)] = inst_23416);

(statearr_23436_23456[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (9))){
var state_23425__$1 = state_23425;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23437_23457 = state_23425__$1;
(statearr_23437_23457[(1)] = (11));

} else {
var statearr_23438_23458 = state_23425__$1;
(statearr_23438_23458[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (5))){
var inst_23402 = (state_23425[(7)]);
var state_23425__$1 = state_23425;
var statearr_23439_23459 = state_23425__$1;
(statearr_23439_23459[(2)] = inst_23402);

(statearr_23439_23459[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (10))){
var inst_23421 = (state_23425[(2)]);
var state_23425__$1 = state_23425;
var statearr_23440_23460 = state_23425__$1;
(statearr_23440_23460[(2)] = inst_23421);

(statearr_23440_23460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23426 === (8))){
var inst_23402 = (state_23425[(7)]);
var inst_23412 = cljs.core.next.call(null,inst_23402);
var inst_23402__$1 = inst_23412;
var state_23425__$1 = (function (){var statearr_23441 = state_23425;
(statearr_23441[(7)] = inst_23402__$1);

return statearr_23441;
})();
var statearr_23442_23461 = state_23425__$1;
(statearr_23442_23461[(2)] = null);

(statearr_23442_23461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto__))
;
return ((function (switch__22772__auto__,c__22867__auto__){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_23443 = [null,null,null,null,null,null,null,null];
(statearr_23443[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_23443[(1)] = (1));

return statearr_23443;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_23425){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23444){if((e23444 instanceof Object)){
var ex__22776__auto__ = e23444;
var statearr_23445_23462 = state_23425;
(statearr_23445_23462[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23425);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23444;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23463 = state_23425;
state_23425 = G__23463;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_23425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_23425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto__))
})();
var state__22869__auto__ = (function (){var statearr_23446 = f__22868__auto__.call(null);
(statearr_23446[(6)] = c__22867__auto__);

return statearr_23446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto__))
);

return c__22867__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23464 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23464 = (function (ch,cs,meta23465){
this.ch = ch;
this.cs = cs;
this.meta23465 = meta23465;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_23466,meta23465__$1){
var self__ = this;
var _23466__$1 = this;
return (new cljs.core.async.t_cljs$core$async23464(self__.ch,self__.cs,meta23465__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_23466){
var self__ = this;
var _23466__$1 = this;
return self__.meta23465;
});})(cs))
;

cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async23464.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async23464.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta23465","meta23465",1449816816,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async23464.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23464.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23464";

cljs.core.async.t_cljs$core$async23464.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async23464");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23464.
 */
cljs.core.async.__GT_t_cljs$core$async23464 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async23464(ch__$1,cs__$1,meta23465){
return (new cljs.core.async.t_cljs$core$async23464(ch__$1,cs__$1,meta23465));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async23464(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__22867__auto___23686 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___23686,cs,m,dchan,dctr,done){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___23686,cs,m,dchan,dctr,done){
return (function (state_23601){
var state_val_23602 = (state_23601[(1)]);
if((state_val_23602 === (7))){
var inst_23597 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23603_23687 = state_23601__$1;
(statearr_23603_23687[(2)] = inst_23597);

(statearr_23603_23687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (20))){
var inst_23500 = (state_23601[(7)]);
var inst_23512 = cljs.core.first.call(null,inst_23500);
var inst_23513 = cljs.core.nth.call(null,inst_23512,(0),null);
var inst_23514 = cljs.core.nth.call(null,inst_23512,(1),null);
var state_23601__$1 = (function (){var statearr_23604 = state_23601;
(statearr_23604[(8)] = inst_23513);

return statearr_23604;
})();
if(cljs.core.truth_(inst_23514)){
var statearr_23605_23688 = state_23601__$1;
(statearr_23605_23688[(1)] = (22));

} else {
var statearr_23606_23689 = state_23601__$1;
(statearr_23606_23689[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (27))){
var inst_23544 = (state_23601[(9)]);
var inst_23549 = (state_23601[(10)]);
var inst_23542 = (state_23601[(11)]);
var inst_23469 = (state_23601[(12)]);
var inst_23549__$1 = cljs.core._nth.call(null,inst_23542,inst_23544);
var inst_23550 = cljs.core.async.put_BANG_.call(null,inst_23549__$1,inst_23469,done);
var state_23601__$1 = (function (){var statearr_23607 = state_23601;
(statearr_23607[(10)] = inst_23549__$1);

return statearr_23607;
})();
if(cljs.core.truth_(inst_23550)){
var statearr_23608_23690 = state_23601__$1;
(statearr_23608_23690[(1)] = (30));

} else {
var statearr_23609_23691 = state_23601__$1;
(statearr_23609_23691[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (1))){
var state_23601__$1 = state_23601;
var statearr_23610_23692 = state_23601__$1;
(statearr_23610_23692[(2)] = null);

(statearr_23610_23692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (24))){
var inst_23500 = (state_23601[(7)]);
var inst_23519 = (state_23601[(2)]);
var inst_23520 = cljs.core.next.call(null,inst_23500);
var inst_23478 = inst_23520;
var inst_23479 = null;
var inst_23480 = (0);
var inst_23481 = (0);
var state_23601__$1 = (function (){var statearr_23611 = state_23601;
(statearr_23611[(13)] = inst_23480);

(statearr_23611[(14)] = inst_23481);

(statearr_23611[(15)] = inst_23519);

(statearr_23611[(16)] = inst_23479);

(statearr_23611[(17)] = inst_23478);

return statearr_23611;
})();
var statearr_23612_23693 = state_23601__$1;
(statearr_23612_23693[(2)] = null);

(statearr_23612_23693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (39))){
var state_23601__$1 = state_23601;
var statearr_23616_23694 = state_23601__$1;
(statearr_23616_23694[(2)] = null);

(statearr_23616_23694[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (4))){
var inst_23469 = (state_23601[(12)]);
var inst_23469__$1 = (state_23601[(2)]);
var inst_23470 = (inst_23469__$1 == null);
var state_23601__$1 = (function (){var statearr_23617 = state_23601;
(statearr_23617[(12)] = inst_23469__$1);

return statearr_23617;
})();
if(cljs.core.truth_(inst_23470)){
var statearr_23618_23695 = state_23601__$1;
(statearr_23618_23695[(1)] = (5));

} else {
var statearr_23619_23696 = state_23601__$1;
(statearr_23619_23696[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (15))){
var inst_23480 = (state_23601[(13)]);
var inst_23481 = (state_23601[(14)]);
var inst_23479 = (state_23601[(16)]);
var inst_23478 = (state_23601[(17)]);
var inst_23496 = (state_23601[(2)]);
var inst_23497 = (inst_23481 + (1));
var tmp23613 = inst_23480;
var tmp23614 = inst_23479;
var tmp23615 = inst_23478;
var inst_23478__$1 = tmp23615;
var inst_23479__$1 = tmp23614;
var inst_23480__$1 = tmp23613;
var inst_23481__$1 = inst_23497;
var state_23601__$1 = (function (){var statearr_23620 = state_23601;
(statearr_23620[(13)] = inst_23480__$1);

(statearr_23620[(14)] = inst_23481__$1);

(statearr_23620[(18)] = inst_23496);

(statearr_23620[(16)] = inst_23479__$1);

(statearr_23620[(17)] = inst_23478__$1);

return statearr_23620;
})();
var statearr_23621_23697 = state_23601__$1;
(statearr_23621_23697[(2)] = null);

(statearr_23621_23697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (21))){
var inst_23523 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23625_23698 = state_23601__$1;
(statearr_23625_23698[(2)] = inst_23523);

(statearr_23625_23698[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (31))){
var inst_23549 = (state_23601[(10)]);
var inst_23553 = done.call(null,null);
var inst_23554 = cljs.core.async.untap_STAR_.call(null,m,inst_23549);
var state_23601__$1 = (function (){var statearr_23626 = state_23601;
(statearr_23626[(19)] = inst_23553);

return statearr_23626;
})();
var statearr_23627_23699 = state_23601__$1;
(statearr_23627_23699[(2)] = inst_23554);

(statearr_23627_23699[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (32))){
var inst_23543 = (state_23601[(20)]);
var inst_23544 = (state_23601[(9)]);
var inst_23541 = (state_23601[(21)]);
var inst_23542 = (state_23601[(11)]);
var inst_23556 = (state_23601[(2)]);
var inst_23557 = (inst_23544 + (1));
var tmp23622 = inst_23543;
var tmp23623 = inst_23541;
var tmp23624 = inst_23542;
var inst_23541__$1 = tmp23623;
var inst_23542__$1 = tmp23624;
var inst_23543__$1 = tmp23622;
var inst_23544__$1 = inst_23557;
var state_23601__$1 = (function (){var statearr_23628 = state_23601;
(statearr_23628[(20)] = inst_23543__$1);

(statearr_23628[(9)] = inst_23544__$1);

(statearr_23628[(22)] = inst_23556);

(statearr_23628[(21)] = inst_23541__$1);

(statearr_23628[(11)] = inst_23542__$1);

return statearr_23628;
})();
var statearr_23629_23700 = state_23601__$1;
(statearr_23629_23700[(2)] = null);

(statearr_23629_23700[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (40))){
var inst_23569 = (state_23601[(23)]);
var inst_23573 = done.call(null,null);
var inst_23574 = cljs.core.async.untap_STAR_.call(null,m,inst_23569);
var state_23601__$1 = (function (){var statearr_23630 = state_23601;
(statearr_23630[(24)] = inst_23573);

return statearr_23630;
})();
var statearr_23631_23701 = state_23601__$1;
(statearr_23631_23701[(2)] = inst_23574);

(statearr_23631_23701[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (33))){
var inst_23560 = (state_23601[(25)]);
var inst_23562 = cljs.core.chunked_seq_QMARK_.call(null,inst_23560);
var state_23601__$1 = state_23601;
if(inst_23562){
var statearr_23632_23702 = state_23601__$1;
(statearr_23632_23702[(1)] = (36));

} else {
var statearr_23633_23703 = state_23601__$1;
(statearr_23633_23703[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (13))){
var inst_23490 = (state_23601[(26)]);
var inst_23493 = cljs.core.async.close_BANG_.call(null,inst_23490);
var state_23601__$1 = state_23601;
var statearr_23634_23704 = state_23601__$1;
(statearr_23634_23704[(2)] = inst_23493);

(statearr_23634_23704[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (22))){
var inst_23513 = (state_23601[(8)]);
var inst_23516 = cljs.core.async.close_BANG_.call(null,inst_23513);
var state_23601__$1 = state_23601;
var statearr_23635_23705 = state_23601__$1;
(statearr_23635_23705[(2)] = inst_23516);

(statearr_23635_23705[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (36))){
var inst_23560 = (state_23601[(25)]);
var inst_23564 = cljs.core.chunk_first.call(null,inst_23560);
var inst_23565 = cljs.core.chunk_rest.call(null,inst_23560);
var inst_23566 = cljs.core.count.call(null,inst_23564);
var inst_23541 = inst_23565;
var inst_23542 = inst_23564;
var inst_23543 = inst_23566;
var inst_23544 = (0);
var state_23601__$1 = (function (){var statearr_23636 = state_23601;
(statearr_23636[(20)] = inst_23543);

(statearr_23636[(9)] = inst_23544);

(statearr_23636[(21)] = inst_23541);

(statearr_23636[(11)] = inst_23542);

return statearr_23636;
})();
var statearr_23637_23706 = state_23601__$1;
(statearr_23637_23706[(2)] = null);

(statearr_23637_23706[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (41))){
var inst_23560 = (state_23601[(25)]);
var inst_23576 = (state_23601[(2)]);
var inst_23577 = cljs.core.next.call(null,inst_23560);
var inst_23541 = inst_23577;
var inst_23542 = null;
var inst_23543 = (0);
var inst_23544 = (0);
var state_23601__$1 = (function (){var statearr_23638 = state_23601;
(statearr_23638[(20)] = inst_23543);

(statearr_23638[(9)] = inst_23544);

(statearr_23638[(21)] = inst_23541);

(statearr_23638[(11)] = inst_23542);

(statearr_23638[(27)] = inst_23576);

return statearr_23638;
})();
var statearr_23639_23707 = state_23601__$1;
(statearr_23639_23707[(2)] = null);

(statearr_23639_23707[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (43))){
var state_23601__$1 = state_23601;
var statearr_23640_23708 = state_23601__$1;
(statearr_23640_23708[(2)] = null);

(statearr_23640_23708[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (29))){
var inst_23585 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23641_23709 = state_23601__$1;
(statearr_23641_23709[(2)] = inst_23585);

(statearr_23641_23709[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (44))){
var inst_23594 = (state_23601[(2)]);
var state_23601__$1 = (function (){var statearr_23642 = state_23601;
(statearr_23642[(28)] = inst_23594);

return statearr_23642;
})();
var statearr_23643_23710 = state_23601__$1;
(statearr_23643_23710[(2)] = null);

(statearr_23643_23710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (6))){
var inst_23533 = (state_23601[(29)]);
var inst_23532 = cljs.core.deref.call(null,cs);
var inst_23533__$1 = cljs.core.keys.call(null,inst_23532);
var inst_23534 = cljs.core.count.call(null,inst_23533__$1);
var inst_23535 = cljs.core.reset_BANG_.call(null,dctr,inst_23534);
var inst_23540 = cljs.core.seq.call(null,inst_23533__$1);
var inst_23541 = inst_23540;
var inst_23542 = null;
var inst_23543 = (0);
var inst_23544 = (0);
var state_23601__$1 = (function (){var statearr_23644 = state_23601;
(statearr_23644[(20)] = inst_23543);

(statearr_23644[(9)] = inst_23544);

(statearr_23644[(29)] = inst_23533__$1);

(statearr_23644[(21)] = inst_23541);

(statearr_23644[(11)] = inst_23542);

(statearr_23644[(30)] = inst_23535);

return statearr_23644;
})();
var statearr_23645_23711 = state_23601__$1;
(statearr_23645_23711[(2)] = null);

(statearr_23645_23711[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (28))){
var inst_23560 = (state_23601[(25)]);
var inst_23541 = (state_23601[(21)]);
var inst_23560__$1 = cljs.core.seq.call(null,inst_23541);
var state_23601__$1 = (function (){var statearr_23646 = state_23601;
(statearr_23646[(25)] = inst_23560__$1);

return statearr_23646;
})();
if(inst_23560__$1){
var statearr_23647_23712 = state_23601__$1;
(statearr_23647_23712[(1)] = (33));

} else {
var statearr_23648_23713 = state_23601__$1;
(statearr_23648_23713[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (25))){
var inst_23543 = (state_23601[(20)]);
var inst_23544 = (state_23601[(9)]);
var inst_23546 = (inst_23544 < inst_23543);
var inst_23547 = inst_23546;
var state_23601__$1 = state_23601;
if(cljs.core.truth_(inst_23547)){
var statearr_23649_23714 = state_23601__$1;
(statearr_23649_23714[(1)] = (27));

} else {
var statearr_23650_23715 = state_23601__$1;
(statearr_23650_23715[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (34))){
var state_23601__$1 = state_23601;
var statearr_23651_23716 = state_23601__$1;
(statearr_23651_23716[(2)] = null);

(statearr_23651_23716[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (17))){
var state_23601__$1 = state_23601;
var statearr_23652_23717 = state_23601__$1;
(statearr_23652_23717[(2)] = null);

(statearr_23652_23717[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (3))){
var inst_23599 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23601__$1,inst_23599);
} else {
if((state_val_23602 === (12))){
var inst_23528 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23653_23718 = state_23601__$1;
(statearr_23653_23718[(2)] = inst_23528);

(statearr_23653_23718[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (2))){
var state_23601__$1 = state_23601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23601__$1,(4),ch);
} else {
if((state_val_23602 === (23))){
var state_23601__$1 = state_23601;
var statearr_23654_23719 = state_23601__$1;
(statearr_23654_23719[(2)] = null);

(statearr_23654_23719[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (35))){
var inst_23583 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23655_23720 = state_23601__$1;
(statearr_23655_23720[(2)] = inst_23583);

(statearr_23655_23720[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (19))){
var inst_23500 = (state_23601[(7)]);
var inst_23504 = cljs.core.chunk_first.call(null,inst_23500);
var inst_23505 = cljs.core.chunk_rest.call(null,inst_23500);
var inst_23506 = cljs.core.count.call(null,inst_23504);
var inst_23478 = inst_23505;
var inst_23479 = inst_23504;
var inst_23480 = inst_23506;
var inst_23481 = (0);
var state_23601__$1 = (function (){var statearr_23656 = state_23601;
(statearr_23656[(13)] = inst_23480);

(statearr_23656[(14)] = inst_23481);

(statearr_23656[(16)] = inst_23479);

(statearr_23656[(17)] = inst_23478);

return statearr_23656;
})();
var statearr_23657_23721 = state_23601__$1;
(statearr_23657_23721[(2)] = null);

(statearr_23657_23721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (11))){
var inst_23500 = (state_23601[(7)]);
var inst_23478 = (state_23601[(17)]);
var inst_23500__$1 = cljs.core.seq.call(null,inst_23478);
var state_23601__$1 = (function (){var statearr_23658 = state_23601;
(statearr_23658[(7)] = inst_23500__$1);

return statearr_23658;
})();
if(inst_23500__$1){
var statearr_23659_23722 = state_23601__$1;
(statearr_23659_23722[(1)] = (16));

} else {
var statearr_23660_23723 = state_23601__$1;
(statearr_23660_23723[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (9))){
var inst_23530 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23661_23724 = state_23601__$1;
(statearr_23661_23724[(2)] = inst_23530);

(statearr_23661_23724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (5))){
var inst_23476 = cljs.core.deref.call(null,cs);
var inst_23477 = cljs.core.seq.call(null,inst_23476);
var inst_23478 = inst_23477;
var inst_23479 = null;
var inst_23480 = (0);
var inst_23481 = (0);
var state_23601__$1 = (function (){var statearr_23662 = state_23601;
(statearr_23662[(13)] = inst_23480);

(statearr_23662[(14)] = inst_23481);

(statearr_23662[(16)] = inst_23479);

(statearr_23662[(17)] = inst_23478);

return statearr_23662;
})();
var statearr_23663_23725 = state_23601__$1;
(statearr_23663_23725[(2)] = null);

(statearr_23663_23725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (14))){
var state_23601__$1 = state_23601;
var statearr_23664_23726 = state_23601__$1;
(statearr_23664_23726[(2)] = null);

(statearr_23664_23726[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (45))){
var inst_23591 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23665_23727 = state_23601__$1;
(statearr_23665_23727[(2)] = inst_23591);

(statearr_23665_23727[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (26))){
var inst_23533 = (state_23601[(29)]);
var inst_23587 = (state_23601[(2)]);
var inst_23588 = cljs.core.seq.call(null,inst_23533);
var state_23601__$1 = (function (){var statearr_23666 = state_23601;
(statearr_23666[(31)] = inst_23587);

return statearr_23666;
})();
if(inst_23588){
var statearr_23667_23728 = state_23601__$1;
(statearr_23667_23728[(1)] = (42));

} else {
var statearr_23668_23729 = state_23601__$1;
(statearr_23668_23729[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (16))){
var inst_23500 = (state_23601[(7)]);
var inst_23502 = cljs.core.chunked_seq_QMARK_.call(null,inst_23500);
var state_23601__$1 = state_23601;
if(inst_23502){
var statearr_23669_23730 = state_23601__$1;
(statearr_23669_23730[(1)] = (19));

} else {
var statearr_23670_23731 = state_23601__$1;
(statearr_23670_23731[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (38))){
var inst_23580 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23671_23732 = state_23601__$1;
(statearr_23671_23732[(2)] = inst_23580);

(statearr_23671_23732[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (30))){
var state_23601__$1 = state_23601;
var statearr_23672_23733 = state_23601__$1;
(statearr_23672_23733[(2)] = null);

(statearr_23672_23733[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (10))){
var inst_23481 = (state_23601[(14)]);
var inst_23479 = (state_23601[(16)]);
var inst_23489 = cljs.core._nth.call(null,inst_23479,inst_23481);
var inst_23490 = cljs.core.nth.call(null,inst_23489,(0),null);
var inst_23491 = cljs.core.nth.call(null,inst_23489,(1),null);
var state_23601__$1 = (function (){var statearr_23673 = state_23601;
(statearr_23673[(26)] = inst_23490);

return statearr_23673;
})();
if(cljs.core.truth_(inst_23491)){
var statearr_23674_23734 = state_23601__$1;
(statearr_23674_23734[(1)] = (13));

} else {
var statearr_23675_23735 = state_23601__$1;
(statearr_23675_23735[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (18))){
var inst_23526 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23676_23736 = state_23601__$1;
(statearr_23676_23736[(2)] = inst_23526);

(statearr_23676_23736[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (42))){
var state_23601__$1 = state_23601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23601__$1,(45),dchan);
} else {
if((state_val_23602 === (37))){
var inst_23560 = (state_23601[(25)]);
var inst_23569 = (state_23601[(23)]);
var inst_23469 = (state_23601[(12)]);
var inst_23569__$1 = cljs.core.first.call(null,inst_23560);
var inst_23570 = cljs.core.async.put_BANG_.call(null,inst_23569__$1,inst_23469,done);
var state_23601__$1 = (function (){var statearr_23677 = state_23601;
(statearr_23677[(23)] = inst_23569__$1);

return statearr_23677;
})();
if(cljs.core.truth_(inst_23570)){
var statearr_23678_23737 = state_23601__$1;
(statearr_23678_23737[(1)] = (39));

} else {
var statearr_23679_23738 = state_23601__$1;
(statearr_23679_23738[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (8))){
var inst_23480 = (state_23601[(13)]);
var inst_23481 = (state_23601[(14)]);
var inst_23483 = (inst_23481 < inst_23480);
var inst_23484 = inst_23483;
var state_23601__$1 = state_23601;
if(cljs.core.truth_(inst_23484)){
var statearr_23680_23739 = state_23601__$1;
(statearr_23680_23739[(1)] = (10));

} else {
var statearr_23681_23740 = state_23601__$1;
(statearr_23681_23740[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___23686,cs,m,dchan,dctr,done))
;
return ((function (switch__22772__auto__,c__22867__auto___23686,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__22773__auto__ = null;
var cljs$core$async$mult_$_state_machine__22773__auto____0 = (function (){
var statearr_23682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23682[(0)] = cljs$core$async$mult_$_state_machine__22773__auto__);

(statearr_23682[(1)] = (1));

return statearr_23682;
});
var cljs$core$async$mult_$_state_machine__22773__auto____1 = (function (state_23601){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23683){if((e23683 instanceof Object)){
var ex__22776__auto__ = e23683;
var statearr_23684_23741 = state_23601;
(statearr_23684_23741[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23683;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23742 = state_23601;
state_23601 = G__23742;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__22773__auto__ = function(state_23601){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__22773__auto____1.call(this,state_23601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__22773__auto____0;
cljs$core$async$mult_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__22773__auto____1;
return cljs$core$async$mult_$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___23686,cs,m,dchan,dctr,done))
})();
var state__22869__auto__ = (function (){var statearr_23685 = f__22868__auto__.call(null);
(statearr_23685[(6)] = c__22867__auto___23686);

return statearr_23685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___23686,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__23744 = arguments.length;
switch (G__23744) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___23756 = arguments.length;
var i__4731__auto___23757 = (0);
while(true){
if((i__4731__auto___23757 < len__4730__auto___23756)){
args__4736__auto__.push((arguments[i__4731__auto___23757]));

var G__23758 = (i__4731__auto___23757 + (1));
i__4731__auto___23757 = G__23758;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__23750){
var map__23751 = p__23750;
var map__23751__$1 = (((((!((map__23751 == null))))?(((((map__23751.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23751.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23751):map__23751);
var opts = map__23751__$1;
var statearr_23753_23759 = state;
(statearr_23753_23759[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts.call(null,((function (map__23751,map__23751__$1,opts){
return (function (val){
var statearr_23754_23760 = state;
(statearr_23754_23760[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__23751,map__23751__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_23755_23761 = state;
(statearr_23755_23761[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq23746){
var G__23747 = cljs.core.first.call(null,seq23746);
var seq23746__$1 = cljs.core.next.call(null,seq23746);
var G__23748 = cljs.core.first.call(null,seq23746__$1);
var seq23746__$2 = cljs.core.next.call(null,seq23746__$1);
var G__23749 = cljs.core.first.call(null,seq23746__$2);
var seq23746__$3 = cljs.core.next.call(null,seq23746__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23747,G__23748,G__23749,seq23746__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23762 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23762 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta23763){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta23763 = meta23763;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_23764,meta23763__$1){
var self__ = this;
var _23764__$1 = this;
return (new cljs.core.async.t_cljs$core$async23762(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta23763__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_23764){
var self__ = this;
var _23764__$1 = this;
return self__.meta23763;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta23763","meta23763",-933530078,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23762.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23762.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23762";

cljs.core.async.t_cljs$core$async23762.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async23762");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23762.
 */
cljs.core.async.__GT_t_cljs$core$async23762 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async23762(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23763){
return (new cljs.core.async.t_cljs$core$async23762(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23763));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async23762(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22867__auto___23926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___23926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___23926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_23866){
var state_val_23867 = (state_23866[(1)]);
if((state_val_23867 === (7))){
var inst_23781 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
var statearr_23868_23927 = state_23866__$1;
(statearr_23868_23927[(2)] = inst_23781);

(statearr_23868_23927[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (20))){
var inst_23793 = (state_23866[(7)]);
var state_23866__$1 = state_23866;
var statearr_23869_23928 = state_23866__$1;
(statearr_23869_23928[(2)] = inst_23793);

(statearr_23869_23928[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (27))){
var state_23866__$1 = state_23866;
var statearr_23870_23929 = state_23866__$1;
(statearr_23870_23929[(2)] = null);

(statearr_23870_23929[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (1))){
var inst_23768 = (state_23866[(8)]);
var inst_23768__$1 = calc_state.call(null);
var inst_23770 = (inst_23768__$1 == null);
var inst_23771 = cljs.core.not.call(null,inst_23770);
var state_23866__$1 = (function (){var statearr_23871 = state_23866;
(statearr_23871[(8)] = inst_23768__$1);

return statearr_23871;
})();
if(inst_23771){
var statearr_23872_23930 = state_23866__$1;
(statearr_23872_23930[(1)] = (2));

} else {
var statearr_23873_23931 = state_23866__$1;
(statearr_23873_23931[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (24))){
var inst_23840 = (state_23866[(9)]);
var inst_23826 = (state_23866[(10)]);
var inst_23817 = (state_23866[(11)]);
var inst_23840__$1 = inst_23817.call(null,inst_23826);
var state_23866__$1 = (function (){var statearr_23874 = state_23866;
(statearr_23874[(9)] = inst_23840__$1);

return statearr_23874;
})();
if(cljs.core.truth_(inst_23840__$1)){
var statearr_23875_23932 = state_23866__$1;
(statearr_23875_23932[(1)] = (29));

} else {
var statearr_23876_23933 = state_23866__$1;
(statearr_23876_23933[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (4))){
var inst_23784 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
if(cljs.core.truth_(inst_23784)){
var statearr_23877_23934 = state_23866__$1;
(statearr_23877_23934[(1)] = (8));

} else {
var statearr_23878_23935 = state_23866__$1;
(statearr_23878_23935[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (15))){
var inst_23811 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
if(cljs.core.truth_(inst_23811)){
var statearr_23879_23936 = state_23866__$1;
(statearr_23879_23936[(1)] = (19));

} else {
var statearr_23880_23937 = state_23866__$1;
(statearr_23880_23937[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (21))){
var inst_23816 = (state_23866[(12)]);
var inst_23816__$1 = (state_23866[(2)]);
var inst_23817 = cljs.core.get.call(null,inst_23816__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_23818 = cljs.core.get.call(null,inst_23816__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_23819 = cljs.core.get.call(null,inst_23816__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_23866__$1 = (function (){var statearr_23881 = state_23866;
(statearr_23881[(13)] = inst_23818);

(statearr_23881[(11)] = inst_23817);

(statearr_23881[(12)] = inst_23816__$1);

return statearr_23881;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_23866__$1,(22),inst_23819);
} else {
if((state_val_23867 === (31))){
var inst_23848 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
if(cljs.core.truth_(inst_23848)){
var statearr_23882_23938 = state_23866__$1;
(statearr_23882_23938[(1)] = (32));

} else {
var statearr_23883_23939 = state_23866__$1;
(statearr_23883_23939[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (32))){
var inst_23825 = (state_23866[(14)]);
var state_23866__$1 = state_23866;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23866__$1,(35),out,inst_23825);
} else {
if((state_val_23867 === (33))){
var inst_23816 = (state_23866[(12)]);
var inst_23793 = inst_23816;
var state_23866__$1 = (function (){var statearr_23884 = state_23866;
(statearr_23884[(7)] = inst_23793);

return statearr_23884;
})();
var statearr_23885_23940 = state_23866__$1;
(statearr_23885_23940[(2)] = null);

(statearr_23885_23940[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (13))){
var inst_23793 = (state_23866[(7)]);
var inst_23800 = inst_23793.cljs$lang$protocol_mask$partition0$;
var inst_23801 = (inst_23800 & (64));
var inst_23802 = inst_23793.cljs$core$ISeq$;
var inst_23803 = (cljs.core.PROTOCOL_SENTINEL === inst_23802);
var inst_23804 = ((inst_23801) || (inst_23803));
var state_23866__$1 = state_23866;
if(cljs.core.truth_(inst_23804)){
var statearr_23886_23941 = state_23866__$1;
(statearr_23886_23941[(1)] = (16));

} else {
var statearr_23887_23942 = state_23866__$1;
(statearr_23887_23942[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (22))){
var inst_23825 = (state_23866[(14)]);
var inst_23826 = (state_23866[(10)]);
var inst_23824 = (state_23866[(2)]);
var inst_23825__$1 = cljs.core.nth.call(null,inst_23824,(0),null);
var inst_23826__$1 = cljs.core.nth.call(null,inst_23824,(1),null);
var inst_23827 = (inst_23825__$1 == null);
var inst_23828 = cljs.core._EQ_.call(null,inst_23826__$1,change);
var inst_23829 = ((inst_23827) || (inst_23828));
var state_23866__$1 = (function (){var statearr_23888 = state_23866;
(statearr_23888[(14)] = inst_23825__$1);

(statearr_23888[(10)] = inst_23826__$1);

return statearr_23888;
})();
if(cljs.core.truth_(inst_23829)){
var statearr_23889_23943 = state_23866__$1;
(statearr_23889_23943[(1)] = (23));

} else {
var statearr_23890_23944 = state_23866__$1;
(statearr_23890_23944[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (36))){
var inst_23816 = (state_23866[(12)]);
var inst_23793 = inst_23816;
var state_23866__$1 = (function (){var statearr_23891 = state_23866;
(statearr_23891[(7)] = inst_23793);

return statearr_23891;
})();
var statearr_23892_23945 = state_23866__$1;
(statearr_23892_23945[(2)] = null);

(statearr_23892_23945[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (29))){
var inst_23840 = (state_23866[(9)]);
var state_23866__$1 = state_23866;
var statearr_23893_23946 = state_23866__$1;
(statearr_23893_23946[(2)] = inst_23840);

(statearr_23893_23946[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (6))){
var state_23866__$1 = state_23866;
var statearr_23894_23947 = state_23866__$1;
(statearr_23894_23947[(2)] = false);

(statearr_23894_23947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (28))){
var inst_23836 = (state_23866[(2)]);
var inst_23837 = calc_state.call(null);
var inst_23793 = inst_23837;
var state_23866__$1 = (function (){var statearr_23895 = state_23866;
(statearr_23895[(15)] = inst_23836);

(statearr_23895[(7)] = inst_23793);

return statearr_23895;
})();
var statearr_23896_23948 = state_23866__$1;
(statearr_23896_23948[(2)] = null);

(statearr_23896_23948[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (25))){
var inst_23862 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
var statearr_23897_23949 = state_23866__$1;
(statearr_23897_23949[(2)] = inst_23862);

(statearr_23897_23949[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (34))){
var inst_23860 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
var statearr_23898_23950 = state_23866__$1;
(statearr_23898_23950[(2)] = inst_23860);

(statearr_23898_23950[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (17))){
var state_23866__$1 = state_23866;
var statearr_23899_23951 = state_23866__$1;
(statearr_23899_23951[(2)] = false);

(statearr_23899_23951[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (3))){
var state_23866__$1 = state_23866;
var statearr_23900_23952 = state_23866__$1;
(statearr_23900_23952[(2)] = false);

(statearr_23900_23952[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (12))){
var inst_23864 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23866__$1,inst_23864);
} else {
if((state_val_23867 === (2))){
var inst_23768 = (state_23866[(8)]);
var inst_23773 = inst_23768.cljs$lang$protocol_mask$partition0$;
var inst_23774 = (inst_23773 & (64));
var inst_23775 = inst_23768.cljs$core$ISeq$;
var inst_23776 = (cljs.core.PROTOCOL_SENTINEL === inst_23775);
var inst_23777 = ((inst_23774) || (inst_23776));
var state_23866__$1 = state_23866;
if(cljs.core.truth_(inst_23777)){
var statearr_23901_23953 = state_23866__$1;
(statearr_23901_23953[(1)] = (5));

} else {
var statearr_23902_23954 = state_23866__$1;
(statearr_23902_23954[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (23))){
var inst_23825 = (state_23866[(14)]);
var inst_23831 = (inst_23825 == null);
var state_23866__$1 = state_23866;
if(cljs.core.truth_(inst_23831)){
var statearr_23903_23955 = state_23866__$1;
(statearr_23903_23955[(1)] = (26));

} else {
var statearr_23904_23956 = state_23866__$1;
(statearr_23904_23956[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (35))){
var inst_23851 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
if(cljs.core.truth_(inst_23851)){
var statearr_23905_23957 = state_23866__$1;
(statearr_23905_23957[(1)] = (36));

} else {
var statearr_23906_23958 = state_23866__$1;
(statearr_23906_23958[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (19))){
var inst_23793 = (state_23866[(7)]);
var inst_23813 = cljs.core.apply.call(null,cljs.core.hash_map,inst_23793);
var state_23866__$1 = state_23866;
var statearr_23907_23959 = state_23866__$1;
(statearr_23907_23959[(2)] = inst_23813);

(statearr_23907_23959[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (11))){
var inst_23793 = (state_23866[(7)]);
var inst_23797 = (inst_23793 == null);
var inst_23798 = cljs.core.not.call(null,inst_23797);
var state_23866__$1 = state_23866;
if(inst_23798){
var statearr_23908_23960 = state_23866__$1;
(statearr_23908_23960[(1)] = (13));

} else {
var statearr_23909_23961 = state_23866__$1;
(statearr_23909_23961[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (9))){
var inst_23768 = (state_23866[(8)]);
var state_23866__$1 = state_23866;
var statearr_23910_23962 = state_23866__$1;
(statearr_23910_23962[(2)] = inst_23768);

(statearr_23910_23962[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (5))){
var state_23866__$1 = state_23866;
var statearr_23911_23963 = state_23866__$1;
(statearr_23911_23963[(2)] = true);

(statearr_23911_23963[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (14))){
var state_23866__$1 = state_23866;
var statearr_23912_23964 = state_23866__$1;
(statearr_23912_23964[(2)] = false);

(statearr_23912_23964[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (26))){
var inst_23826 = (state_23866[(10)]);
var inst_23833 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_23826);
var state_23866__$1 = state_23866;
var statearr_23913_23965 = state_23866__$1;
(statearr_23913_23965[(2)] = inst_23833);

(statearr_23913_23965[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (16))){
var state_23866__$1 = state_23866;
var statearr_23914_23966 = state_23866__$1;
(statearr_23914_23966[(2)] = true);

(statearr_23914_23966[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (38))){
var inst_23856 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
var statearr_23915_23967 = state_23866__$1;
(statearr_23915_23967[(2)] = inst_23856);

(statearr_23915_23967[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (30))){
var inst_23826 = (state_23866[(10)]);
var inst_23818 = (state_23866[(13)]);
var inst_23817 = (state_23866[(11)]);
var inst_23843 = cljs.core.empty_QMARK_.call(null,inst_23817);
var inst_23844 = inst_23818.call(null,inst_23826);
var inst_23845 = cljs.core.not.call(null,inst_23844);
var inst_23846 = ((inst_23843) && (inst_23845));
var state_23866__$1 = state_23866;
var statearr_23916_23968 = state_23866__$1;
(statearr_23916_23968[(2)] = inst_23846);

(statearr_23916_23968[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (10))){
var inst_23768 = (state_23866[(8)]);
var inst_23789 = (state_23866[(2)]);
var inst_23790 = cljs.core.get.call(null,inst_23789,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_23791 = cljs.core.get.call(null,inst_23789,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_23792 = cljs.core.get.call(null,inst_23789,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_23793 = inst_23768;
var state_23866__$1 = (function (){var statearr_23917 = state_23866;
(statearr_23917[(16)] = inst_23791);

(statearr_23917[(17)] = inst_23790);

(statearr_23917[(7)] = inst_23793);

(statearr_23917[(18)] = inst_23792);

return statearr_23917;
})();
var statearr_23918_23969 = state_23866__$1;
(statearr_23918_23969[(2)] = null);

(statearr_23918_23969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (18))){
var inst_23808 = (state_23866[(2)]);
var state_23866__$1 = state_23866;
var statearr_23919_23970 = state_23866__$1;
(statearr_23919_23970[(2)] = inst_23808);

(statearr_23919_23970[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (37))){
var state_23866__$1 = state_23866;
var statearr_23920_23971 = state_23866__$1;
(statearr_23920_23971[(2)] = null);

(statearr_23920_23971[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23867 === (8))){
var inst_23768 = (state_23866[(8)]);
var inst_23786 = cljs.core.apply.call(null,cljs.core.hash_map,inst_23768);
var state_23866__$1 = state_23866;
var statearr_23921_23972 = state_23866__$1;
(statearr_23921_23972[(2)] = inst_23786);

(statearr_23921_23972[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___23926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__22772__auto__,c__22867__auto___23926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__22773__auto__ = null;
var cljs$core$async$mix_$_state_machine__22773__auto____0 = (function (){
var statearr_23922 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23922[(0)] = cljs$core$async$mix_$_state_machine__22773__auto__);

(statearr_23922[(1)] = (1));

return statearr_23922;
});
var cljs$core$async$mix_$_state_machine__22773__auto____1 = (function (state_23866){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_23866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e23923){if((e23923 instanceof Object)){
var ex__22776__auto__ = e23923;
var statearr_23924_23973 = state_23866;
(statearr_23924_23973[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23866);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23923;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23974 = state_23866;
state_23866 = G__23974;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__22773__auto__ = function(state_23866){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__22773__auto____1.call(this,state_23866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__22773__auto____0;
cljs$core$async$mix_$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__22773__auto____1;
return cljs$core$async$mix_$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___23926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__22869__auto__ = (function (){var statearr_23925 = f__22868__auto__.call(null);
(statearr_23925[(6)] = c__22867__auto___23926);

return statearr_23925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___23926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__23976 = arguments.length;
switch (G__23976) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__23980 = arguments.length;
switch (G__23980) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__23978_SHARP_){
if(cljs.core.truth_(p1__23978_SHARP_.call(null,topic))){
return p1__23978_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__23978_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23981 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23981 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta23982){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta23982 = meta23982;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_23983,meta23982__$1){
var self__ = this;
var _23983__$1 = this;
return (new cljs.core.async.t_cljs$core$async23981(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta23982__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_23983){
var self__ = this;
var _23983__$1 = this;
return self__.meta23982;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta23982","meta23982",787985991,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23981.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23981.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23981";

cljs.core.async.t_cljs$core$async23981.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async23981");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23981.
 */
cljs.core.async.__GT_t_cljs$core$async23981 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async23981(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23982){
return (new cljs.core.async.t_cljs$core$async23981(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23982));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async23981(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22867__auto___24101 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24101,mults,ensure_mult,p){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24101,mults,ensure_mult,p){
return (function (state_24055){
var state_val_24056 = (state_24055[(1)]);
if((state_val_24056 === (7))){
var inst_24051 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
var statearr_24057_24102 = state_24055__$1;
(statearr_24057_24102[(2)] = inst_24051);

(statearr_24057_24102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (20))){
var state_24055__$1 = state_24055;
var statearr_24058_24103 = state_24055__$1;
(statearr_24058_24103[(2)] = null);

(statearr_24058_24103[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (1))){
var state_24055__$1 = state_24055;
var statearr_24059_24104 = state_24055__$1;
(statearr_24059_24104[(2)] = null);

(statearr_24059_24104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (24))){
var inst_24034 = (state_24055[(7)]);
var inst_24043 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_24034);
var state_24055__$1 = state_24055;
var statearr_24060_24105 = state_24055__$1;
(statearr_24060_24105[(2)] = inst_24043);

(statearr_24060_24105[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (4))){
var inst_23986 = (state_24055[(8)]);
var inst_23986__$1 = (state_24055[(2)]);
var inst_23987 = (inst_23986__$1 == null);
var state_24055__$1 = (function (){var statearr_24061 = state_24055;
(statearr_24061[(8)] = inst_23986__$1);

return statearr_24061;
})();
if(cljs.core.truth_(inst_23987)){
var statearr_24062_24106 = state_24055__$1;
(statearr_24062_24106[(1)] = (5));

} else {
var statearr_24063_24107 = state_24055__$1;
(statearr_24063_24107[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (15))){
var inst_24028 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
var statearr_24064_24108 = state_24055__$1;
(statearr_24064_24108[(2)] = inst_24028);

(statearr_24064_24108[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (21))){
var inst_24048 = (state_24055[(2)]);
var state_24055__$1 = (function (){var statearr_24065 = state_24055;
(statearr_24065[(9)] = inst_24048);

return statearr_24065;
})();
var statearr_24066_24109 = state_24055__$1;
(statearr_24066_24109[(2)] = null);

(statearr_24066_24109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (13))){
var inst_24010 = (state_24055[(10)]);
var inst_24012 = cljs.core.chunked_seq_QMARK_.call(null,inst_24010);
var state_24055__$1 = state_24055;
if(inst_24012){
var statearr_24067_24110 = state_24055__$1;
(statearr_24067_24110[(1)] = (16));

} else {
var statearr_24068_24111 = state_24055__$1;
(statearr_24068_24111[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (22))){
var inst_24040 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
if(cljs.core.truth_(inst_24040)){
var statearr_24069_24112 = state_24055__$1;
(statearr_24069_24112[(1)] = (23));

} else {
var statearr_24070_24113 = state_24055__$1;
(statearr_24070_24113[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (6))){
var inst_23986 = (state_24055[(8)]);
var inst_24036 = (state_24055[(11)]);
var inst_24034 = (state_24055[(7)]);
var inst_24034__$1 = topic_fn.call(null,inst_23986);
var inst_24035 = cljs.core.deref.call(null,mults);
var inst_24036__$1 = cljs.core.get.call(null,inst_24035,inst_24034__$1);
var state_24055__$1 = (function (){var statearr_24071 = state_24055;
(statearr_24071[(11)] = inst_24036__$1);

(statearr_24071[(7)] = inst_24034__$1);

return statearr_24071;
})();
if(cljs.core.truth_(inst_24036__$1)){
var statearr_24072_24114 = state_24055__$1;
(statearr_24072_24114[(1)] = (19));

} else {
var statearr_24073_24115 = state_24055__$1;
(statearr_24073_24115[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (25))){
var inst_24045 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
var statearr_24074_24116 = state_24055__$1;
(statearr_24074_24116[(2)] = inst_24045);

(statearr_24074_24116[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (17))){
var inst_24010 = (state_24055[(10)]);
var inst_24019 = cljs.core.first.call(null,inst_24010);
var inst_24020 = cljs.core.async.muxch_STAR_.call(null,inst_24019);
var inst_24021 = cljs.core.async.close_BANG_.call(null,inst_24020);
var inst_24022 = cljs.core.next.call(null,inst_24010);
var inst_23996 = inst_24022;
var inst_23997 = null;
var inst_23998 = (0);
var inst_23999 = (0);
var state_24055__$1 = (function (){var statearr_24075 = state_24055;
(statearr_24075[(12)] = inst_23998);

(statearr_24075[(13)] = inst_23997);

(statearr_24075[(14)] = inst_24021);

(statearr_24075[(15)] = inst_23996);

(statearr_24075[(16)] = inst_23999);

return statearr_24075;
})();
var statearr_24076_24117 = state_24055__$1;
(statearr_24076_24117[(2)] = null);

(statearr_24076_24117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (3))){
var inst_24053 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24055__$1,inst_24053);
} else {
if((state_val_24056 === (12))){
var inst_24030 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
var statearr_24077_24118 = state_24055__$1;
(statearr_24077_24118[(2)] = inst_24030);

(statearr_24077_24118[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (2))){
var state_24055__$1 = state_24055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24055__$1,(4),ch);
} else {
if((state_val_24056 === (23))){
var state_24055__$1 = state_24055;
var statearr_24078_24119 = state_24055__$1;
(statearr_24078_24119[(2)] = null);

(statearr_24078_24119[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (19))){
var inst_23986 = (state_24055[(8)]);
var inst_24036 = (state_24055[(11)]);
var inst_24038 = cljs.core.async.muxch_STAR_.call(null,inst_24036);
var state_24055__$1 = state_24055;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24055__$1,(22),inst_24038,inst_23986);
} else {
if((state_val_24056 === (11))){
var inst_24010 = (state_24055[(10)]);
var inst_23996 = (state_24055[(15)]);
var inst_24010__$1 = cljs.core.seq.call(null,inst_23996);
var state_24055__$1 = (function (){var statearr_24079 = state_24055;
(statearr_24079[(10)] = inst_24010__$1);

return statearr_24079;
})();
if(inst_24010__$1){
var statearr_24080_24120 = state_24055__$1;
(statearr_24080_24120[(1)] = (13));

} else {
var statearr_24081_24121 = state_24055__$1;
(statearr_24081_24121[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (9))){
var inst_24032 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
var statearr_24082_24122 = state_24055__$1;
(statearr_24082_24122[(2)] = inst_24032);

(statearr_24082_24122[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (5))){
var inst_23993 = cljs.core.deref.call(null,mults);
var inst_23994 = cljs.core.vals.call(null,inst_23993);
var inst_23995 = cljs.core.seq.call(null,inst_23994);
var inst_23996 = inst_23995;
var inst_23997 = null;
var inst_23998 = (0);
var inst_23999 = (0);
var state_24055__$1 = (function (){var statearr_24083 = state_24055;
(statearr_24083[(12)] = inst_23998);

(statearr_24083[(13)] = inst_23997);

(statearr_24083[(15)] = inst_23996);

(statearr_24083[(16)] = inst_23999);

return statearr_24083;
})();
var statearr_24084_24123 = state_24055__$1;
(statearr_24084_24123[(2)] = null);

(statearr_24084_24123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (14))){
var state_24055__$1 = state_24055;
var statearr_24088_24124 = state_24055__$1;
(statearr_24088_24124[(2)] = null);

(statearr_24088_24124[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (16))){
var inst_24010 = (state_24055[(10)]);
var inst_24014 = cljs.core.chunk_first.call(null,inst_24010);
var inst_24015 = cljs.core.chunk_rest.call(null,inst_24010);
var inst_24016 = cljs.core.count.call(null,inst_24014);
var inst_23996 = inst_24015;
var inst_23997 = inst_24014;
var inst_23998 = inst_24016;
var inst_23999 = (0);
var state_24055__$1 = (function (){var statearr_24089 = state_24055;
(statearr_24089[(12)] = inst_23998);

(statearr_24089[(13)] = inst_23997);

(statearr_24089[(15)] = inst_23996);

(statearr_24089[(16)] = inst_23999);

return statearr_24089;
})();
var statearr_24090_24125 = state_24055__$1;
(statearr_24090_24125[(2)] = null);

(statearr_24090_24125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (10))){
var inst_23998 = (state_24055[(12)]);
var inst_23997 = (state_24055[(13)]);
var inst_23996 = (state_24055[(15)]);
var inst_23999 = (state_24055[(16)]);
var inst_24004 = cljs.core._nth.call(null,inst_23997,inst_23999);
var inst_24005 = cljs.core.async.muxch_STAR_.call(null,inst_24004);
var inst_24006 = cljs.core.async.close_BANG_.call(null,inst_24005);
var inst_24007 = (inst_23999 + (1));
var tmp24085 = inst_23998;
var tmp24086 = inst_23997;
var tmp24087 = inst_23996;
var inst_23996__$1 = tmp24087;
var inst_23997__$1 = tmp24086;
var inst_23998__$1 = tmp24085;
var inst_23999__$1 = inst_24007;
var state_24055__$1 = (function (){var statearr_24091 = state_24055;
(statearr_24091[(12)] = inst_23998__$1);

(statearr_24091[(13)] = inst_23997__$1);

(statearr_24091[(17)] = inst_24006);

(statearr_24091[(15)] = inst_23996__$1);

(statearr_24091[(16)] = inst_23999__$1);

return statearr_24091;
})();
var statearr_24092_24126 = state_24055__$1;
(statearr_24092_24126[(2)] = null);

(statearr_24092_24126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (18))){
var inst_24025 = (state_24055[(2)]);
var state_24055__$1 = state_24055;
var statearr_24093_24127 = state_24055__$1;
(statearr_24093_24127[(2)] = inst_24025);

(statearr_24093_24127[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24056 === (8))){
var inst_23998 = (state_24055[(12)]);
var inst_23999 = (state_24055[(16)]);
var inst_24001 = (inst_23999 < inst_23998);
var inst_24002 = inst_24001;
var state_24055__$1 = state_24055;
if(cljs.core.truth_(inst_24002)){
var statearr_24094_24128 = state_24055__$1;
(statearr_24094_24128[(1)] = (10));

} else {
var statearr_24095_24129 = state_24055__$1;
(statearr_24095_24129[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24101,mults,ensure_mult,p))
;
return ((function (switch__22772__auto__,c__22867__auto___24101,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24096[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24096[(1)] = (1));

return statearr_24096;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24055){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24097){if((e24097 instanceof Object)){
var ex__22776__auto__ = e24097;
var statearr_24098_24130 = state_24055;
(statearr_24098_24130[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24055);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24097;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24131 = state_24055;
state_24055 = G__24131;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24055){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24101,mults,ensure_mult,p))
})();
var state__22869__auto__ = (function (){var statearr_24099 = f__22868__auto__.call(null);
(statearr_24099[(6)] = c__22867__auto___24101);

return statearr_24099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24101,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__24133 = arguments.length;
switch (G__24133) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__24136 = arguments.length;
switch (G__24136) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__24139 = arguments.length;
switch (G__24139) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__22867__auto___24206 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24206,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24206,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_24178){
var state_val_24179 = (state_24178[(1)]);
if((state_val_24179 === (7))){
var state_24178__$1 = state_24178;
var statearr_24180_24207 = state_24178__$1;
(statearr_24180_24207[(2)] = null);

(statearr_24180_24207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (1))){
var state_24178__$1 = state_24178;
var statearr_24181_24208 = state_24178__$1;
(statearr_24181_24208[(2)] = null);

(statearr_24181_24208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (4))){
var inst_24142 = (state_24178[(7)]);
var inst_24144 = (inst_24142 < cnt);
var state_24178__$1 = state_24178;
if(cljs.core.truth_(inst_24144)){
var statearr_24182_24209 = state_24178__$1;
(statearr_24182_24209[(1)] = (6));

} else {
var statearr_24183_24210 = state_24178__$1;
(statearr_24183_24210[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (15))){
var inst_24174 = (state_24178[(2)]);
var state_24178__$1 = state_24178;
var statearr_24184_24211 = state_24178__$1;
(statearr_24184_24211[(2)] = inst_24174);

(statearr_24184_24211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (13))){
var inst_24167 = cljs.core.async.close_BANG_.call(null,out);
var state_24178__$1 = state_24178;
var statearr_24185_24212 = state_24178__$1;
(statearr_24185_24212[(2)] = inst_24167);

(statearr_24185_24212[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (6))){
var state_24178__$1 = state_24178;
var statearr_24186_24213 = state_24178__$1;
(statearr_24186_24213[(2)] = null);

(statearr_24186_24213[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (3))){
var inst_24176 = (state_24178[(2)]);
var state_24178__$1 = state_24178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24178__$1,inst_24176);
} else {
if((state_val_24179 === (12))){
var inst_24164 = (state_24178[(8)]);
var inst_24164__$1 = (state_24178[(2)]);
var inst_24165 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_24164__$1);
var state_24178__$1 = (function (){var statearr_24187 = state_24178;
(statearr_24187[(8)] = inst_24164__$1);

return statearr_24187;
})();
if(cljs.core.truth_(inst_24165)){
var statearr_24188_24214 = state_24178__$1;
(statearr_24188_24214[(1)] = (13));

} else {
var statearr_24189_24215 = state_24178__$1;
(statearr_24189_24215[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (2))){
var inst_24141 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_24142 = (0);
var state_24178__$1 = (function (){var statearr_24190 = state_24178;
(statearr_24190[(7)] = inst_24142);

(statearr_24190[(9)] = inst_24141);

return statearr_24190;
})();
var statearr_24191_24216 = state_24178__$1;
(statearr_24191_24216[(2)] = null);

(statearr_24191_24216[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (11))){
var inst_24142 = (state_24178[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_24178,(10),Object,null,(9));
var inst_24151 = chs__$1.call(null,inst_24142);
var inst_24152 = done.call(null,inst_24142);
var inst_24153 = cljs.core.async.take_BANG_.call(null,inst_24151,inst_24152);
var state_24178__$1 = state_24178;
var statearr_24192_24217 = state_24178__$1;
(statearr_24192_24217[(2)] = inst_24153);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24178__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (9))){
var inst_24142 = (state_24178[(7)]);
var inst_24155 = (state_24178[(2)]);
var inst_24156 = (inst_24142 + (1));
var inst_24142__$1 = inst_24156;
var state_24178__$1 = (function (){var statearr_24193 = state_24178;
(statearr_24193[(7)] = inst_24142__$1);

(statearr_24193[(10)] = inst_24155);

return statearr_24193;
})();
var statearr_24194_24218 = state_24178__$1;
(statearr_24194_24218[(2)] = null);

(statearr_24194_24218[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (5))){
var inst_24162 = (state_24178[(2)]);
var state_24178__$1 = (function (){var statearr_24195 = state_24178;
(statearr_24195[(11)] = inst_24162);

return statearr_24195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24178__$1,(12),dchan);
} else {
if((state_val_24179 === (14))){
var inst_24164 = (state_24178[(8)]);
var inst_24169 = cljs.core.apply.call(null,f,inst_24164);
var state_24178__$1 = state_24178;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24178__$1,(16),out,inst_24169);
} else {
if((state_val_24179 === (16))){
var inst_24171 = (state_24178[(2)]);
var state_24178__$1 = (function (){var statearr_24196 = state_24178;
(statearr_24196[(12)] = inst_24171);

return statearr_24196;
})();
var statearr_24197_24219 = state_24178__$1;
(statearr_24197_24219[(2)] = null);

(statearr_24197_24219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (10))){
var inst_24146 = (state_24178[(2)]);
var inst_24147 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_24178__$1 = (function (){var statearr_24198 = state_24178;
(statearr_24198[(13)] = inst_24146);

return statearr_24198;
})();
var statearr_24199_24220 = state_24178__$1;
(statearr_24199_24220[(2)] = inst_24147);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24178__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24179 === (8))){
var inst_24160 = (state_24178[(2)]);
var state_24178__$1 = state_24178;
var statearr_24200_24221 = state_24178__$1;
(statearr_24200_24221[(2)] = inst_24160);

(statearr_24200_24221[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24206,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__22772__auto__,c__22867__auto___24206,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24201 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24201[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24201[(1)] = (1));

return statearr_24201;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24178){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24202){if((e24202 instanceof Object)){
var ex__22776__auto__ = e24202;
var statearr_24203_24222 = state_24178;
(statearr_24203_24222[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24178);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24202;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24223 = state_24178;
state_24178 = G__24223;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24178){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24206,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__22869__auto__ = (function (){var statearr_24204 = f__22868__auto__.call(null);
(statearr_24204[(6)] = c__22867__auto___24206);

return statearr_24204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24206,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__24226 = arguments.length;
switch (G__24226) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22867__auto___24280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24280,out){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24280,out){
return (function (state_24258){
var state_val_24259 = (state_24258[(1)]);
if((state_val_24259 === (7))){
var inst_24238 = (state_24258[(7)]);
var inst_24237 = (state_24258[(8)]);
var inst_24237__$1 = (state_24258[(2)]);
var inst_24238__$1 = cljs.core.nth.call(null,inst_24237__$1,(0),null);
var inst_24239 = cljs.core.nth.call(null,inst_24237__$1,(1),null);
var inst_24240 = (inst_24238__$1 == null);
var state_24258__$1 = (function (){var statearr_24260 = state_24258;
(statearr_24260[(7)] = inst_24238__$1);

(statearr_24260[(9)] = inst_24239);

(statearr_24260[(8)] = inst_24237__$1);

return statearr_24260;
})();
if(cljs.core.truth_(inst_24240)){
var statearr_24261_24281 = state_24258__$1;
(statearr_24261_24281[(1)] = (8));

} else {
var statearr_24262_24282 = state_24258__$1;
(statearr_24262_24282[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24259 === (1))){
var inst_24227 = cljs.core.vec.call(null,chs);
var inst_24228 = inst_24227;
var state_24258__$1 = (function (){var statearr_24263 = state_24258;
(statearr_24263[(10)] = inst_24228);

return statearr_24263;
})();
var statearr_24264_24283 = state_24258__$1;
(statearr_24264_24283[(2)] = null);

(statearr_24264_24283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24259 === (4))){
var inst_24228 = (state_24258[(10)]);
var state_24258__$1 = state_24258;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24258__$1,(7),inst_24228);
} else {
if((state_val_24259 === (6))){
var inst_24254 = (state_24258[(2)]);
var state_24258__$1 = state_24258;
var statearr_24265_24284 = state_24258__$1;
(statearr_24265_24284[(2)] = inst_24254);

(statearr_24265_24284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24259 === (3))){
var inst_24256 = (state_24258[(2)]);
var state_24258__$1 = state_24258;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24258__$1,inst_24256);
} else {
if((state_val_24259 === (2))){
var inst_24228 = (state_24258[(10)]);
var inst_24230 = cljs.core.count.call(null,inst_24228);
var inst_24231 = (inst_24230 > (0));
var state_24258__$1 = state_24258;
if(cljs.core.truth_(inst_24231)){
var statearr_24267_24285 = state_24258__$1;
(statearr_24267_24285[(1)] = (4));

} else {
var statearr_24268_24286 = state_24258__$1;
(statearr_24268_24286[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24259 === (11))){
var inst_24228 = (state_24258[(10)]);
var inst_24247 = (state_24258[(2)]);
var tmp24266 = inst_24228;
var inst_24228__$1 = tmp24266;
var state_24258__$1 = (function (){var statearr_24269 = state_24258;
(statearr_24269[(10)] = inst_24228__$1);

(statearr_24269[(11)] = inst_24247);

return statearr_24269;
})();
var statearr_24270_24287 = state_24258__$1;
(statearr_24270_24287[(2)] = null);

(statearr_24270_24287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24259 === (9))){
var inst_24238 = (state_24258[(7)]);
var state_24258__$1 = state_24258;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24258__$1,(11),out,inst_24238);
} else {
if((state_val_24259 === (5))){
var inst_24252 = cljs.core.async.close_BANG_.call(null,out);
var state_24258__$1 = state_24258;
var statearr_24271_24288 = state_24258__$1;
(statearr_24271_24288[(2)] = inst_24252);

(statearr_24271_24288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24259 === (10))){
var inst_24250 = (state_24258[(2)]);
var state_24258__$1 = state_24258;
var statearr_24272_24289 = state_24258__$1;
(statearr_24272_24289[(2)] = inst_24250);

(statearr_24272_24289[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24259 === (8))){
var inst_24238 = (state_24258[(7)]);
var inst_24228 = (state_24258[(10)]);
var inst_24239 = (state_24258[(9)]);
var inst_24237 = (state_24258[(8)]);
var inst_24242 = (function (){var cs = inst_24228;
var vec__24233 = inst_24237;
var v = inst_24238;
var c = inst_24239;
return ((function (cs,vec__24233,v,c,inst_24238,inst_24228,inst_24239,inst_24237,state_val_24259,c__22867__auto___24280,out){
return (function (p1__24224_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__24224_SHARP_);
});
;})(cs,vec__24233,v,c,inst_24238,inst_24228,inst_24239,inst_24237,state_val_24259,c__22867__auto___24280,out))
})();
var inst_24243 = cljs.core.filterv.call(null,inst_24242,inst_24228);
var inst_24228__$1 = inst_24243;
var state_24258__$1 = (function (){var statearr_24273 = state_24258;
(statearr_24273[(10)] = inst_24228__$1);

return statearr_24273;
})();
var statearr_24274_24290 = state_24258__$1;
(statearr_24274_24290[(2)] = null);

(statearr_24274_24290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24280,out))
;
return ((function (switch__22772__auto__,c__22867__auto___24280,out){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24275 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24275[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24275[(1)] = (1));

return statearr_24275;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24258){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24258);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24276){if((e24276 instanceof Object)){
var ex__22776__auto__ = e24276;
var statearr_24277_24291 = state_24258;
(statearr_24277_24291[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24258);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24276;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24292 = state_24258;
state_24258 = G__24292;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24258){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24280,out))
})();
var state__22869__auto__ = (function (){var statearr_24278 = f__22868__auto__.call(null);
(statearr_24278[(6)] = c__22867__auto___24280);

return statearr_24278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24280,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__24294 = arguments.length;
switch (G__24294) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22867__auto___24339 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24339,out){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24339,out){
return (function (state_24318){
var state_val_24319 = (state_24318[(1)]);
if((state_val_24319 === (7))){
var inst_24300 = (state_24318[(7)]);
var inst_24300__$1 = (state_24318[(2)]);
var inst_24301 = (inst_24300__$1 == null);
var inst_24302 = cljs.core.not.call(null,inst_24301);
var state_24318__$1 = (function (){var statearr_24320 = state_24318;
(statearr_24320[(7)] = inst_24300__$1);

return statearr_24320;
})();
if(inst_24302){
var statearr_24321_24340 = state_24318__$1;
(statearr_24321_24340[(1)] = (8));

} else {
var statearr_24322_24341 = state_24318__$1;
(statearr_24322_24341[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (1))){
var inst_24295 = (0);
var state_24318__$1 = (function (){var statearr_24323 = state_24318;
(statearr_24323[(8)] = inst_24295);

return statearr_24323;
})();
var statearr_24324_24342 = state_24318__$1;
(statearr_24324_24342[(2)] = null);

(statearr_24324_24342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (4))){
var state_24318__$1 = state_24318;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24318__$1,(7),ch);
} else {
if((state_val_24319 === (6))){
var inst_24313 = (state_24318[(2)]);
var state_24318__$1 = state_24318;
var statearr_24325_24343 = state_24318__$1;
(statearr_24325_24343[(2)] = inst_24313);

(statearr_24325_24343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (3))){
var inst_24315 = (state_24318[(2)]);
var inst_24316 = cljs.core.async.close_BANG_.call(null,out);
var state_24318__$1 = (function (){var statearr_24326 = state_24318;
(statearr_24326[(9)] = inst_24315);

return statearr_24326;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24318__$1,inst_24316);
} else {
if((state_val_24319 === (2))){
var inst_24295 = (state_24318[(8)]);
var inst_24297 = (inst_24295 < n);
var state_24318__$1 = state_24318;
if(cljs.core.truth_(inst_24297)){
var statearr_24327_24344 = state_24318__$1;
(statearr_24327_24344[(1)] = (4));

} else {
var statearr_24328_24345 = state_24318__$1;
(statearr_24328_24345[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (11))){
var inst_24295 = (state_24318[(8)]);
var inst_24305 = (state_24318[(2)]);
var inst_24306 = (inst_24295 + (1));
var inst_24295__$1 = inst_24306;
var state_24318__$1 = (function (){var statearr_24329 = state_24318;
(statearr_24329[(10)] = inst_24305);

(statearr_24329[(8)] = inst_24295__$1);

return statearr_24329;
})();
var statearr_24330_24346 = state_24318__$1;
(statearr_24330_24346[(2)] = null);

(statearr_24330_24346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (9))){
var state_24318__$1 = state_24318;
var statearr_24331_24347 = state_24318__$1;
(statearr_24331_24347[(2)] = null);

(statearr_24331_24347[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (5))){
var state_24318__$1 = state_24318;
var statearr_24332_24348 = state_24318__$1;
(statearr_24332_24348[(2)] = null);

(statearr_24332_24348[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (10))){
var inst_24310 = (state_24318[(2)]);
var state_24318__$1 = state_24318;
var statearr_24333_24349 = state_24318__$1;
(statearr_24333_24349[(2)] = inst_24310);

(statearr_24333_24349[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24319 === (8))){
var inst_24300 = (state_24318[(7)]);
var state_24318__$1 = state_24318;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24318__$1,(11),out,inst_24300);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24339,out))
;
return ((function (switch__22772__auto__,c__22867__auto___24339,out){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24334 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24334[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24334[(1)] = (1));

return statearr_24334;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24318){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24335){if((e24335 instanceof Object)){
var ex__22776__auto__ = e24335;
var statearr_24336_24350 = state_24318;
(statearr_24336_24350[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24351 = state_24318;
state_24318 = G__24351;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24318){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24339,out))
})();
var state__22869__auto__ = (function (){var statearr_24337 = f__22868__auto__.call(null);
(statearr_24337[(6)] = c__22867__auto___24339);

return statearr_24337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24339,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24353 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24353 = (function (f,ch,meta24354){
this.f = f;
this.ch = ch;
this.meta24354 = meta24354;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24355,meta24354__$1){
var self__ = this;
var _24355__$1 = this;
return (new cljs.core.async.t_cljs$core$async24353(self__.f,self__.ch,meta24354__$1));
});

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24355){
var self__ = this;
var _24355__$1 = this;
return self__.meta24354;
});

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24356 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24356 = (function (f,ch,meta24354,_,fn1,meta24357){
this.f = f;
this.ch = ch;
this.meta24354 = meta24354;
this._ = _;
this.fn1 = fn1;
this.meta24357 = meta24357;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_24358,meta24357__$1){
var self__ = this;
var _24358__$1 = this;
return (new cljs.core.async.t_cljs$core$async24356(self__.f,self__.ch,self__.meta24354,self__._,self__.fn1,meta24357__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_24358){
var self__ = this;
var _24358__$1 = this;
return self__.meta24357;
});})(___$1))
;

cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async24356.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__24352_SHARP_){
return f1.call(null,(((p1__24352_SHARP_ == null))?null:self__.f.call(null,p1__24352_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async24356.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24354","meta24354",-1010726284,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async24353","cljs.core.async/t_cljs$core$async24353",-1750659841,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta24357","meta24357",-863697096,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async24356.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24356.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24356";

cljs.core.async.t_cljs$core$async24356.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24356");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24356.
 */
cljs.core.async.__GT_t_cljs$core$async24356 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24356(f__$1,ch__$1,meta24354__$1,___$2,fn1__$1,meta24357){
return (new cljs.core.async.t_cljs$core$async24356(f__$1,ch__$1,meta24354__$1,___$2,fn1__$1,meta24357));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async24356(self__.f,self__.ch,self__.meta24354,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24353.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async24353.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24354","meta24354",-1010726284,null)], null);
});

cljs.core.async.t_cljs$core$async24353.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24353.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24353";

cljs.core.async.t_cljs$core$async24353.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24353");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24353.
 */
cljs.core.async.__GT_t_cljs$core$async24353 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24353(f__$1,ch__$1,meta24354){
return (new cljs.core.async.t_cljs$core$async24353(f__$1,ch__$1,meta24354));
});

}

return (new cljs.core.async.t_cljs$core$async24353(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24359 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24359 = (function (f,ch,meta24360){
this.f = f;
this.ch = ch;
this.meta24360 = meta24360;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24361,meta24360__$1){
var self__ = this;
var _24361__$1 = this;
return (new cljs.core.async.t_cljs$core$async24359(self__.f,self__.ch,meta24360__$1));
});

cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24361){
var self__ = this;
var _24361__$1 = this;
return self__.meta24360;
});

cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24359.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async24359.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24360","meta24360",-391346438,null)], null);
});

cljs.core.async.t_cljs$core$async24359.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24359.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24359";

cljs.core.async.t_cljs$core$async24359.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24359");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24359.
 */
cljs.core.async.__GT_t_cljs$core$async24359 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async24359(f__$1,ch__$1,meta24360){
return (new cljs.core.async.t_cljs$core$async24359(f__$1,ch__$1,meta24360));
});

}

return (new cljs.core.async.t_cljs$core$async24359(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24362 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24362 = (function (p,ch,meta24363){
this.p = p;
this.ch = ch;
this.meta24363 = meta24363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24364,meta24363__$1){
var self__ = this;
var _24364__$1 = this;
return (new cljs.core.async.t_cljs$core$async24362(self__.p,self__.ch,meta24363__$1));
});

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24364){
var self__ = this;
var _24364__$1 = this;
return self__.meta24363;
});

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24362.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async24362.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24363","meta24363",242194381,null)], null);
});

cljs.core.async.t_cljs$core$async24362.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24362.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24362";

cljs.core.async.t_cljs$core$async24362.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async24362");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24362.
 */
cljs.core.async.__GT_t_cljs$core$async24362 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async24362(p__$1,ch__$1,meta24363){
return (new cljs.core.async.t_cljs$core$async24362(p__$1,ch__$1,meta24363));
});

}

return (new cljs.core.async.t_cljs$core$async24362(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__24366 = arguments.length;
switch (G__24366) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22867__auto___24406 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24406,out){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24406,out){
return (function (state_24387){
var state_val_24388 = (state_24387[(1)]);
if((state_val_24388 === (7))){
var inst_24383 = (state_24387[(2)]);
var state_24387__$1 = state_24387;
var statearr_24389_24407 = state_24387__$1;
(statearr_24389_24407[(2)] = inst_24383);

(statearr_24389_24407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (1))){
var state_24387__$1 = state_24387;
var statearr_24390_24408 = state_24387__$1;
(statearr_24390_24408[(2)] = null);

(statearr_24390_24408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (4))){
var inst_24369 = (state_24387[(7)]);
var inst_24369__$1 = (state_24387[(2)]);
var inst_24370 = (inst_24369__$1 == null);
var state_24387__$1 = (function (){var statearr_24391 = state_24387;
(statearr_24391[(7)] = inst_24369__$1);

return statearr_24391;
})();
if(cljs.core.truth_(inst_24370)){
var statearr_24392_24409 = state_24387__$1;
(statearr_24392_24409[(1)] = (5));

} else {
var statearr_24393_24410 = state_24387__$1;
(statearr_24393_24410[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (6))){
var inst_24369 = (state_24387[(7)]);
var inst_24374 = p.call(null,inst_24369);
var state_24387__$1 = state_24387;
if(cljs.core.truth_(inst_24374)){
var statearr_24394_24411 = state_24387__$1;
(statearr_24394_24411[(1)] = (8));

} else {
var statearr_24395_24412 = state_24387__$1;
(statearr_24395_24412[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (3))){
var inst_24385 = (state_24387[(2)]);
var state_24387__$1 = state_24387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24387__$1,inst_24385);
} else {
if((state_val_24388 === (2))){
var state_24387__$1 = state_24387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24387__$1,(4),ch);
} else {
if((state_val_24388 === (11))){
var inst_24377 = (state_24387[(2)]);
var state_24387__$1 = state_24387;
var statearr_24396_24413 = state_24387__$1;
(statearr_24396_24413[(2)] = inst_24377);

(statearr_24396_24413[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (9))){
var state_24387__$1 = state_24387;
var statearr_24397_24414 = state_24387__$1;
(statearr_24397_24414[(2)] = null);

(statearr_24397_24414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (5))){
var inst_24372 = cljs.core.async.close_BANG_.call(null,out);
var state_24387__$1 = state_24387;
var statearr_24398_24415 = state_24387__$1;
(statearr_24398_24415[(2)] = inst_24372);

(statearr_24398_24415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (10))){
var inst_24380 = (state_24387[(2)]);
var state_24387__$1 = (function (){var statearr_24399 = state_24387;
(statearr_24399[(8)] = inst_24380);

return statearr_24399;
})();
var statearr_24400_24416 = state_24387__$1;
(statearr_24400_24416[(2)] = null);

(statearr_24400_24416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24388 === (8))){
var inst_24369 = (state_24387[(7)]);
var state_24387__$1 = state_24387;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24387__$1,(11),out,inst_24369);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24406,out))
;
return ((function (switch__22772__auto__,c__22867__auto___24406,out){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24401 = [null,null,null,null,null,null,null,null,null];
(statearr_24401[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24401[(1)] = (1));

return statearr_24401;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24387){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24402){if((e24402 instanceof Object)){
var ex__22776__auto__ = e24402;
var statearr_24403_24417 = state_24387;
(statearr_24403_24417[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24387);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24418 = state_24387;
state_24387 = G__24418;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24387){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24406,out))
})();
var state__22869__auto__ = (function (){var statearr_24404 = f__22868__auto__.call(null);
(statearr_24404[(6)] = c__22867__auto___24406);

return statearr_24404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24406,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__24420 = arguments.length;
switch (G__24420) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__22867__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto__){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto__){
return (function (state_24483){
var state_val_24484 = (state_24483[(1)]);
if((state_val_24484 === (7))){
var inst_24479 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
var statearr_24485_24523 = state_24483__$1;
(statearr_24485_24523[(2)] = inst_24479);

(statearr_24485_24523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (20))){
var inst_24449 = (state_24483[(7)]);
var inst_24460 = (state_24483[(2)]);
var inst_24461 = cljs.core.next.call(null,inst_24449);
var inst_24435 = inst_24461;
var inst_24436 = null;
var inst_24437 = (0);
var inst_24438 = (0);
var state_24483__$1 = (function (){var statearr_24486 = state_24483;
(statearr_24486[(8)] = inst_24437);

(statearr_24486[(9)] = inst_24435);

(statearr_24486[(10)] = inst_24436);

(statearr_24486[(11)] = inst_24438);

(statearr_24486[(12)] = inst_24460);

return statearr_24486;
})();
var statearr_24487_24524 = state_24483__$1;
(statearr_24487_24524[(2)] = null);

(statearr_24487_24524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (1))){
var state_24483__$1 = state_24483;
var statearr_24488_24525 = state_24483__$1;
(statearr_24488_24525[(2)] = null);

(statearr_24488_24525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (4))){
var inst_24424 = (state_24483[(13)]);
var inst_24424__$1 = (state_24483[(2)]);
var inst_24425 = (inst_24424__$1 == null);
var state_24483__$1 = (function (){var statearr_24489 = state_24483;
(statearr_24489[(13)] = inst_24424__$1);

return statearr_24489;
})();
if(cljs.core.truth_(inst_24425)){
var statearr_24490_24526 = state_24483__$1;
(statearr_24490_24526[(1)] = (5));

} else {
var statearr_24491_24527 = state_24483__$1;
(statearr_24491_24527[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (15))){
var state_24483__$1 = state_24483;
var statearr_24495_24528 = state_24483__$1;
(statearr_24495_24528[(2)] = null);

(statearr_24495_24528[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (21))){
var state_24483__$1 = state_24483;
var statearr_24496_24529 = state_24483__$1;
(statearr_24496_24529[(2)] = null);

(statearr_24496_24529[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (13))){
var inst_24437 = (state_24483[(8)]);
var inst_24435 = (state_24483[(9)]);
var inst_24436 = (state_24483[(10)]);
var inst_24438 = (state_24483[(11)]);
var inst_24445 = (state_24483[(2)]);
var inst_24446 = (inst_24438 + (1));
var tmp24492 = inst_24437;
var tmp24493 = inst_24435;
var tmp24494 = inst_24436;
var inst_24435__$1 = tmp24493;
var inst_24436__$1 = tmp24494;
var inst_24437__$1 = tmp24492;
var inst_24438__$1 = inst_24446;
var state_24483__$1 = (function (){var statearr_24497 = state_24483;
(statearr_24497[(14)] = inst_24445);

(statearr_24497[(8)] = inst_24437__$1);

(statearr_24497[(9)] = inst_24435__$1);

(statearr_24497[(10)] = inst_24436__$1);

(statearr_24497[(11)] = inst_24438__$1);

return statearr_24497;
})();
var statearr_24498_24530 = state_24483__$1;
(statearr_24498_24530[(2)] = null);

(statearr_24498_24530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (22))){
var state_24483__$1 = state_24483;
var statearr_24499_24531 = state_24483__$1;
(statearr_24499_24531[(2)] = null);

(statearr_24499_24531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (6))){
var inst_24424 = (state_24483[(13)]);
var inst_24433 = f.call(null,inst_24424);
var inst_24434 = cljs.core.seq.call(null,inst_24433);
var inst_24435 = inst_24434;
var inst_24436 = null;
var inst_24437 = (0);
var inst_24438 = (0);
var state_24483__$1 = (function (){var statearr_24500 = state_24483;
(statearr_24500[(8)] = inst_24437);

(statearr_24500[(9)] = inst_24435);

(statearr_24500[(10)] = inst_24436);

(statearr_24500[(11)] = inst_24438);

return statearr_24500;
})();
var statearr_24501_24532 = state_24483__$1;
(statearr_24501_24532[(2)] = null);

(statearr_24501_24532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (17))){
var inst_24449 = (state_24483[(7)]);
var inst_24453 = cljs.core.chunk_first.call(null,inst_24449);
var inst_24454 = cljs.core.chunk_rest.call(null,inst_24449);
var inst_24455 = cljs.core.count.call(null,inst_24453);
var inst_24435 = inst_24454;
var inst_24436 = inst_24453;
var inst_24437 = inst_24455;
var inst_24438 = (0);
var state_24483__$1 = (function (){var statearr_24502 = state_24483;
(statearr_24502[(8)] = inst_24437);

(statearr_24502[(9)] = inst_24435);

(statearr_24502[(10)] = inst_24436);

(statearr_24502[(11)] = inst_24438);

return statearr_24502;
})();
var statearr_24503_24533 = state_24483__$1;
(statearr_24503_24533[(2)] = null);

(statearr_24503_24533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (3))){
var inst_24481 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24483__$1,inst_24481);
} else {
if((state_val_24484 === (12))){
var inst_24469 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
var statearr_24504_24534 = state_24483__$1;
(statearr_24504_24534[(2)] = inst_24469);

(statearr_24504_24534[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (2))){
var state_24483__$1 = state_24483;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24483__$1,(4),in$);
} else {
if((state_val_24484 === (23))){
var inst_24477 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
var statearr_24505_24535 = state_24483__$1;
(statearr_24505_24535[(2)] = inst_24477);

(statearr_24505_24535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (19))){
var inst_24464 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
var statearr_24506_24536 = state_24483__$1;
(statearr_24506_24536[(2)] = inst_24464);

(statearr_24506_24536[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (11))){
var inst_24449 = (state_24483[(7)]);
var inst_24435 = (state_24483[(9)]);
var inst_24449__$1 = cljs.core.seq.call(null,inst_24435);
var state_24483__$1 = (function (){var statearr_24507 = state_24483;
(statearr_24507[(7)] = inst_24449__$1);

return statearr_24507;
})();
if(inst_24449__$1){
var statearr_24508_24537 = state_24483__$1;
(statearr_24508_24537[(1)] = (14));

} else {
var statearr_24509_24538 = state_24483__$1;
(statearr_24509_24538[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (9))){
var inst_24471 = (state_24483[(2)]);
var inst_24472 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_24483__$1 = (function (){var statearr_24510 = state_24483;
(statearr_24510[(15)] = inst_24471);

return statearr_24510;
})();
if(cljs.core.truth_(inst_24472)){
var statearr_24511_24539 = state_24483__$1;
(statearr_24511_24539[(1)] = (21));

} else {
var statearr_24512_24540 = state_24483__$1;
(statearr_24512_24540[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (5))){
var inst_24427 = cljs.core.async.close_BANG_.call(null,out);
var state_24483__$1 = state_24483;
var statearr_24513_24541 = state_24483__$1;
(statearr_24513_24541[(2)] = inst_24427);

(statearr_24513_24541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (14))){
var inst_24449 = (state_24483[(7)]);
var inst_24451 = cljs.core.chunked_seq_QMARK_.call(null,inst_24449);
var state_24483__$1 = state_24483;
if(inst_24451){
var statearr_24514_24542 = state_24483__$1;
(statearr_24514_24542[(1)] = (17));

} else {
var statearr_24515_24543 = state_24483__$1;
(statearr_24515_24543[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (16))){
var inst_24467 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
var statearr_24516_24544 = state_24483__$1;
(statearr_24516_24544[(2)] = inst_24467);

(statearr_24516_24544[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (10))){
var inst_24436 = (state_24483[(10)]);
var inst_24438 = (state_24483[(11)]);
var inst_24443 = cljs.core._nth.call(null,inst_24436,inst_24438);
var state_24483__$1 = state_24483;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24483__$1,(13),out,inst_24443);
} else {
if((state_val_24484 === (18))){
var inst_24449 = (state_24483[(7)]);
var inst_24458 = cljs.core.first.call(null,inst_24449);
var state_24483__$1 = state_24483;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24483__$1,(20),out,inst_24458);
} else {
if((state_val_24484 === (8))){
var inst_24437 = (state_24483[(8)]);
var inst_24438 = (state_24483[(11)]);
var inst_24440 = (inst_24438 < inst_24437);
var inst_24441 = inst_24440;
var state_24483__$1 = state_24483;
if(cljs.core.truth_(inst_24441)){
var statearr_24517_24545 = state_24483__$1;
(statearr_24517_24545[(1)] = (10));

} else {
var statearr_24518_24546 = state_24483__$1;
(statearr_24518_24546[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto__))
;
return ((function (switch__22772__auto__,c__22867__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__22773__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__22773__auto____0 = (function (){
var statearr_24519 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24519[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__22773__auto__);

(statearr_24519[(1)] = (1));

return statearr_24519;
});
var cljs$core$async$mapcat_STAR__$_state_machine__22773__auto____1 = (function (state_24483){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24483);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24520){if((e24520 instanceof Object)){
var ex__22776__auto__ = e24520;
var statearr_24521_24547 = state_24483;
(statearr_24521_24547[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24483);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24520;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24548 = state_24483;
state_24483 = G__24548;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__22773__auto__ = function(state_24483){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__22773__auto____1.call(this,state_24483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__22773__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__22773__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto__))
})();
var state__22869__auto__ = (function (){var statearr_24522 = f__22868__auto__.call(null);
(statearr_24522[(6)] = c__22867__auto__);

return statearr_24522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto__))
);

return c__22867__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__24550 = arguments.length;
switch (G__24550) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__24553 = arguments.length;
switch (G__24553) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__24556 = arguments.length;
switch (G__24556) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22867__auto___24603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24603,out){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24603,out){
return (function (state_24580){
var state_val_24581 = (state_24580[(1)]);
if((state_val_24581 === (7))){
var inst_24575 = (state_24580[(2)]);
var state_24580__$1 = state_24580;
var statearr_24582_24604 = state_24580__$1;
(statearr_24582_24604[(2)] = inst_24575);

(statearr_24582_24604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24581 === (1))){
var inst_24557 = null;
var state_24580__$1 = (function (){var statearr_24583 = state_24580;
(statearr_24583[(7)] = inst_24557);

return statearr_24583;
})();
var statearr_24584_24605 = state_24580__$1;
(statearr_24584_24605[(2)] = null);

(statearr_24584_24605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24581 === (4))){
var inst_24560 = (state_24580[(8)]);
var inst_24560__$1 = (state_24580[(2)]);
var inst_24561 = (inst_24560__$1 == null);
var inst_24562 = cljs.core.not.call(null,inst_24561);
var state_24580__$1 = (function (){var statearr_24585 = state_24580;
(statearr_24585[(8)] = inst_24560__$1);

return statearr_24585;
})();
if(inst_24562){
var statearr_24586_24606 = state_24580__$1;
(statearr_24586_24606[(1)] = (5));

} else {
var statearr_24587_24607 = state_24580__$1;
(statearr_24587_24607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24581 === (6))){
var state_24580__$1 = state_24580;
var statearr_24588_24608 = state_24580__$1;
(statearr_24588_24608[(2)] = null);

(statearr_24588_24608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24581 === (3))){
var inst_24577 = (state_24580[(2)]);
var inst_24578 = cljs.core.async.close_BANG_.call(null,out);
var state_24580__$1 = (function (){var statearr_24589 = state_24580;
(statearr_24589[(9)] = inst_24577);

return statearr_24589;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24580__$1,inst_24578);
} else {
if((state_val_24581 === (2))){
var state_24580__$1 = state_24580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24580__$1,(4),ch);
} else {
if((state_val_24581 === (11))){
var inst_24560 = (state_24580[(8)]);
var inst_24569 = (state_24580[(2)]);
var inst_24557 = inst_24560;
var state_24580__$1 = (function (){var statearr_24590 = state_24580;
(statearr_24590[(7)] = inst_24557);

(statearr_24590[(10)] = inst_24569);

return statearr_24590;
})();
var statearr_24591_24609 = state_24580__$1;
(statearr_24591_24609[(2)] = null);

(statearr_24591_24609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24581 === (9))){
var inst_24560 = (state_24580[(8)]);
var state_24580__$1 = state_24580;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24580__$1,(11),out,inst_24560);
} else {
if((state_val_24581 === (5))){
var inst_24557 = (state_24580[(7)]);
var inst_24560 = (state_24580[(8)]);
var inst_24564 = cljs.core._EQ_.call(null,inst_24560,inst_24557);
var state_24580__$1 = state_24580;
if(inst_24564){
var statearr_24593_24610 = state_24580__$1;
(statearr_24593_24610[(1)] = (8));

} else {
var statearr_24594_24611 = state_24580__$1;
(statearr_24594_24611[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24581 === (10))){
var inst_24572 = (state_24580[(2)]);
var state_24580__$1 = state_24580;
var statearr_24595_24612 = state_24580__$1;
(statearr_24595_24612[(2)] = inst_24572);

(statearr_24595_24612[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24581 === (8))){
var inst_24557 = (state_24580[(7)]);
var tmp24592 = inst_24557;
var inst_24557__$1 = tmp24592;
var state_24580__$1 = (function (){var statearr_24596 = state_24580;
(statearr_24596[(7)] = inst_24557__$1);

return statearr_24596;
})();
var statearr_24597_24613 = state_24580__$1;
(statearr_24597_24613[(2)] = null);

(statearr_24597_24613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24603,out))
;
return ((function (switch__22772__auto__,c__22867__auto___24603,out){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24598 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24598[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24598[(1)] = (1));

return statearr_24598;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24580){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24599){if((e24599 instanceof Object)){
var ex__22776__auto__ = e24599;
var statearr_24600_24614 = state_24580;
(statearr_24600_24614[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24580);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24599;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24615 = state_24580;
state_24580 = G__24615;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24580){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24603,out))
})();
var state__22869__auto__ = (function (){var statearr_24601 = f__22868__auto__.call(null);
(statearr_24601[(6)] = c__22867__auto___24603);

return statearr_24601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24603,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__24617 = arguments.length;
switch (G__24617) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22867__auto___24683 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24683,out){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24683,out){
return (function (state_24655){
var state_val_24656 = (state_24655[(1)]);
if((state_val_24656 === (7))){
var inst_24651 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
var statearr_24657_24684 = state_24655__$1;
(statearr_24657_24684[(2)] = inst_24651);

(statearr_24657_24684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (1))){
var inst_24618 = (new Array(n));
var inst_24619 = inst_24618;
var inst_24620 = (0);
var state_24655__$1 = (function (){var statearr_24658 = state_24655;
(statearr_24658[(7)] = inst_24619);

(statearr_24658[(8)] = inst_24620);

return statearr_24658;
})();
var statearr_24659_24685 = state_24655__$1;
(statearr_24659_24685[(2)] = null);

(statearr_24659_24685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (4))){
var inst_24623 = (state_24655[(9)]);
var inst_24623__$1 = (state_24655[(2)]);
var inst_24624 = (inst_24623__$1 == null);
var inst_24625 = cljs.core.not.call(null,inst_24624);
var state_24655__$1 = (function (){var statearr_24660 = state_24655;
(statearr_24660[(9)] = inst_24623__$1);

return statearr_24660;
})();
if(inst_24625){
var statearr_24661_24686 = state_24655__$1;
(statearr_24661_24686[(1)] = (5));

} else {
var statearr_24662_24687 = state_24655__$1;
(statearr_24662_24687[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (15))){
var inst_24645 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
var statearr_24663_24688 = state_24655__$1;
(statearr_24663_24688[(2)] = inst_24645);

(statearr_24663_24688[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (13))){
var state_24655__$1 = state_24655;
var statearr_24664_24689 = state_24655__$1;
(statearr_24664_24689[(2)] = null);

(statearr_24664_24689[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (6))){
var inst_24620 = (state_24655[(8)]);
var inst_24641 = (inst_24620 > (0));
var state_24655__$1 = state_24655;
if(cljs.core.truth_(inst_24641)){
var statearr_24665_24690 = state_24655__$1;
(statearr_24665_24690[(1)] = (12));

} else {
var statearr_24666_24691 = state_24655__$1;
(statearr_24666_24691[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (3))){
var inst_24653 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24655__$1,inst_24653);
} else {
if((state_val_24656 === (12))){
var inst_24619 = (state_24655[(7)]);
var inst_24643 = cljs.core.vec.call(null,inst_24619);
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24655__$1,(15),out,inst_24643);
} else {
if((state_val_24656 === (2))){
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24655__$1,(4),ch);
} else {
if((state_val_24656 === (11))){
var inst_24635 = (state_24655[(2)]);
var inst_24636 = (new Array(n));
var inst_24619 = inst_24636;
var inst_24620 = (0);
var state_24655__$1 = (function (){var statearr_24667 = state_24655;
(statearr_24667[(7)] = inst_24619);

(statearr_24667[(10)] = inst_24635);

(statearr_24667[(8)] = inst_24620);

return statearr_24667;
})();
var statearr_24668_24692 = state_24655__$1;
(statearr_24668_24692[(2)] = null);

(statearr_24668_24692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (9))){
var inst_24619 = (state_24655[(7)]);
var inst_24633 = cljs.core.vec.call(null,inst_24619);
var state_24655__$1 = state_24655;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24655__$1,(11),out,inst_24633);
} else {
if((state_val_24656 === (5))){
var inst_24628 = (state_24655[(11)]);
var inst_24619 = (state_24655[(7)]);
var inst_24623 = (state_24655[(9)]);
var inst_24620 = (state_24655[(8)]);
var inst_24627 = (inst_24619[inst_24620] = inst_24623);
var inst_24628__$1 = (inst_24620 + (1));
var inst_24629 = (inst_24628__$1 < n);
var state_24655__$1 = (function (){var statearr_24669 = state_24655;
(statearr_24669[(11)] = inst_24628__$1);

(statearr_24669[(12)] = inst_24627);

return statearr_24669;
})();
if(cljs.core.truth_(inst_24629)){
var statearr_24670_24693 = state_24655__$1;
(statearr_24670_24693[(1)] = (8));

} else {
var statearr_24671_24694 = state_24655__$1;
(statearr_24671_24694[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (14))){
var inst_24648 = (state_24655[(2)]);
var inst_24649 = cljs.core.async.close_BANG_.call(null,out);
var state_24655__$1 = (function (){var statearr_24673 = state_24655;
(statearr_24673[(13)] = inst_24648);

return statearr_24673;
})();
var statearr_24674_24695 = state_24655__$1;
(statearr_24674_24695[(2)] = inst_24649);

(statearr_24674_24695[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (10))){
var inst_24639 = (state_24655[(2)]);
var state_24655__$1 = state_24655;
var statearr_24675_24696 = state_24655__$1;
(statearr_24675_24696[(2)] = inst_24639);

(statearr_24675_24696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24656 === (8))){
var inst_24628 = (state_24655[(11)]);
var inst_24619 = (state_24655[(7)]);
var tmp24672 = inst_24619;
var inst_24619__$1 = tmp24672;
var inst_24620 = inst_24628;
var state_24655__$1 = (function (){var statearr_24676 = state_24655;
(statearr_24676[(7)] = inst_24619__$1);

(statearr_24676[(8)] = inst_24620);

return statearr_24676;
})();
var statearr_24677_24697 = state_24655__$1;
(statearr_24677_24697[(2)] = null);

(statearr_24677_24697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24683,out))
;
return ((function (switch__22772__auto__,c__22867__auto___24683,out){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24678[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24678[(1)] = (1));

return statearr_24678;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24655){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24679){if((e24679 instanceof Object)){
var ex__22776__auto__ = e24679;
var statearr_24680_24698 = state_24655;
(statearr_24680_24698[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24655);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24699 = state_24655;
state_24655 = G__24699;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24655){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24683,out))
})();
var state__22869__auto__ = (function (){var statearr_24681 = f__22868__auto__.call(null);
(statearr_24681[(6)] = c__22867__auto___24683);

return statearr_24681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24683,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__24701 = arguments.length;
switch (G__24701) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__22867__auto___24771 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__22867__auto___24771,out){
return (function (){
var f__22868__auto__ = (function (){var switch__22772__auto__ = ((function (c__22867__auto___24771,out){
return (function (state_24743){
var state_val_24744 = (state_24743[(1)]);
if((state_val_24744 === (7))){
var inst_24739 = (state_24743[(2)]);
var state_24743__$1 = state_24743;
var statearr_24745_24772 = state_24743__$1;
(statearr_24745_24772[(2)] = inst_24739);

(statearr_24745_24772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (1))){
var inst_24702 = [];
var inst_24703 = inst_24702;
var inst_24704 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_24743__$1 = (function (){var statearr_24746 = state_24743;
(statearr_24746[(7)] = inst_24704);

(statearr_24746[(8)] = inst_24703);

return statearr_24746;
})();
var statearr_24747_24773 = state_24743__$1;
(statearr_24747_24773[(2)] = null);

(statearr_24747_24773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (4))){
var inst_24707 = (state_24743[(9)]);
var inst_24707__$1 = (state_24743[(2)]);
var inst_24708 = (inst_24707__$1 == null);
var inst_24709 = cljs.core.not.call(null,inst_24708);
var state_24743__$1 = (function (){var statearr_24748 = state_24743;
(statearr_24748[(9)] = inst_24707__$1);

return statearr_24748;
})();
if(inst_24709){
var statearr_24749_24774 = state_24743__$1;
(statearr_24749_24774[(1)] = (5));

} else {
var statearr_24750_24775 = state_24743__$1;
(statearr_24750_24775[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (15))){
var inst_24733 = (state_24743[(2)]);
var state_24743__$1 = state_24743;
var statearr_24751_24776 = state_24743__$1;
(statearr_24751_24776[(2)] = inst_24733);

(statearr_24751_24776[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (13))){
var state_24743__$1 = state_24743;
var statearr_24752_24777 = state_24743__$1;
(statearr_24752_24777[(2)] = null);

(statearr_24752_24777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (6))){
var inst_24703 = (state_24743[(8)]);
var inst_24728 = inst_24703.length;
var inst_24729 = (inst_24728 > (0));
var state_24743__$1 = state_24743;
if(cljs.core.truth_(inst_24729)){
var statearr_24753_24778 = state_24743__$1;
(statearr_24753_24778[(1)] = (12));

} else {
var statearr_24754_24779 = state_24743__$1;
(statearr_24754_24779[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (3))){
var inst_24741 = (state_24743[(2)]);
var state_24743__$1 = state_24743;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24743__$1,inst_24741);
} else {
if((state_val_24744 === (12))){
var inst_24703 = (state_24743[(8)]);
var inst_24731 = cljs.core.vec.call(null,inst_24703);
var state_24743__$1 = state_24743;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24743__$1,(15),out,inst_24731);
} else {
if((state_val_24744 === (2))){
var state_24743__$1 = state_24743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24743__$1,(4),ch);
} else {
if((state_val_24744 === (11))){
var inst_24711 = (state_24743[(10)]);
var inst_24707 = (state_24743[(9)]);
var inst_24721 = (state_24743[(2)]);
var inst_24722 = [];
var inst_24723 = inst_24722.push(inst_24707);
var inst_24703 = inst_24722;
var inst_24704 = inst_24711;
var state_24743__$1 = (function (){var statearr_24755 = state_24743;
(statearr_24755[(7)] = inst_24704);

(statearr_24755[(8)] = inst_24703);

(statearr_24755[(11)] = inst_24721);

(statearr_24755[(12)] = inst_24723);

return statearr_24755;
})();
var statearr_24756_24780 = state_24743__$1;
(statearr_24756_24780[(2)] = null);

(statearr_24756_24780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (9))){
var inst_24703 = (state_24743[(8)]);
var inst_24719 = cljs.core.vec.call(null,inst_24703);
var state_24743__$1 = state_24743;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24743__$1,(11),out,inst_24719);
} else {
if((state_val_24744 === (5))){
var inst_24711 = (state_24743[(10)]);
var inst_24704 = (state_24743[(7)]);
var inst_24707 = (state_24743[(9)]);
var inst_24711__$1 = f.call(null,inst_24707);
var inst_24712 = cljs.core._EQ_.call(null,inst_24711__$1,inst_24704);
var inst_24713 = cljs.core.keyword_identical_QMARK_.call(null,inst_24704,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_24714 = ((inst_24712) || (inst_24713));
var state_24743__$1 = (function (){var statearr_24757 = state_24743;
(statearr_24757[(10)] = inst_24711__$1);

return statearr_24757;
})();
if(cljs.core.truth_(inst_24714)){
var statearr_24758_24781 = state_24743__$1;
(statearr_24758_24781[(1)] = (8));

} else {
var statearr_24759_24782 = state_24743__$1;
(statearr_24759_24782[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (14))){
var inst_24736 = (state_24743[(2)]);
var inst_24737 = cljs.core.async.close_BANG_.call(null,out);
var state_24743__$1 = (function (){var statearr_24761 = state_24743;
(statearr_24761[(13)] = inst_24736);

return statearr_24761;
})();
var statearr_24762_24783 = state_24743__$1;
(statearr_24762_24783[(2)] = inst_24737);

(statearr_24762_24783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (10))){
var inst_24726 = (state_24743[(2)]);
var state_24743__$1 = state_24743;
var statearr_24763_24784 = state_24743__$1;
(statearr_24763_24784[(2)] = inst_24726);

(statearr_24763_24784[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24744 === (8))){
var inst_24711 = (state_24743[(10)]);
var inst_24703 = (state_24743[(8)]);
var inst_24707 = (state_24743[(9)]);
var inst_24716 = inst_24703.push(inst_24707);
var tmp24760 = inst_24703;
var inst_24703__$1 = tmp24760;
var inst_24704 = inst_24711;
var state_24743__$1 = (function (){var statearr_24764 = state_24743;
(statearr_24764[(14)] = inst_24716);

(statearr_24764[(7)] = inst_24704);

(statearr_24764[(8)] = inst_24703__$1);

return statearr_24764;
})();
var statearr_24765_24785 = state_24743__$1;
(statearr_24765_24785[(2)] = null);

(statearr_24765_24785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22867__auto___24771,out))
;
return ((function (switch__22772__auto__,c__22867__auto___24771,out){
return (function() {
var cljs$core$async$state_machine__22773__auto__ = null;
var cljs$core$async$state_machine__22773__auto____0 = (function (){
var statearr_24766 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24766[(0)] = cljs$core$async$state_machine__22773__auto__);

(statearr_24766[(1)] = (1));

return statearr_24766;
});
var cljs$core$async$state_machine__22773__auto____1 = (function (state_24743){
while(true){
var ret_value__22774__auto__ = (function (){try{while(true){
var result__22775__auto__ = switch__22772__auto__.call(null,state_24743);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22775__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22775__auto__;
}
break;
}
}catch (e24767){if((e24767 instanceof Object)){
var ex__22776__auto__ = e24767;
var statearr_24768_24786 = state_24743;
(statearr_24768_24786[(5)] = ex__22776__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24743);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24767;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22774__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24787 = state_24743;
state_24743 = G__24787;
continue;
} else {
return ret_value__22774__auto__;
}
break;
}
});
cljs$core$async$state_machine__22773__auto__ = function(state_24743){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22773__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22773__auto____1.call(this,state_24743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22773__auto____0;
cljs$core$async$state_machine__22773__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22773__auto____1;
return cljs$core$async$state_machine__22773__auto__;
})()
;})(switch__22772__auto__,c__22867__auto___24771,out))
})();
var state__22869__auto__ = (function (){var statearr_24769 = f__22868__auto__.call(null);
(statearr_24769[(6)] = c__22867__auto___24771);

return statearr_24769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22869__auto__);
});})(c__22867__auto___24771,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1549344822648
