/*
 * Decompiled with CFR 0.152.
 */
package clojuresque;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.util.CollectionUtils;

public class ClojureExecAction
extends JavaExecHandleBuilder
implements JavaExecAction {
    FileCollection driverClasspath;

    public ClojureExecAction(FileResolver fileResolver, FileCollection driver) {
        super(fileResolver);
        this.driverClasspath = driver;
    }

    public List<String> getAllJvmArgs() {
        List allArgs = super.getAllJvmArgs();
        String driver = CollectionUtils.join((String)File.pathSeparator, (Iterable)this.driverClasspath.getFiles());
        int pos = allArgs.indexOf("-cp") + 1;
        if (pos > 0) {
            String oldClasspath = (String)allArgs.remove(pos);
            allArgs.add(pos, oldClasspath + File.pathSeparator + driver);
        } else {
            allArgs.add("-cp");
            allArgs.add(driver);
        }
        return allArgs;
    }

    public List<String> getAllArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(this.getAllJvmArgs());
        arguments.add("clojuresque.Driver");
        arguments.add(this.getMain());
        arguments.addAll(this.getArgs());
        return arguments;
    }

    public ExecResult execute() {
        ExecHandle execHandle = this.build();
        ExecResult execResult = execHandle.start().waitForFinish();
        if (!this.isIgnoreExitValue()) {
            execResult.assertNormalExitValue();
        }
        return execResult;
    }
}

