/*
 * Decompiled with CFR 0.152.
 */
package com.hmsonline.storm.osgi.topology;

import backtype.storm.Config;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import com.hmsonline.storm.osgi.topology.ITopologyComponent;
import com.hmsonline.storm.osgi.tuple.TupleStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDefinition
implements ITopologyComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentDefinition.class);
    protected String name;
    private Integer parallelismHint;
    private String[] schema;
    private TupleStream[] streams;
    protected Map<String, Object> configuration = new HashMap<String, Object>();

    @PostConstruct
    public void initDefinition() {
        if (this.streams == null && this.schema != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Component, " + this.name + ", has a default tuple schema, creating a default stream for it.");
            }
            TupleStream defaultStream = new TupleStream();
            defaultStream.setId("default");
            defaultStream.setSchema(this.schema);
            this.streams = new TupleStream[]{defaultStream};
        }
    }

    @PreDestroy
    public void destroyDefinition() {
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (TupleStream stream : this.streams) {
            declarer.declareStream(stream.getId(), new Fields(stream.getSchema()));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getParallelismHint() {
        return this.parallelismHint;
    }

    @Override
    public void setParallelismHint(Integer parallelismHint) {
        this.parallelismHint = parallelismHint;
    }

    public Map<String, Object> getComponentConfiguration() {
        return this.configuration;
    }

    public String[] getSchema() {
        return this.schema;
    }

    public void setSchema(String[] schema) {
        this.schema = schema;
    }

    public TupleStream[] getStreams() {
        return this.streams;
    }

    public void setDebug(boolean debug) {
        this.configuration.put(Config.TOPOLOGY_DEBUG, debug);
    }

    public void setMaxTaskParallelism(int val) {
        this.configuration.put(Config.TOPOLOGY_MAX_TASK_PARALLELISM, val);
    }

    public void setMaxSpoutPending(int val) {
        this.configuration.put(Config.TOPOLOGY_MAX_SPOUT_PENDING, val);
    }

    public void setNumTasks(int val) {
        this.configuration.put(Config.TOPOLOGY_TASKS, val);
    }
}

