/*
 * Decompiled with CFR 0.152.
 */
package com.hmsonline.storm.osgi.spout;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichSpout;
import backtype.storm.tuple.Values;
import com.hmsonline.storm.osgi.spout.ITupleSource;
import com.hmsonline.storm.osgi.topology.ComponentDefinition;
import com.hmsonline.storm.osgi.tuple.TupleStream;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpoutDefinition
extends ComponentDefinition
implements IRichSpout {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpoutDefinition.class);
    private ITupleSource source;
    private SpoutOutputCollector collector;
    private Queue<Values> tupleQueue;

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        if (this.source == null) {
            throw new IllegalStateException("A tuple source implementation must be configured.");
        }
        this.collector = collector;
        this.tupleQueue = new ConcurrentLinkedQueue<Values>();
        this.source.init(this.tupleQueue);
    }

    public void close() {
        this.tupleQueue.clear();
        this.tupleQueue = null;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void nextTuple() {
        Values output;
        while ((output = this.tupleQueue.poll()) != null) {
            for (TupleStream stream : super.getStreams()) {
                this.collector.emit(stream.getId(), (List)output);
            }
        }
    }

    public void ack(Object msgId) {
    }

    public void fail(Object msgId) {
    }

    public ITupleSource getSource() {
        return this.source;
    }

    public void setSource(ITupleSource source) {
        this.source = source;
    }
}

