/*
 * Decompiled with CFR 0.152.
 */
package com.hmsonline.storm.osgi.spout;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import com.hmsonline.storm.osgi.spout.SpoutDefinition;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingSpoutDefinition
extends SpoutDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingSpoutDefinition.class);
    private ScheduledExecutorService executorService;
    private int interval = 5;
    private TimeUnit unit = TimeUnit.SECONDS;

    @Override
    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        super.open(conf, context, collector);
    }

    @Override
    public void activate() {
        super.activate();
        this.executorService = Executors.newScheduledThreadPool(1);
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    PollingSpoutDefinition.this.getSource().execute();
                }
                catch (Exception ex) {
                    LOGGER.warn("An error occurred while polling the tuple source.", (Throwable)ex);
                }
            }
        }, this.interval, this.interval, this.unit);
    }

    @Override
    public void deactivate() {
        this.executorService.shutdown();
        super.deactivate();
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
        super.close();
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }
}

