/*
 * Decompiled with CFR 0.152.
 */
package com.hmsonline.storm.osgi.bolt;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichBolt;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import com.hmsonline.storm.osgi.bolt.BoltExecutorException;
import com.hmsonline.storm.osgi.bolt.IBoltExecutor;
import com.hmsonline.storm.osgi.topology.ComponentDefinition;
import com.hmsonline.storm.osgi.topology.Subscription;
import com.hmsonline.storm.osgi.tuple.TupleStream;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltDefinition
extends ComponentDefinition
implements IRichBolt {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltDefinition.class);
    private Subscription subscription;
    private IBoltExecutor executor;
    private OutputCollector collector;
    protected TopologyContext context;
    private Queue<Values> tupleQueue;

    @PostConstruct
    public void initBolt() {
        if (this.executor == null) {
            throw new IllegalStateException("This BoltDefinition requires a BoltExecutor to be specified.");
        }
    }

    public void prepare(Map configuration, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        this.context = context;
        if (this.configuration != null) {
            this.configuration.putAll(configuration);
        } else {
            this.configuration = configuration;
        }
        this.tupleQueue = new ConcurrentLinkedQueue<Values>();
        this.executor.init(this.tupleQueue);
    }

    public void execute(Tuple tuple) {
        Values output;
        try {
            this.executor.execute(tuple);
        }
        catch (BoltExecutorException ex) {
            LOGGER.warn("Error acknowledging the processing of the received tuple.", (Throwable)ex);
            return;
        }
        try {
            this.collector.ack(tuple);
        }
        catch (Exception ex) {
            LOGGER.warn("Error acknowledging the processing of the received tuple, processing will continue.", (Throwable)ex);
        }
        if (this.getStreams() == null) {
            LOGGER.warn("An output stream/schema was defined for this bolt but it's executor returned null, no tuple will be emitted!");
            return;
        }
        while ((output = this.tupleQueue.poll()) != null) {
            for (TupleStream stream : super.getStreams()) {
                this.collector.emit(stream.getId(), (List)output);
            }
        }
    }

    @PreDestroy
    public void destroyBolt() {
        LOGGER.info("Executing destroy bolt!!!!!!!!!!!!!!", (Throwable)new Exception());
        this.tupleQueue.clear();
        this.tupleQueue = null;
    }

    public void cleanup() {
    }

    public IBoltExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(IBoltExecutor executor) {
        this.executor = executor;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }
}

