/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public interface Transfer {
    public int transferTo(WritableByteChannel var1) throws IOException;

    public int remaining();

    public static class FileChannelTransfer
    implements Transfer {
        private FileChannel ch;

        public FileChannelTransfer(FileChannel ch_) {
            this.ch = ch_;
        }

        public final int transferTo(WritableByteChannel s) throws IOException {
            return (int)this.ch.transferTo(0L, 0L, s);
        }

        public final int remaining() {
            return 0;
        }
    }

    public static class ByteBufferTransfer
    implements Transfer {
        private ByteBuffer buf;

        public ByteBufferTransfer(ByteBuffer buf_) {
            this.buf = buf_;
        }

        public final int transferTo(WritableByteChannel s) throws IOException {
            return s.write(this.buf);
        }

        public final int remaining() {
            return this.buf.remaining();
        }
    }
}

