/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import zmq.Address;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Options;
import zmq.Own;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.StreamEngine;
import zmq.TcpAddress;
import zmq.Utils;
import zmq.ZError;

public class TcpListener
extends Own
implements IPollEvents {
    private final TcpAddress address;
    private ServerSocketChannel handle;
    private SocketBase socket;
    private String endpoint;
    private final IOObject io_object;

    public TcpListener(IOThread io_thread_, SocketBase socket_, Options options_) {
        super(io_thread_, options_);
        this.io_object = new IOObject(io_thread_);
        this.address = new TcpAddress();
        this.handle = null;
        this.socket = socket_;
    }

    public void destroy() {
        assert (this.handle == null);
    }

    protected void process_plug() {
        this.io_object.set_handler(this);
        this.io_object.add_fd(this.handle);
        this.io_object.set_pollaccept(this.handle);
    }

    protected void process_term(int linger_) {
        this.io_object.set_handler(this);
        this.io_object.rm_fd(this.handle);
        this.close();
        super.process_term(linger_);
    }

    public void accept_event() {
        SocketChannel fd = null;
        try {
            fd = this.accept();
            Utils.tune_tcp_socket(fd);
            Utils.tune_tcp_keepalives(fd, this.options.tcp_keepalive, this.options.tcp_keepalive_cnt, this.options.tcp_keepalive_idle, this.options.tcp_keepalive_intvl);
        }
        catch (IOException e) {
            ZError.exc(e);
            this.socket.event_accept_failed(this.endpoint, ZError.errno());
            return;
        }
        StreamEngine engine = null;
        try {
            engine = new StreamEngine(fd, this.options, this.endpoint);
        }
        catch (ZError.InstantiationException e) {
            ZError.errno(22);
            this.socket.event_accept_failed(this.endpoint, ZError.errno());
            return;
        }
        IOThread io_thread = this.choose_io_thread(this.options.affinity);
        SessionBase session = SessionBase.create(io_thread, false, this.socket, this.options, new Address(fd.socket().getRemoteSocketAddress()));
        session.inc_seqnum();
        this.launch_child(session);
        this.send_attach(session, engine, false);
        this.socket.event_accepted(this.endpoint, fd);
    }

    private void close() {
        if (this.handle == null) {
            return;
        }
        try {
            this.handle.close();
            this.socket.event_closed(this.endpoint, this.handle);
        }
        catch (IOException e) {
            ZError.exc(e);
            this.socket.event_close_failed(this.endpoint, ZError.errno());
        }
        this.handle = null;
    }

    public String get_address() {
        return this.address.toString();
    }

    public boolean set_address(String addr_) {
        this.address.resolve(addr_, this.options.ipv4only > 0);
        this.endpoint = this.address.toString();
        try {
            this.handle = ServerSocketChannel.open();
            this.handle.configureBlocking(false);
            this.handle.socket().setReuseAddress(true);
            this.handle.socket().bind(this.address.address(), this.options.backlog);
        }
        catch (SecurityException e) {
            ZError.errno(13);
            this.close();
            return false;
        }
        catch (IllegalArgumentException e) {
            ZError.errno(45);
            this.close();
            return false;
        }
        catch (IOException e) {
            ZError.exc(e);
            this.close();
            return false;
        }
        this.socket.event_listening(this.endpoint, this.handle);
        return true;
    }

    private SocketChannel accept() {
        Socket sock = null;
        try {
            sock = this.handle.socket().accept();
        }
        catch (IOException e) {
            return null;
        }
        if (!this.options.tcp_accept_filters.isEmpty()) {
            boolean matched = false;
            for (TcpAddress.TcpAddressMask am : this.options.tcp_accept_filters) {
                if (!am.match_address(this.address.address())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return sock.getChannel();
    }

    public void in_event() {
        throw new UnsupportedOperationException();
    }

    public void out_event() {
        throw new UnsupportedOperationException();
    }

    public void connect_event() {
        throw new UnsupportedOperationException();
    }

    public void timer_event(int id_) {
        throw new UnsupportedOperationException();
    }
}

