/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicInteger;
import zmq.Utils;
import zmq.ZError;

public class Signaler {
    private Pipe.SinkChannel w;
    private Pipe.SourceChannel r;
    private Selector selector;
    private ByteBuffer rdummy;
    private final AtomicInteger wcursor = new AtomicInteger(0);
    private int rcursor = 0;

    public Signaler() {
        this.make_fdpair();
        try {
            Utils.unblock_socket(this.w);
            Utils.unblock_socket(this.r);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        try {
            this.selector = Selector.open();
            this.r.register(this.selector, 1);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        this.rdummy = ByteBuffer.allocate(1);
    }

    public void close() {
        try {
            this.r.close();
            this.w.close();
            this.selector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void make_fdpair() {
        Pipe pipe;
        try {
            pipe = Pipe.open();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        this.r = pipe.source();
        this.w = pipe.sink();
    }

    public SelectableChannel get_fd() {
        return this.r;
    }

    public void send() {
        int nbytes = 0;
        ByteBuffer dummy = ByteBuffer.allocate(1);
        dummy.limit(1);
        do {
            try {
                nbytes = this.w.write(dummy);
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
        } while (nbytes == 0);
        this.wcursor.incrementAndGet();
        assert (nbytes == 1);
    }

    public boolean wait_event(long timeout_) {
        int rc = 0;
        try {
            if (timeout_ == 0L) {
                return this.rcursor < this.wcursor.get();
            }
            rc = timeout_ < 0L ? this.selector.select(0L) : this.selector.select(timeout_);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        if (rc == 0) {
            return false;
        }
        this.selector.selectedKeys().clear();
        return true;
    }

    public void recv() {
        int nbytes = 0;
        while (nbytes == 0) {
            try {
                nbytes = this.r.read(this.rdummy);
                this.rdummy.rewind();
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
        }
        ++this.rcursor;
    }
}

