/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.Dealer;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.ZError;

public class Req
extends Dealer {
    private boolean receiving_reply = false;
    private boolean message_begins = true;

    public Req(Ctx parent_, int tid_, int sid_) {
        super(parent_, tid_, sid_);
        this.options.type = 3;
    }

    public boolean xsend(Msg msg_, int flags_) {
        boolean rc;
        if (this.receiving_reply) {
            throw new IllegalStateException("Cannot send another request");
        }
        if (this.message_begins) {
            Msg bottom = new Msg();
            bottom.set_flags(1);
            rc = super.xsend(bottom, 0);
            if (!rc) {
                return false;
            }
            this.message_begins = false;
        }
        boolean more = msg_.has_more();
        rc = super.xsend(msg_, flags_);
        if (!rc) {
            return rc;
        }
        if (!more) {
            this.receiving_reply = true;
            this.message_begins = true;
        }
        return true;
    }

    protected Msg xrecv(int flags_) {
        Msg msg_ = null;
        if (!this.receiving_reply) {
            ZError.errno(156384763);
            throw new IllegalStateException("Cannot wait before send");
        }
        if (this.message_begins) {
            msg_ = super.xrecv(flags_);
            if (msg_ == null) {
                return null;
            }
            if (!msg_.has_more() || msg_.size() != 0) {
                do {
                    msg_ = super.xrecv(flags_);
                    assert (msg_ != null);
                } while (msg_.has_more());
                ZError.errno(35);
                return null;
            }
            this.message_begins = false;
        }
        if ((msg_ = super.xrecv(flags_)) == null) {
            return null;
        }
        if (!msg_.has_more()) {
            this.receiving_reply = false;
            this.message_begins = true;
        }
        return msg_;
    }

    public boolean xhas_in() {
        if (!this.receiving_reply) {
            return false;
        }
        return super.xhas_in();
    }

    public boolean xhas_out() {
        if (this.receiving_reply) {
            return false;
        }
        return super.xhas_out();
    }

    public static class ReqSession
    extends Dealer.DealerSession {
        State state = State.identity;

        public ReqSession(IOThread io_thread_, boolean connect_, SocketBase socket_, Options options_, Address addr_) {
            super(io_thread_, connect_, socket_, options_, addr_);
        }

        public boolean push_msg(Msg msg_) {
            switch (this.state) {
                case bottom: {
                    if (msg_.flags() != 1 || msg_.size() != 0) break;
                    this.state = State.body;
                    return super.push_msg(msg_);
                }
                case body: {
                    if (msg_.flags() == 1) {
                        return super.push_msg(msg_);
                    }
                    if (msg_.flags() != 0) break;
                    this.state = State.bottom;
                    return super.push_msg(msg_);
                }
                case identity: {
                    if (msg_.flags() != 0) break;
                    this.state = State.bottom;
                    return super.push_msg(msg_);
                }
            }
            throw new IllegalStateException(this.state.toString());
        }

        public void reset() {
            super.reset();
            this.state = State.identity;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            identity,
            bottom,
            body;

        }
    }
}

