/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import zmq.DecoderBase;
import zmq.EncoderBase;
import zmq.TcpAddress;
import zmq.ZError;

public class Options {
    int sndhwm = 1000;
    int rcvhwm = 1000;
    long affinity = 0L;
    byte identity_size = 0;
    byte[] identity = null;
    String last_endpoint;
    int rate = 100;
    int recovery_ivl = 10000;
    int multicast_hops = 1;
    int sndbuf = 0;
    int rcvbuf = 0;
    int type = -1;
    int linger = -1;
    int reconnect_ivl = 100;
    int reconnect_ivl_max = 0;
    int backlog = 100;
    long maxmsgsize = -1L;
    int rcvtimeo = -1;
    int sndtimeo = -1;
    int ipv4only = 1;
    int delay_attach_on_connect = 0;
    boolean delay_on_close = true;
    boolean delay_on_disconnect = true;
    boolean filter = false;
    boolean recv_identity = false;
    int tcp_keepalive = -1;
    int tcp_keepalive_cnt = -1;
    int tcp_keepalive_idle = -1;
    int tcp_keepalive_intvl = -1;
    final List<TcpAddress.TcpAddressMask> tcp_accept_filters = new ArrayList<TcpAddress.TcpAddressMask>();
    int socket_id = 0;
    Class<? extends DecoderBase> decoder = null;
    Class<? extends EncoderBase> encoder = null;

    public boolean setsockopt(int option_, Object optval_) {
        switch (option_) {
            case 23: {
                this.sndhwm = (Integer)optval_;
                return true;
            }
            case 24: {
                this.rcvhwm = (Integer)optval_;
                return true;
            }
            case 4: {
                this.affinity = (Long)optval_;
                return true;
            }
            case 5: {
                byte[] val;
                if (optval_ instanceof String) {
                    val = ((String)optval_).getBytes();
                } else if (optval_ instanceof byte[]) {
                    val = (byte[])optval_;
                } else {
                    ZError.errno(22);
                    return false;
                }
                if (val == null || val.length > 255) {
                    ZError.errno(22);
                    return false;
                }
                this.identity = Arrays.copyOf(val, val.length);
                this.identity_size = (byte)this.identity.length;
                return true;
            }
            case 8: {
                this.rate = (Integer)optval_;
                return true;
            }
            case 9: {
                this.recovery_ivl = (Integer)optval_;
                return true;
            }
            case 11: {
                this.sndbuf = (Integer)optval_;
                return true;
            }
            case 12: {
                this.rcvbuf = (Integer)optval_;
                return true;
            }
            case 17: {
                this.linger = (Integer)optval_;
                return true;
            }
            case 18: {
                this.reconnect_ivl = (Integer)optval_;
                if (this.reconnect_ivl < -1) {
                    ZError.errno(22);
                    return false;
                }
                return true;
            }
            case 21: {
                this.reconnect_ivl_max = (Integer)optval_;
                if (this.reconnect_ivl_max < 0) {
                    ZError.errno(22);
                    return false;
                }
                return true;
            }
            case 19: {
                this.backlog = (Integer)optval_;
                return true;
            }
            case 22: {
                this.maxmsgsize = (Long)optval_;
                return true;
            }
            case 25: {
                this.multicast_hops = (Integer)optval_;
                return true;
            }
            case 27: {
                this.rcvtimeo = (Integer)optval_;
                return true;
            }
            case 28: {
                this.sndtimeo = (Integer)optval_;
                return true;
            }
            case 31: {
                this.ipv4only = (Integer)optval_;
                if (this.ipv4only != 0 && this.ipv4only != 1) {
                    ZError.errno(22);
                    return false;
                }
                return true;
            }
            case 34: {
                this.tcp_keepalive = (Integer)optval_;
                if (this.tcp_keepalive != -1 && this.tcp_keepalive != 0 && this.tcp_keepalive != 1) {
                    ZError.errno(22);
                    return false;
                }
                return true;
            }
            case 39: {
                this.delay_attach_on_connect = (Integer)optval_;
                if (this.delay_attach_on_connect != 0 && this.delay_attach_on_connect != 1) {
                    ZError.errno(22);
                    return false;
                }
                return true;
            }
            case 35: 
            case 36: 
            case 37: {
                return true;
            }
            case 38: {
                String filter_str = (String)optval_;
                if (filter_str == null) {
                    this.tcp_accept_filters.clear();
                } else {
                    if (filter_str.length() == 0 || filter_str.length() > 255) {
                        ZError.errno(22);
                        return false;
                    }
                    TcpAddress.TcpAddressMask filter = new TcpAddress.TcpAddressMask();
                    filter.resolve(filter_str, this.ipv4only == 1);
                    this.tcp_accept_filters.add(filter);
                }
                return true;
            }
            case 1001: {
                if (optval_ instanceof String) {
                    try {
                        this.encoder = Class.forName((String)optval_).asSubclass(EncoderBase.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else if (optval_ instanceof Class) {
                    this.encoder = (Class)optval_;
                } else {
                    throw new IllegalArgumentException("encoder " + optval_);
                }
                return true;
            }
            case 1002: {
                if (optval_ instanceof String) {
                    try {
                        this.decoder = Class.forName((String)optval_).asSubclass(DecoderBase.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else if (optval_ instanceof Class) {
                    this.decoder = (Class)optval_;
                } else {
                    throw new IllegalArgumentException("decoder " + optval_);
                }
                return true;
            }
        }
        ZError.errno(22);
        return false;
    }

    public Object getsockopt(int option_) {
        switch (option_) {
            case 23: {
                return this.sndhwm;
            }
            case 24: {
                return this.rcvhwm;
            }
            case 4: {
                return this.affinity;
            }
            case 5: {
                return this.identity;
            }
            case 8: {
                return this.rate;
            }
            case 9: {
                return this.recovery_ivl;
            }
            case 11: {
                return this.sndbuf;
            }
            case 12: {
                return this.rcvbuf;
            }
            case 16: {
                return this.type;
            }
            case 17: {
                return this.linger;
            }
            case 18: {
                return this.reconnect_ivl;
            }
            case 21: {
                return this.reconnect_ivl_max;
            }
            case 19: {
                return this.backlog;
            }
            case 22: {
                return this.maxmsgsize;
            }
            case 25: {
                return this.multicast_hops;
            }
            case 27: {
                return this.rcvtimeo;
            }
            case 28: {
                return this.sndtimeo;
            }
            case 31: {
                return this.ipv4only;
            }
            case 34: {
                return this.tcp_keepalive;
            }
            case 39: {
                return this.delay_attach_on_connect;
            }
            case 35: 
            case 36: 
            case 37: {
                return 0;
            }
            case 32: {
                return this.last_endpoint;
            }
        }
        throw new IllegalArgumentException("option=" + option_);
    }
}

