/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.SelectableChannel;
import zmq.Command;
import zmq.Ctx;
import zmq.IPollEvents;
import zmq.Mailbox;
import zmq.Poller;
import zmq.ZObject;

public class IOThread
extends ZObject
implements IPollEvents {
    private final Mailbox mailbox;
    private final SelectableChannel mailbox_handle;
    private final Poller poller;
    final String name;

    public IOThread(Ctx ctx_, int tid_) {
        super(ctx_, tid_);
        this.name = "iothread-" + tid_;
        this.poller = new Poller(this.name);
        this.mailbox = new Mailbox(this.name);
        this.mailbox_handle = this.mailbox.get_fd();
        this.poller.add_fd(this.mailbox_handle, this);
        this.poller.set_pollin(this.mailbox_handle);
    }

    public void start() {
        this.poller.start();
    }

    public void destroy() {
        this.poller.destroy();
        this.mailbox.close();
    }

    public void stop() {
        this.send_stop();
    }

    public Mailbox get_mailbox() {
        return this.mailbox;
    }

    public int get_load() {
        return this.poller.get_load();
    }

    public void in_event() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.destination().process_command(cmd);
        }
    }

    public void out_event() {
        throw new UnsupportedOperationException();
    }

    public void connect_event() {
        throw new UnsupportedOperationException();
    }

    public void accept_event() {
        throw new UnsupportedOperationException();
    }

    public void timer_event(int id_) {
        throw new UnsupportedOperationException();
    }

    public Poller get_poller() {
        assert (this.poller != null);
        return this.poller;
    }

    protected void process_stop() {
        this.poller.rm_fd(this.mailbox_handle);
        this.poller.stop();
    }
}

