/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import org.jeromq.ZMQException;
import zmq.Ctx;
import zmq.DecoderBase;
import zmq.EncoderBase;
import zmq.SocketBase;
import zmq.ZError;

public class ZMQ {
    public static final int SNDMORE = 2;
    public static final int DONTWAIT = 1;
    public static final int NOBLOCK = 1;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int DEALER = 5;
    public static final int XREQ = 5;
    public static final int ROUTER = 6;
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int XPUB = 9;
    public static final int XSUB = 10;
    public static final int STREAMER = 1;
    public static final int FORWARDER = 2;
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;
    public static final int POLLIN = 1;
    public static final int POLLOUT = 2;
    public static final int POLLERR = 4;

    public static Context context(int ioThreads) {
        return new Context(ioThreads);
    }

    public static Context context() {
        return new Context(1);
    }

    public static boolean device(int type_, Socket sa, Socket sb) {
        return zmq.ZMQ.zmq_proxy(sa.base, sb.base, null);
    }

    public static int poll(PollItem[] items, long timeout) {
        zmq.PollItem[] items_ = new zmq.PollItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            items_[i] = items[i].base;
        }
        return zmq.ZMQ.zmq_poll(items_, timeout);
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 2;
    }

    public static int getPatchVersion() {
        return 2;
    }

    public static int getFullVersion() {
        return zmq.ZMQ.ZMQ_MAKE_VERSION(3, 2, 2);
    }

    public static int makeVersion(int major, int minor, int patch) {
        return zmq.ZMQ.ZMQ_MAKE_VERSION(major, minor, patch);
    }

    public static String getVersionString() {
        return "3.2.2";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        ENOTSUP(45L),
        EPROTONOSUPPORT(43L),
        ENOBUFS(55L),
        ENETDOWN(50L),
        EADDRINUSE(48L),
        EADDRNOTAVAIL(49L),
        ECONNREFUSED(61L),
        EINPROGRESS(36L),
        EMTHREAD(156384766L),
        EFSM(156384763L),
        ENOCOMPATPROTO(156384764L),
        ETERM(156384765L);

        private final long code;

        private Error(long code) {
            this.code = code;
        }

        public long getCode() {
            return this.code;
        }

        public static Error findByCode(int code) {
            for (Error e : (Error[])Error.class.getEnumConstants()) {
                if (e.getCode() != (long)code) continue;
                return e;
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code:" + code);
        }
    }

    public static class PollItem {
        private final zmq.PollItem base;

        public PollItem(Socket s, int ops) {
            this.base = new zmq.PollItem(s.base, ops);
        }

        public PollItem(SelectableChannel s, int ops) {
            this.base = new zmq.PollItem(s, ops);
        }

        public final zmq.PollItem base() {
            return this.base;
        }

        public final SelectableChannel getChannel() {
            return this.base.getChannel();
        }

        public final SocketBase getSocket() {
            return this.base.getSocket();
        }

        public final boolean isReadable() {
            return this.base.isReadable();
        }

        public final boolean isWritable() {
            return this.base.isWriteable();
        }

        public final int interestOps(int ops) {
            return this.base.interestOps(ops);
        }
    }

    public static class Poller {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;
        private static final ThreadLocal<ReuseableSelector> holder = new ThreadLocal();
        private Selector selector;
        private zmq.PollItem[] items;
        private long timeout;
        private int next;

        protected Poller(Context context, int size) {
            this.items = new zmq.PollItem[size];
            this.timeout = -1L;
            this.next = 0;
            this.open();
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open() {
            if (holder.get() == null) {
                ThreadLocal<ReuseableSelector> threadLocal = holder;
                synchronized (threadLocal) {
                    try {
                        if (this.selector == null) {
                            ReuseableSelector s = new ReuseableSelector();
                            this.selector = s.open();
                            holder.set(s);
                        }
                    }
                    catch (IOException e) {
                        throw new ZError.IOException(e);
                    }
                }
            }
            this.selector = holder.get().get();
        }

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(Socket socket, int events) {
            return this.insert(new zmq.PollItem(socket.base, events));
        }

        public int register(SelectableChannel channel, int events) {
            return this.insert(new zmq.PollItem(channel, events));
        }

        private int insert(zmq.PollItem item) {
            int pos;
            if ((pos = this.next++) == this.items.length) {
                zmq.PollItem[] nitems = new zmq.PollItem[this.items.length + 16];
                System.arraycopy(this.items, 0, nitems, 0, this.items.length);
                this.items = nitems;
            }
            this.items[pos] = item;
            return pos;
        }

        public void unregister(Socket socket) {
            for (int pos = 0; pos < this.items.length; ++pos) {
                zmq.PollItem item = this.items[pos];
                if (item.socket() != socket.base) continue;
                this.remove(pos);
                break;
            }
        }

        public void unregister(SelectableChannel channel) {
            for (int pos = 0; pos < this.items.length; ++pos) {
                zmq.PollItem item = this.items[pos];
                if (item.getChannel() != channel) continue;
                this.remove(pos);
                break;
            }
        }

        private void remove(int pos) {
            --this.next;
            if (pos != this.next) {
                this.items[pos] = this.items[this.next];
            }
            this.items[this.next] = null;
        }

        public Socket getSocket(int index) {
            if (index < 0 || index >= this.next) {
                return null;
            }
            return new Socket(this.items[index].socket());
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            if (timeout < -1L) {
                return;
            }
            this.timeout = timeout;
        }

        public int getSize() {
            return this.items.length;
        }

        public int getNext() {
            return this.next;
        }

        public int poll() {
            long tout = -1L;
            if (this.timeout > -1L) {
                tout = this.timeout;
            }
            return this.poll(tout);
        }

        public int poll(long tout) {
            return zmq.ZMQ.zmq_poll(this.selector, this.items, tout);
        }

        public boolean pollin(int index) {
            if (index < 0 || index >= this.next) {
                return false;
            }
            return this.items[index].isReadable();
        }

        public boolean pollout(int index) {
            if (index < 0 || index >= this.next) {
                return false;
            }
            return this.items[index].isWriteable();
        }

        public boolean pollerr(int index) {
            if (index < 0 || index >= this.next) {
                return false;
            }
            return this.items[index].isError();
        }
    }

    protected static class ReuseableSelector {
        private Selector selector = null;

        protected ReuseableSelector() {
        }

        public Selector open() throws IOException {
            this.selector = Selector.open();
            return this.selector;
        }

        public Selector get() {
            assert (this.selector != null);
            assert (this.selector.isOpen());
            return this.selector;
        }

        public void finalize() {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class Msg {
        public static final int MORE = 1;
        private final zmq.Msg base;

        public Msg() {
            this.base = new zmq.Msg();
        }

        public Msg(zmq.Msg msg) {
            this.base = msg;
        }

        public Msg(int size) {
            this.base = new zmq.Msg(size);
        }

        public Msg(String data) {
            this.base = new zmq.Msg(data);
        }

        public Msg(ByteBuffer data) {
            this.base = new zmq.Msg(data);
        }

        public int headerSize() {
            return this.base.header_size();
        }

        public int size() {
            return this.base.size();
        }

        public ByteBuffer headerBuf() {
            return this.base.header_buf();
        }

        public byte[] header() {
            return this.base.header();
        }

        public ByteBuffer buf() {
            return this.base.buf();
        }

        public byte[] data() {
            return this.base.data();
        }

        public void put(String data, int idx) {
            this.base.put(data, idx);
        }

        public void put(byte[] data, int idx) {
            this.base.put(data, idx);
        }

        public void put(Msg data, int idx) {
            this.base.put(data.base, idx);
        }

        public void setFlags(int flags) {
            this.base.set_flags(flags);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Socket {
        private static final int DYNFROM = 49152;
        private static final int DYNTO = 65535;
        private final Ctx ctx;
        private final SocketBase base;

        protected Socket(Context context_, int type) {
            this.ctx = context_.ctx;
            this.base = this.ctx.create_socket(type);
            Socket.mayRaise();
        }

        protected Socket(SocketBase base_) {
            this.ctx = null;
            this.base = base_;
        }

        public SocketBase base() {
            return this.base;
        }

        private static final void mayRaise() {
            if (!ZError.is(0) && !ZError.is(35)) {
                if (ZError.is(156384765)) {
                    throw new ZMQException.CtxTerminated();
                }
                throw new ZMQException(ZError.errno());
            }
        }

        public final void close() {
            this.base.close();
        }

        public final int getType() {
            return this.base.getsockopt(16);
        }

        public final long getLinger() {
            return this.base.getsockopt(17);
        }

        public final void setLinger(long value) {
            this.base.setsockopt(17, (int)value);
        }

        public final long getReconnectIVL() {
            return this.base.getsockopt(21);
        }

        public final void setReconnectIVL(long value) {
            this.base.setsockopt(21, (int)value);
            Socket.mayRaise();
        }

        public final long getBacklog() {
            return this.base.getsockopt(19);
        }

        public final void setBacklog(long value) {
            this.base.setsockopt(19, (int)value);
            Socket.mayRaise();
        }

        public final long getReconnectIVLMax() {
            return this.base.getsockopt(21);
        }

        public final void setReconnectIVLMax(long value) {
            this.base.setsockopt(21, (int)value);
            Socket.mayRaise();
        }

        public final long getMaxMsgSize() {
            return (Long)this.base.getsockoptx(22);
        }

        public final void setMaxMsgSize(long value) {
            this.base.setsockopt(22, value);
            Socket.mayRaise();
        }

        public final long getSndHWM() {
            return this.base.getsockopt(23);
        }

        public final void setSndHWM(long value) {
            this.base.setsockopt(23, (int)value);
            Socket.mayRaise();
        }

        public final long getRcvHWM() {
            return this.base.getsockopt(24);
        }

        public final void setRcvHWM(long value) {
            this.base.setsockopt(24, (int)value);
            Socket.mayRaise();
        }

        @Deprecated
        public final long getHWM() {
            return -1L;
        }

        public final void setHWM(long hwm) {
            this.setSndHWM(hwm);
            this.setRcvHWM(hwm);
        }

        @Deprecated
        public final long getSwap() {
            return -1L;
        }

        @Deprecated
        public final void setSwap(long value) {
        }

        public final long getAffinity() {
            return (Long)this.base.getsockoptx(4);
        }

        public final void setAffinity(long value) {
            this.base.setsockopt(4, value);
            Socket.mayRaise();
        }

        public final byte[] getIdentity() {
            return (byte[])this.base.getsockoptx(5);
        }

        public final void setIdentity(byte[] identity) {
            this.base.setsockopt(5, identity);
            Socket.mayRaise();
        }

        public final void setIdentity(String identity) {
            this.setIdentity(identity.getBytes());
        }

        public final long getRate() {
            return this.base.getsockopt(8);
        }

        public final void setRate(long value) {
            this.base.setsockopt(8, (int)value);
            Socket.mayRaise();
        }

        public final long getRecoveryInterval() {
            return this.base.getsockopt(9);
        }

        public final void setRecoveryInterval(long value) {
            this.base.setsockopt(9, (int)value);
            Socket.mayRaise();
        }

        @Deprecated
        public final boolean hasMulticastLoop() {
            return false;
        }

        @Deprecated
        public final void setMulticastLoop(boolean mcast_loop) {
        }

        public final long getMulticastHops() {
            return this.base.getsockopt(25);
        }

        public final void setMulticastHops(long value) {
            this.base.setsockopt(25, (int)value);
            Socket.mayRaise();
        }

        public final int getReceiveTimeOut() {
            return this.base.getsockopt(27);
        }

        public final void setReceiveTimeOut(int value) {
            this.base.setsockopt(27, value);
            Socket.mayRaise();
        }

        public final int getSendTimeOut() {
            return this.base.getsockopt(28);
        }

        public final void setSendTimeOut(int value) {
            this.base.setsockopt(28, value);
            Socket.mayRaise();
        }

        public final long getSendBufferSize() {
            return this.base.getsockopt(11);
        }

        public final void setSendBufferSize(long value) {
            this.base.setsockopt(11, (int)value);
            Socket.mayRaise();
        }

        public final long getReceiveBufferSize() {
            return this.base.getsockopt(12);
        }

        public final void setReceiveBufferSize(long value) {
            this.base.setsockopt(12, (int)value);
            Socket.mayRaise();
        }

        public final boolean hasReceiveMore() {
            return this.base.getsockopt(13) == 1;
        }

        public final SelectableChannel getFD() {
            return (SelectableChannel)this.base.getsockoptx(14);
        }

        public final int getEvents() {
            return this.base.getsockopt(15);
        }

        public final void subscribe(byte[] topic) {
            this.base.setsockopt(6, topic);
            Socket.mayRaise();
        }

        public final void subscribe(String topic) {
            this.subscribe(topic.getBytes());
        }

        public final void unsubscribe(byte[] topic) {
            this.base.setsockopt(7, topic);
            Socket.mayRaise();
        }

        public final void unsubscribe(String topic) {
            this.unsubscribe(topic.getBytes());
        }

        public final void setEncoder(Class<? extends EncoderBase> cls) {
            this.base.setsockopt(1001, cls);
        }

        public final void setDecoder(Class<? extends DecoderBase> cls) {
            this.base.setsockopt(1002, cls);
        }

        public final int bind(String addr) {
            return this.bind(addr, 49152, 65535);
        }

        private final int bind(String addr, int min, int max) {
            if (addr.endsWith(":*")) {
                String prefix = addr.substring(0, addr.lastIndexOf(58) + 1);
                for (int port = min; port <= max; ++port) {
                    addr = prefix + port;
                    if (!this.base.bind(addr)) continue;
                    return port;
                }
                return -1;
            }
            if (this.base.bind(addr)) {
                int port = 0;
                try {
                    port = Integer.parseInt(addr.substring(addr.lastIndexOf(58) + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return port;
            }
            return -1;
        }

        public int bindToRandomPort(String addr) {
            return this.bind(addr + ":*", 49152, 65535);
        }

        public int bindToRandomPort(String addr, int min, int max) {
            return this.bind(addr + ":*", min, max);
        }

        public final boolean connect(String addr_) {
            return this.base.connect(addr_);
        }

        public final boolean send(String data) {
            zmq.Msg msg = new zmq.Msg(data);
            return this.base.send(msg, 0);
        }

        public final boolean sendMore(String data) {
            zmq.Msg msg = new zmq.Msg(data);
            return this.base.send(msg, 2);
        }

        public final boolean send(String data, int flags) {
            zmq.Msg msg = new zmq.Msg(data);
            return this.base.send(msg, flags);
        }

        public final boolean send(byte[] data) {
            zmq.Msg msg = new zmq.Msg(data);
            return this.base.send(msg, 0);
        }

        public final boolean sendMore(byte[] data) {
            zmq.Msg msg = new zmq.Msg(data);
            return this.base.send(msg, 2);
        }

        public final boolean send(byte[] data, int flags) {
            zmq.Msg msg = new zmq.Msg(data);
            return this.base.send(msg, flags);
        }

        public final boolean send(Msg msg) {
            return this.base.send(msg.base, 0);
        }

        public final boolean sendMore(Msg msg) {
            return this.base.send(msg.base, 2);
        }

        public final boolean send(Msg msg, int flags) {
            return this.base.send(msg.base, flags);
        }

        public final byte[] recv() {
            zmq.Msg msg = this.base.recv(0);
            if (msg != null) {
                return msg.data();
            }
            Socket.mayRaise();
            return null;
        }

        public final byte[] recv(int flags) {
            zmq.Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.data();
            }
            Socket.mayRaise();
            return null;
        }

        public final int recv(byte[] buffer, int offset, int len, int flags) {
            zmq.Msg msg = this.base.recv(flags);
            if (msg != null) {
                System.arraycopy(msg.data(), 0, buffer, offset, len);
                return msg.size();
            }
            Socket.mayRaise();
            return -1;
        }

        public final Msg recvMsg() {
            zmq.Msg msg = this.base.recv(0);
            if (msg != null) {
                return new Msg(msg);
            }
            Socket.mayRaise();
            return null;
        }

        public final Msg recvMsg(int flags) {
            zmq.Msg msg = this.base.recv(flags);
            if (msg != null) {
                return new Msg(msg);
            }
            Socket.mayRaise();
            return null;
        }

        public final String recvStr() {
            zmq.Msg msg = this.base.recv(0);
            if (msg != null) {
                return new String(msg.data());
            }
            Socket.mayRaise();
            return null;
        }

        public final String recvStr(int flags) {
            zmq.Msg msg = this.base.recv(flags);
            if (msg != null) {
                return new String(msg.data());
            }
            Socket.mayRaise();
            return null;
        }

        public void dump() {
            System.out.println("----------------------------------------");
            do {
                Msg msg = this.recvMsg(0);
                System.out.println(String.format("[%03d] %s", msg.size(), msg.size() > 0 ? new String(msg.data()) : ""));
            } while (this.hasReceiveMore());
        }
    }

    public static class Context {
        private final Ctx ctx;

        protected Context(int ioThreads) {
            this.ctx = zmq.ZMQ.zmq_init(ioThreads);
        }

        public void term() {
            this.ctx.terminate();
        }

        public Socket socket(int type) {
            return new Socket(this, type);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int size) {
            return new Poller(this, size);
        }
    }
}

