/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq;

import java.io.File;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import org.jeromq.ZLog;

public class ZLogManager {
    private final ZLogConfig conf = new ZLogConfig();
    private final ConcurrentHashMap<String, ZLog> logs = new ConcurrentHashMap();
    private static ThreadLocal<Boolean> initialized = new ThreadLocal();
    private static ZLogManager instance = null;

    private ZLogManager() {
    }

    public ZLogConfig config() {
        return this.conf;
    }

    public ZLog get(String topic) {
        ZLog plog;
        ZLog log = this.logs.get(topic);
        if (log == null && (plog = this.logs.putIfAbsent(topic, log = new ZLog(this.conf, topic))) != null) {
            log = plog;
        }
        return log;
    }

    public String[] topics() {
        return this.logs.keySet().toArray(new String[0]);
    }

    public synchronized void shutdown() {
        for (ZLog log : this.logs.values()) {
            log.close();
        }
        this.logs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZLogManager instance() {
        if (initialized.get() == null) {
            ThreadLocal<Boolean> threadLocal = initialized;
            synchronized (threadLocal) {
                if (instance == null) {
                    instance = new ZLogManager();
                }
                initialized.set(Boolean.TRUE);
            }
        }
        return instance;
    }

    public static class ZLogConfig {
        protected String base_dir;
        protected long segment_size;
        protected long flush_messages;
        protected long flush_interval;
        protected long cleanup_interval;
        protected File base_path;

        private ZLogConfig() {
            this.set("base_dir", System.getProperty("java.io.tmpdir") + "/zlogs");
            this.set("segment_size", 0x20000000L);
            this.set("flush_messages", 10000);
            this.set("flush_interval", 1000);
            this.set("cleanup_interval", 604800000L);
        }

        public ZLogConfig set(String name, Object value) {
            Field field;
            try {
                field = ZLogConfig.class.getDeclaredField(name);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(name);
            }
            try {
                field.set(this, value);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(name + " = " + value + " " + e.toString());
            }
            this.postSet(name, value);
            return this;
        }

        public Object get(String name) {
            Field field;
            try {
                field = ZLogConfig.class.getDeclaredField(name);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(name);
            }
            try {
                return field.get(this);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(name + " " + e.toString());
            }
        }

        public String getString(String name) {
            return (String)this.get(name);
        }

        public int getInt(String name) {
            return (Integer)this.get(name);
        }

        public long getLong(String name) {
            return (Long)this.get(name);
        }

        private void postSet(String name, Object value) {
            File file = null;
            if ("base_dir".equals(name)) {
                file = value == null ? new File(System.getProperty("java.io.tmpdir"), "zlogs") : new File((String)value);
                this.base_dir = file.getAbsolutePath();
                if (file.isFile()) {
                    throw new IllegalArgumentException("base_dir " + value + " cannot be file");
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new RuntimeException("Cannot make directory " + file.getAbsolutePath());
                }
                assert (file.isDirectory());
                this.base_path = file;
            }
        }
    }
}

