/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.TimeUnit;

public final class BusySpinWaitStrategy
implements WaitStrategy {
    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        if (0 == dependents.length) {
            while ((availableSequence = cursor.get()) < sequence) {
                barrier.checkAlert();
            }
        } else {
            while ((availableSequence = Util.getMinimumSequence(dependents)) < sequence) {
                barrier.checkAlert();
            }
        }
        return availableSequence;
    }

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier, long timeout, TimeUnit sourceUnit) throws AlertException, InterruptedException {
        long availableSequence;
        long timeoutMs = sourceUnit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        if (0 == dependents.length) {
            while ((availableSequence = cursor.get()) < sequence) {
                barrier.checkAlert();
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime <= timeoutMs) continue;
                break;
            }
        } else {
            while ((availableSequence = Util.getMinimumSequence(dependents)) < sequence) {
                barrier.checkAlert();
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime <= timeoutMs) continue;
                break;
            }
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }
}

