/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.util.MutableLong;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

public abstract class AbstractMultithreadedClaimStrategy
implements ClaimStrategy {
    private final int bufferSize;
    private final Sequence claimSequence = new Sequence(-1L);
    private final ThreadLocal<MutableLong> minGatingSequenceThreadLocal = new ThreadLocal<MutableLong>(){

        @Override
        protected MutableLong initialValue() {
            return new MutableLong(-1L);
        }
    };

    public AbstractMultithreadedClaimStrategy(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public long getSequence() {
        return this.claimSequence.get();
    }

    @Override
    public boolean hasAvailableCapacity(int availableCapacity, Sequence[] dependentSequences) {
        return this.hasAvailableCapacity(this.claimSequence.get(), availableCapacity, dependentSequences);
    }

    @Override
    public long incrementAndGet(Sequence[] dependentSequences) {
        long nextSequence = this.claimSequence.incrementAndGet();
        this.waitForFreeSlotAt(nextSequence, dependentSequences, this.minGatingSequenceThreadLocal.get());
        return nextSequence;
    }

    @Override
    public long checkAndIncrement(int availableCapacity, int delta, Sequence[] gatingSequences) throws InsufficientCapacityException {
        long sequence;
        while (this.hasAvailableCapacity(sequence = this.claimSequence.get(), availableCapacity, gatingSequences)) {
            long nextSequence = sequence + (long)delta;
            if (!this.claimSequence.compareAndSet(sequence, nextSequence)) continue;
            return nextSequence;
        }
        throw InsufficientCapacityException.INSTANCE;
    }

    @Override
    public long incrementAndGet(int delta, Sequence[] dependentSequences) {
        long nextSequence = this.claimSequence.addAndGet(delta);
        this.waitForFreeSlotAt(nextSequence, dependentSequences, this.minGatingSequenceThreadLocal.get());
        return nextSequence;
    }

    @Override
    public void setSequence(long sequence, Sequence[] dependentSequences) {
        this.claimSequence.set(sequence);
        this.waitForFreeSlotAt(sequence, dependentSequences, this.minGatingSequenceThreadLocal.get());
    }

    private void waitForFreeSlotAt(long sequence, Sequence[] dependentSequences, MutableLong minGatingSequence) {
        long wrapPoint = sequence - (long)this.bufferSize;
        if (wrapPoint > minGatingSequence.get()) {
            long minSequence;
            while (wrapPoint > (minSequence = Util.getMinimumSequence(dependentSequences))) {
                LockSupport.parkNanos(1L);
            }
            minGatingSequence.set(minSequence);
        }
    }

    private boolean hasAvailableCapacity(long sequence, int availableCapacity, Sequence[] dependentSequences) {
        long wrapPoint = sequence + (long)availableCapacity - (long)this.bufferSize;
        MutableLong minGatingSequence = this.minGatingSequenceThreadLocal.get();
        if (wrapPoint > minGatingSequence.get()) {
            long minSequence = Util.getMinimumSequence(dependentSequences);
            minGatingSequence.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }
}

