/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import java.util.concurrent.Executor;

class Backgrounding {
    private final boolean inBackground;
    private final Object context;
    private final BackgroundCallback callback;

    Backgrounding(Object context) {
        this.inBackground = true;
        this.context = context;
        this.callback = null;
    }

    Backgrounding(BackgroundCallback callback) {
        this.inBackground = true;
        this.context = null;
        this.callback = callback;
    }

    Backgrounding(boolean inBackground) {
        this.inBackground = inBackground;
        this.context = null;
        this.callback = null;
    }

    Backgrounding(CuratorFrameworkImpl client, BackgroundCallback callback, Executor executor) {
        this(Backgrounding.wrapCallback(client, callback, executor));
    }

    Backgrounding() {
        this.inBackground = false;
        this.context = null;
        this.callback = null;
    }

    boolean inBackground() {
        return this.inBackground;
    }

    Object getContext() {
        return this.context;
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    private static BackgroundCallback wrapCallback(final CuratorFrameworkImpl client, final BackgroundCallback callback, final Executor executor) {
        return new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework dummy, final CuratorEvent event) throws Exception {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.processResult(client, event);
                        }
                        catch (Exception e) {
                            client.logError("Background operation result handling threw exception", e);
                        }
                    }
                });
            }
        };
    }
}

