/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator;

import com.netflix.curator.HandleHolder;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.drivers.TracerDriver;
import java.io.Closeable;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionState
implements Watcher,
Closeable {
    private volatile long connectionStartMs = 0L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HandleHolder zooKeeper;
    private final AtomicBoolean isConnected = new AtomicBoolean(false);
    private final int connectionTimeoutMs;
    private final AtomicReference<TracerDriver> tracer;
    private final AtomicReference<Watcher> parentWatcher = new AtomicReference<Object>(null);
    private final Queue<Exception> backgroundExceptions = new ConcurrentLinkedQueue<Exception>();
    private static final int MAX_BACKGROUND_EXCEPTIONS = 10;

    ConnectionState(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, Watcher parentWatcher, AtomicReference<TracerDriver> tracer) throws IOException {
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.tracer = tracer;
        this.parentWatcher.set(parentWatcher);
        this.zooKeeper = new HandleHolder(this, connectString, sessionTimeoutMs);
    }

    ZooKeeper getZooKeeper() throws Exception {
        long elapsed;
        Exception exception = this.backgroundExceptions.poll();
        if (exception != null) {
            this.log.error("Background exception caught", (Throwable)exception);
            this.tracer.get().addCount("background-exceptions", 1);
            throw exception;
        }
        boolean localIsConnected = this.isConnected.get();
        if (!localIsConnected && (elapsed = System.currentTimeMillis() - this.connectionStartMs) >= (long)this.connectionTimeoutMs) {
            KeeperException.ConnectionLossException connectionLossException = new KeeperException.ConnectionLossException();
            this.log.error("Connection timed out", (Throwable)connectionLossException);
            this.tracer.get().addCount("connections-timed-out", 1);
            throw connectionLossException;
        }
        return this.zooKeeper.getZooKeeper();
    }

    boolean isConnected() {
        return this.isConnected.get();
    }

    Watcher substituteParentWatcher(Watcher newWatcher) {
        return this.parentWatcher.getAndSet(newWatcher);
    }

    void start() throws Exception {
        this.log.debug("Starting");
        this.reset();
    }

    @Override
    public void close() throws IOException {
        this.log.debug("Closing");
        try {
            this.zooKeeper.closeAndClear();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.isConnected.set(false);
        }
    }

    private void reset() throws Exception {
        this.isConnected.set(false);
        this.connectionStartMs = System.currentTimeMillis();
        this.zooKeeper.closeAndReset();
        this.zooKeeper.getZooKeeper();
    }

    public void process(WatchedEvent event) {
        Watcher localParentWatcher;
        boolean wasConnected;
        boolean newIsConnected = wasConnected = this.isConnected.get();
        if (event.getType() == Watcher.Event.EventType.None) {
            boolean bl = newIsConnected = event.getState() == Watcher.Event.KeeperState.SyncConnected;
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                this.handleExpiredSession();
            }
        }
        if (newIsConnected != wasConnected) {
            this.isConnected.set(newIsConnected);
            this.connectionStartMs = System.currentTimeMillis();
        }
        if ((localParentWatcher = this.parentWatcher.get()) != null) {
            TimeTrace timeTrace = new TimeTrace("connection-state-parent-process", this.tracer.get());
            localParentWatcher.process(event);
            timeTrace.commit();
        }
    }

    private void handleExpiredSession() {
        this.log.warn("Session expired event received");
        this.tracer.get().addCount("session-expired", 1);
        try {
            this.reset();
        }
        catch (Exception e) {
            this.queueBackgroundException(e);
        }
    }

    private void queueBackgroundException(Exception e) {
        while (this.backgroundExceptions.size() >= 10) {
            this.backgroundExceptions.poll();
        }
        this.backgroundExceptions.offer(e);
    }
}

