/*
 * Decompiled with CFR 0.152.
 */
package clojure.osgi.internal;

import clojure.lang.RT;
import clojure.lang.Var;
import clojure.osgi.RunnableWithException;
import clojure.osgi.internal.ClojureOSGi;
import clojure.osgi.internal.StreamLog;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.ServiceTracker;

public class ExtenderTracker
extends BundleTracker {
    private Set<Long> requireProcessed = new HashSet<Long>();
    private Set<Long> active = new HashSet<Long>();
    private ServiceTracker logTracker;
    private LogService log = new StreamLog(System.out);

    public ExtenderTracker(BundleContext context) {
        super(context, 56, null);
        this.logTracker = new ServiceTracker(context, LogService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                return ExtenderTracker.this.log = (LogService)super.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                ExtenderTracker.this.log = new StreamLog(System.out);
            }
        };
        this.logTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (!this.requireProcessed.contains(bundle.getBundleId())) {
            this.processRequire(bundle);
            this.requireProcessed.add(bundle.getBundleId());
        }
        if (!(bundle.getState() != 8 && bundle.getState() != 32 || this.active.contains(bundle.getBundleId()))) {
            try {
                this.invokeActivatorCallback(CallbackType.START, bundle);
            }
            finally {
                this.active.add(bundle.getBundleId());
            }
        }
        if (bundle.getState() == 16 && this.active.contains(bundle.getBundleId())) {
            try {
                this.invokeActivatorCallback(CallbackType.STOP, bundle);
            }
            finally {
                this.active.remove(bundle.getBundleId());
            }
        }
        return null;
    }

    private void processRequire(Bundle bundle) {
        String header = (String)bundle.getHeaders().get("Clojure-Require");
        if (header != null) {
            StringTokenizer lib = new StringTokenizer(header, ",");
            while (lib.hasMoreTokens()) {
                String ns = lib.nextToken().trim();
                if (this.log != null) {
                    this.log.log(4, String.format("requiring %s from bundle %s", ns, bundle));
                }
                ClojureOSGi.require(bundle, ns);
            }
        }
    }

    private String callbackFunctionName(CallbackType callback, String header) {
        switch (callback) {
            case START: {
                return "bundle-start";
            }
            case STOP: {
                return "bundle-stop";
            }
        }
        throw new IllegalStateException();
    }

    private void invokeActivatorCallback(CallbackType callback, final Bundle bundle) {
        final String ns = (String)bundle.getHeaders().get("Clojure-ActivatorNamespace");
        if (ns != null) {
            final String callbackFunction = this.callbackFunctionName(callback, ns);
            final Var var = RT.var((String)ns, (String)callbackFunction);
            if (var.isBound()) {
                try {
                    ClojureOSGi.withBundle(bundle, new RunnableWithException(){

                        @Override
                        public Object run() throws Exception {
                            if (ExtenderTracker.this.log != null) {
                                ExtenderTracker.this.log.log(4, String.format("invoking function %s/%s for bundle: %s", ns, callbackFunction, bundle));
                            }
                            var.invoke((Object)bundle.getBundleContext());
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new RuntimeException(String.format("'%s' is not bound in '%s'", callbackFunction, ns));
            }
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void close() {
        this.logTracker.close();
        super.close();
    }

    private static enum CallbackType {
        START,
        STOP;

    }
}

