(ns hendrick-ring-util.core
  (:require [clojure.java.io :as io]
            [ring.util.response :as response]
            [clojure.stacktrace :as st]
            [taoensso.timbre :as timbre]))

(defn throwable->stack-trace-string [t]
  ;; This is a shorter way of getting a stack trace as a string,
  ;; but does not include whitespace / indentation
  #_(map str
         (interpose "\n" (.getStackTrace t)))

  (let [stream (new java.io.ByteArrayOutputStream)
        writer (io/writer stream)]
    (binding [*out* writer] (st/print-stack-trace t))
    (.flush writer)
    (new String (.toByteArray stream))))

(defn wrap-exception [handler]
  (fn [request]
    (try (handler request)
         (catch Exception e
           (let [stack-trace (throwable->stack-trace-string e)]
             (timbre/error (str "Uncaught Exception: " (.getMessage e) "\n" stack-trace))
             {:status 500
              :body (slurp (io/resource "public/500.html"))})))))

(defn wrap-maintenance [routes]
  (fn [req]
    (if (.exists (io/as-file "/tmp/hendrick-maintenance-mode"))
      (response/response (slurp "http://v2-styleguide.hendrickapps.com/styleguide/apps/issues/index.html"))
      (routes req))))
