(ns hendrick-ring-util.core
  (:require [clojure.java.io :as io]
            [ring.util.response :as response]
            [taoensso.timbre :as timbre]))

(defn wrap-exception [handler]
  (fn [request]
    (try (handler request)
         (catch Exception e
           (.printStackTrace e)
           (timbre/error (str "Uncaught Exception: " (.getMessage e)))
           {:status 500
            :body (slurp (io/resource "public/500.html"))}))))

(defn wrap-maintenance [routes]
  (fn [req]
    (if (.exists (io/as-file "/tmp/hendrick-maintenance-mode"))
      (response/response (slurp "http://v2-styleguide.hendrickapps.com/styleguide/apps/issues/index.html"))
      (routes req))))
