/*
 * Decompiled with CFR 0.152.
 */
package com.hbase.haxwell.api.core;

import com.hbase.haxwell.api.core.HaxwellColumn;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.util.Bytes;

public class HaxwellRow {
    private String tableName;
    private String id;
    private long timestamp;
    private OperationType operation;
    private List<HaxwellColumn> columns;

    public static HaxwellRow create(byte[] tableName, byte[] rowKey, List<Cell> cells, OperationType operationType, long timestamp) {
        List<HaxwellColumn> columns = cells.stream().map(cell -> HaxwellColumn.builder().columnFamily(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell))).columnName(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell))).value(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))).build()).collect(Collectors.toList());
        return HaxwellRow.builder().tableName(Bytes.toString((byte[])tableName)).id(Bytes.toString((byte[])rowKey)).operation(operationType).timestamp(timestamp).columns(columns).build();
    }

    public static HaxwellRowBuilder builder() {
        return new HaxwellRowBuilder();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public OperationType getOperation() {
        return this.operation;
    }

    public List<HaxwellColumn> getColumns() {
        return this.columns;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setOperation(OperationType operation) {
        this.operation = operation;
    }

    public void setColumns(List<HaxwellColumn> columns) {
        this.columns = columns;
    }

    public HaxwellRow(String tableName, String id, long timestamp, OperationType operation, List<HaxwellColumn> columns) {
        this.tableName = tableName;
        this.id = id;
        this.timestamp = timestamp;
        this.operation = operation;
        this.columns = columns;
    }

    public HaxwellRow() {
    }

    public String toString() {
        return "HaxwellRow(tableName=" + this.getTableName() + ", id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", operation=" + (Object)((Object)this.getOperation()) + ", columns=" + this.getColumns() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HaxwellRow)) {
            return false;
        }
        HaxwellRow other = (HaxwellRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        OperationType this$operation = this.getOperation();
        OperationType other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        List<HaxwellColumn> this$columns = this.getColumns();
        List<HaxwellColumn> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HaxwellRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        OperationType $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        List<HaxwellColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    public static class HaxwellRowBuilder {
        private String tableName;
        private String id;
        private long timestamp;
        private OperationType operation;
        private List<HaxwellColumn> columns;

        HaxwellRowBuilder() {
        }

        public HaxwellRowBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public HaxwellRowBuilder id(String id) {
            this.id = id;
            return this;
        }

        public HaxwellRowBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public HaxwellRowBuilder operation(OperationType operation) {
            this.operation = operation;
            return this;
        }

        public HaxwellRowBuilder columns(List<HaxwellColumn> columns) {
            this.columns = columns;
            return this;
        }

        public HaxwellRow build() {
            return new HaxwellRow(this.tableName, this.id, this.timestamp, this.operation, this.columns);
        }

        public String toString() {
            return "HaxwellRow.HaxwellRowBuilder(tableName=" + this.tableName + ", id=" + this.id + ", timestamp=" + this.timestamp + ", operation=" + (Object)((Object)this.operation) + ", columns=" + this.columns + ")";
        }
    }

    public static enum OperationType {
        PUT,
        DELETE,
        UNKNOWN;

    }
}

