/*
 * Decompiled with CFR 0.152.
 */
package com.hbase.haxwell.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class HaxwellTestUtil {
    public static void waitOnReplicationPeerReady(String peerId) {
        long tryUntil = System.currentTimeMillis() + 60000L;
        boolean waited = false;
        while (!HaxwellTestUtil.threadExists(".replicationSource," + peerId)) {
            waited = true;
            if (System.currentTimeMillis() > tryUntil) {
                throw new RuntimeException("Replication thread for peer " + peerId + " didn't start within timeout.");
            }
            System.out.print("\nWaiting for replication source for " + peerId + " to be started...");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (waited) {
            System.out.println("done");
        }
    }

    public static void waitOnReplicationPeerStopped(String peerId) {
        long tryUntil = System.currentTimeMillis() + 60000L;
        boolean waited = false;
        while (HaxwellTestUtil.threadExists(".replicationSource," + peerId)) {
            waited = true;
            if (System.currentTimeMillis() > tryUntil) {
                throw new RuntimeException("Replication thread for peer " + peerId + " didn't stop within timeout.");
            }
            System.out.print("\nWaiting for replication source for " + peerId + " to be stopped...");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (waited) {
            System.out.println("done");
        }
    }

    public static void waitOnAllReplicationPeersStopped() {
        long tryUntil = System.currentTimeMillis() + 60000L;
        boolean waited = false;
        while (HaxwellTestUtil.threadExists(".replicationSource,")) {
            waited = true;
            if (System.currentTimeMillis() > tryUntil) {
                throw new RuntimeException("Replication threads didn't stop within timeout.");
            }
            System.out.print("\nWaiting for replication sources to be stopped...");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (waited) {
            System.out.println("done");
        }
    }

    private static boolean threadExists(String namepart) {
        ThreadInfo[] infos;
        ThreadMXBean threadmx = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = threadmx.getThreadInfo(threadmx.getAllThreadIds())) {
            if (info == null || !info.getThreadName().contains(namepart)) continue;
            return true;
        }
        return false;
    }
}

