/*
 * Decompiled with CFR 0.152.
 */
package com.hbase.haxwell.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.Cell;

public class HaxwellEvent {
    private final byte[] table;
    private final byte[] row;
    private final List<Cell> keyValues;
    private final byte[] payload;

    public HaxwellEvent(byte[] table, byte[] row, List<Cell> keyValues, byte[] payload) {
        this.table = table;
        this.row = row;
        this.payload = payload;
        this.keyValues = keyValues;
    }

    public static HaxwellEvent create(byte[] table, byte[] row, List<Cell> cells, byte[] payload) {
        ArrayList<Cell> keyValues = new ArrayList<Cell>(cells.size());
        for (Cell cell : cells) {
            keyValues.add(cell);
        }
        return new HaxwellEvent(table, row, keyValues, payload);
    }

    public byte[] getTable() {
        return this.table;
    }

    public byte[] getRow() {
        return this.row;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public List<Cell> getKeyValues() {
        return this.keyValues;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HaxwellEvent rhs = (HaxwellEvent)obj;
        return new EqualsBuilder().append(this.table, rhs.table).append(this.row, rhs.row).append(this.keyValues, rhs.keyValues).append(this.payload, rhs.payload).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.table).append(this.row).append(this.keyValues).append(this.payload).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.table).append(this.row).append(this.keyValues).append(this.payload).toString();
    }
}

