package com.hbase.haxwell;

import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * @author phaneesh
 */
public class KafkaMessageProducer {

    private KafkaProducer<String, String> producer;

    private Logger log = LoggerFactory.getLogger(KafkaMessageProducer.class);


    public KafkaMessageProducer(final String brokers, final String acks, final int retries,
                                final int batchSize, final int autoCommitInterval) {
        final Properties props = new Properties();
        props.put("bootstrap.servers", brokers);
        props.put("acks", acks);
        props.put("retries", retries);
        props.put("linger.ms", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("batch.size", batchSize);
        props.put("auto.commit.interval.ms", autoCommitInterval);
        producer = new KafkaProducer<>(props);
    }

    void send(String topic, String key, String message) throws Exception {
        RecordMetadata recordMetadata = producer.send(new ProducerRecord<>(topic, null, key, message)).get();
        if(log.isDebugEnabled()) {
            log.info("Topic: {} | Key: {} | Offset: {} | Partition: {} | Size: {}", topic, key,
                    recordMetadata.offset(), recordMetadata.partition(), recordMetadata.serializedValueSize());
        }
    }
}
