package com.hbase.haxwell;

import com.hbase.haxwell.api.HaxwellEventPublisher;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;

import java.io.IOException;

public class HaxwellDefaultEventPublisher implements HaxwellEventPublisher {

    private final Table payloadTable;
    private final byte[] payloadColumnFamily;
    private final byte[] payloadColumnQualifier;

    /**
     * Construct with the table and column information to which payload data will be written.
     *
     * @param payloadTable table where payload data will be written
     * @param payloadColumnFamily column family where payload data will be written
     * @param payloadColumnQualifier column qualifier under which payload data will be written
     */
    public HaxwellDefaultEventPublisher(Table payloadTable, byte[] payloadColumnFamily, byte[] payloadColumnQualifier) {
        this.payloadTable = payloadTable;
        this.payloadColumnFamily = payloadColumnFamily;
        this.payloadColumnQualifier = payloadColumnQualifier;
    }

    @Override
    public void publishEvent(byte[] row, byte[] payload) throws IOException {
        Put eventPut = new Put(row);
        eventPut.addColumn(payloadColumnFamily, payloadColumnQualifier, payload);
        payloadTable.put(eventPut);
    }

    protected Table getPayloadTable() {
        return this.payloadTable;
    }

}
