/*
 * Decompiled with CFR 0.152.
 */
package com.hbase.haxwell.util;

import java.io.Closeable;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CloseHelper {
    private static final Log log = LogFactory.getLog(CloseHelper.class);

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.error((Object)("Error closing object of type " + closeable.getClass().getName()), t);
            }
        }
    }

    public static void close(Object object) {
        if (object != null) {
            try {
                Method[] methods;
                Method closeMethod = null;
                for (Method method : methods = object.getClass().getMethods()) {
                    if (method.getParameterTypes().length != 0) continue;
                    if (method.getName().equals("close")) {
                        closeMethod = method;
                        break;
                    }
                    if (method.getName().equals("shutdown")) {
                        closeMethod = method;
                        continue;
                    }
                    if (!method.getName().equals("stop")) continue;
                    closeMethod = method;
                }
                if (closeMethod != null) {
                    closeMethod.invoke(object, new Object[0]);
                } else {
                    log.error((Object)("Do not know how to close object of type " + object.getClass().getName()));
                }
            }
            catch (Throwable t) {
                log.error((Object)("Error closing object of type " + object.getClass().getName()), t);
            }
        }
    }
}

