/*
 * Decompiled with CFR 0.152.
 */
package com.hbase.haxwell;

import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessageProducer {
    private KafkaProducer<String, String> producer;
    private Logger log = LoggerFactory.getLogger(KafkaMessageProducer.class);

    public KafkaMessageProducer(String brokers, String acks, int retries, int batchSize, int autoCommitInterval) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokers);
        props.put("acks", acks);
        props.put("retries", (Object)retries);
        props.put("linger.ms", (Object)0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("batch.size", (Object)batchSize);
        props.put("auto.commit.interval.ms", (Object)autoCommitInterval);
        this.producer = new KafkaProducer(props);
    }

    void send(String topic, String key, String message) throws Exception {
        RecordMetadata recordMetadata = (RecordMetadata)this.producer.send(new ProducerRecord(topic, null, (Object)key, (Object)message)).get();
        if (this.log.isDebugEnabled()) {
            this.log.info("Topic: {} | Key: {} | Offset: {} | Partition: {} | Size: {}", new Object[]{topic, key, recordMetadata.offset(), recordMetadata.partition(), recordMetadata.serializedValueSize()});
        }
    }
}

