/*
 * Decompiled with CFR 0.152.
 */
package com.hbase.haxwell;

import javax.management.ObjectName;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsDynamicMBeanBase;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class HaxwellMetrics
implements Updater {
    private final String recordName;
    private final MetricsRegistry metricsRegistry;
    private final MetricsRecord metricsRecord;
    private final MetricsContext context;
    private final HaxwellMetricsMXBean mbean;
    private final MetricsTimeVaryingRate processingRate;
    private final MetricsLongValue lastTimestampInputProcessed;

    public HaxwellMetrics(String recordName) {
        this.recordName = recordName;
        this.metricsRegistry = new MetricsRegistry();
        this.processingRate = new MetricsTimeVaryingRate("haxwellProcessed", this.metricsRegistry);
        this.lastTimestampInputProcessed = new MetricsLongValue("lastHaxwellTimestamp", this.metricsRegistry);
        this.context = MetricsUtil.getContext((String)"repository");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)this.context, (String)recordName);
        this.context.registerUpdater((Updater)this);
        this.mbean = new HaxwellMetricsMXBean(this.metricsRegistry);
    }

    public void shutdown() {
        this.context.unregisterUpdater((Updater)this);
        this.mbean.shutdown();
    }

    public void reportFilteredSepOperation(long duration) {
        this.processingRate.inc(duration);
    }

    public void reportSepTimestamp(long writeTimestamp) {
        this.lastTimestampInputProcessed.set(writeTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        HaxwellMetrics haxwellMetrics = this;
        synchronized (haxwellMetrics) {
            for (MetricsBase m : this.metricsRegistry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public class HaxwellMetricsMXBean
    extends MetricsDynamicMBeanBase {
        private final ObjectName mbeanName;

        public HaxwellMetricsMXBean(MetricsRegistry registry) {
            super(registry, "Haxwell Metrics");
            this.mbeanName = MBeanUtil.registerMBean((String)"haxwell", (String)HaxwellMetrics.this.recordName, (Object)((Object)this));
        }

        public void shutdown() {
            if (this.mbeanName != null) {
                MBeanUtil.unregisterMBean((ObjectName)this.mbeanName);
            }
        }
    }
}

